/**
 * Copyright Keetapol.Boonprachak ( http://wonderfl.net/user/Keetapol.Boonprachak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kgcX
 */

// forked from Keetapol.Boonprachak's CoverFlow step2
// forked from Keetapol.Boonprachak's CoverFlow step1
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
 
    [SWF(frameRate="30",backgroundColor="0x000000")]
    
    public class CoverFlow extends Sprite {
        
        private var _dummy:XML = <data><item /><item /><item /><item /><item /><item /><item /><item /></data>;
        
        private var _container:Sprite;
        private var _items:Vector.<Item>;
        
        private var _currentIndex:uint = 0;
        
        public function CoverFlow() {
            if(stage) onAddedToStage(null);
            else addEventListener(Event.ADDED_TO_STAGE,onAddedToStage);    
        }
        
        private function onAddedToStage(e:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE,onAddedToStage);
            
            stage.addEventListener(Event.RESIZE,onStageResize);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            build(_dummy);
            
            onStageResize(null);
        }
        
        private function onStageResize(e:Event):void
        {
            if(_container && stage)
            {
                _container.x = stage.stageWidth*0.5;
                _container.y = stage.stageHeight*0.5;
            }
        }
        
        private function build(data:XML):void
        {
            _container = new Sprite();
            addChild(_container);
            
            _items = new Vector.<Item>();
            
            for(var i:int = 0; i < data.item.length(); i++)
            {
                var item:Item = new Item();
                _container.addChild(item);
                item.addEventListener(MouseEvent.CLICK,item_CLICK);
                _items.push(item);
            }
                        
            var pp:PerspectiveProjection = new PerspectiveProjection();
            pp.projectionCenter = new Point(0,0);
            _container.transform.perspectiveProjection = pp;

            update(0);
        }
        
        private function update(time:Number = 1):void
        {
            for(var i:int = 0; i < _items.length; i++)
            {
                var offset:int = (i-_currentIndex);
                var X:Number = 130*offset;
                var Z:Number = 100*Math.abs(offset);
                var RY:Number = 0;
                
                if(offset > 0)
                    RY = 70;
                else if(offset < 0)
                    RY = -70;
                
                Tweener.addTween(_items[i],{
                    x:X,
                    z:Z,
                    rotationY:RY,
                    time:time
                });
                
                var numRight:int = _items.length-_currentIndex-1;
                var num:int = (_currentIndex>numRight)?_currentIndex:numRight;
                _container.addChildAt(_items[i],num-Math.abs(offset));
            }
        }
        
        public function goto(index:uint):Boolean
        {
           if(index >= _items.length) return false;
            
            _currentIndex = index;
            update();
            return true;
        }
        
        private function item_CLICK(e:MouseEvent):void
        {
            goto(_items.indexOf(e.currentTarget));
        }



    }
}

import flash.display.Sprite;

class Item extends Sprite
{
    public function Item()
    {
        var w:Number = 200;
        var h:Number = 150;
        graphics.beginFill((0xFFFFFF*0.6)+(0xFFFFFF*0.4)*Math.random());
        graphics.lineStyle(1,0x333333,1,true);
        graphics.drawRect(-w*0.5,-h*0.5,w,h);
        graphics.endFill();
    }
}
