/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kf0n
 */

// forked from bradsedito's forked from: デバイスフォントのフェードアウト・フェードイン
// forked from ProjectNya's デバイスフォントのフェードアウト・フェードイン
////////////////////////////////////////////////////////////////////////////////
// デバイスフォントのフェードアウト・フェードイン
//
// デバイスフォントの透過
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=826
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Timer;
    import flash.events.TimerEvent;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var list:Array;
        private var txtId:uint = 0;
        private var container:Sprite;
        private var txt:Label;
        private var timer:Timer;
        private static var interval:uint = 1000;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            list = ["I", "am", "inspired.","Creative.","Determined","Focused.","Crazy.","Happy.","I am who I am. I like me."];
            //
            container = new Sprite();
            addChild(container);
            container.blendMode = "layer";
            //
            txt = new Label(300, 20, 18, Label.CENTER);
            container.addChild(txt);
            container.x = 82;
            container.y = 222;
            txt.textColor = 0x000000;
            //
            txt.text = list[txtId];
            start();
        }
        private function start():void {
            timer = new Timer(interval, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, transit, false, 0, true);
            timer.start();
        }
        private function transit(evt:TimerEvent):void {
            evt.target.removeEventListener(TimerEvent.TIMER_COMPLETE, transit);
            addEventListener(Event.ENTER_FRAME, fadeOut, false, 0, true);
        }
        private function fadeOut(evt:Event):void {
            container.alpha -= 0.05;
            if (container.alpha <= 0) {
                container.alpha = 0;
                removeEventListener(Event.ENTER_FRAME, fadeOut);
                exchange();
            }
        }
        private function exchange():void {
            txtId = (txtId + 1)%list.length;
            txt.text = list[txtId];
            addEventListener(Event.ENTER_FRAME, fadeIn, false, 0, true);
        }
        private function fadeIn(evt:Event):void {
            container.alpha += 0.05;
            if (container.alpha >= 1) {
                container.alpha = 1;
                removeEventListener(Event.ENTER_FRAME, fadeIn);
                start();
            }
        }
        
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 24, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
