/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kdyF
 */

/**
 * Youtube動画を自分作業用に連続再生
 * 曲を進める「Forward」ボタンと、曲を戻す「Back」ボタンを追加しました
 * 
 * Youtubeの動画IDをベタ書きで配列に設定して連続再生しています
 * Youtubeと連携してる？VEVO(とmercuryrecordsuk)のYoutube上動画のIDを配列にして設定しています
 * U2の動画リストを再生します
 * 問題ありそうなら削除します
 * 
 * ↓参考にさせて頂いたサイト
 * YouTubePlayer API 
 * http://wonderfl.net/c/r5kL
 * YouTube ActionScript 3.0 Player API リファレンス
 * http://code.google.com/intl/ja/apis/youtube/flash_api_reference.html
 *
 *↓参考にした過去の自分のコード(今は動いてないかも)
 * 前回ソースからAmazonアフィリエイト用ボタンを追加してみました　
 * http://wonderfl.net/c/qoWN
 */
package {
    
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent
    import flash.net.URLRequest;
    import flash.system.Security;
    
    [SWF(backgroundColor="0x000000", frameRate="30", width="640", height="400")]
    public class Player extends Sprite {
        
        private var _player:Object;
        private var _loader:Loader;
        private var _movieIdListIndex:int = 0;
        private const _movieIdList:Array = [
            "XmSdTa9kaiQ",    //With Or Without You 
            "co6WMzDOh1o",    //Beautiful Day'
            "GzZWSrr5wFI",    //Where The Streets Have No Name
            "Pu9rQ8lkQ5c",    //Original Of The Species
            "Yi52HjJbwVQ",    //Magnificent 
            "gwKEdFoUB0o",    //Walk On
            "wo-NskE3M2A",    //Window In The Skies (Modernista Version)
            "8xQOb51qZ-c",    //City of Blinding Lights 
            "CuDqHtAR6L8"     //Sometimes You Can't Make It On Your Own 
        ];
        private var _previousBtn : CustomButton; //「Previoius」ボタン 前Youtube動画に遷移
        private var _forwardBtn : CustomButton; //「Forward」ボタン 後Youtube動画に遷移

        /// init
        public function Player() {
            _loader = addChild(new Loader()) as Loader;
            _loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit, false, 0, true);
            _loader.x = 150;
            _loader.y = 70;
            //_loader.load(new URLRequest("http://www.youtube.com/v/NMNgbISmF4I?version=3&enablejsapi=1")); //Youtubeコントローラー付き 最初はといあえずのIdを設定
            _loader.load(new URLRequest("http://www.youtube.com/v/NMNgbISmF4I?version=3")); //Youtubeコントローラー付き 最初はといあえずののIdを設定
        }
        
        
        /// events
        private function onLoaderInit(event:Event):void {
            _loader.content.addEventListener("onReady", onPlayerReady);
            _loader.content.addEventListener("onError", onPlayerError);
            _loader.content.addEventListener("onStateChange", onPlayerStateChange);
            _loader.content.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
        }
        
        private function onPlayerReady(event:Event):void {
            // Event.data contains the event parameter, which is the Player API ID 
            // Once this event has been dispatched by the _player, we can use
            // cueVideoById, loadVideoById, cueVideoByUrl and loadVideoByUrl
            // to load a particular YouTube video.
            _player = _loader.content;

            //_player.setSize(640, 360);
            _player.setSize(352, 230);

            _previousBtn = new CustomButton("Previous");
            _previousBtn.x = 150;
            _previousBtn.y = 10;
            _previousBtn.addEventListener(MouseEvent.MOUSE_DOWN,onPreviousBtnDown);
            addChild(_previousBtn);

            _forwardBtn = new CustomButton("Foward");
            _forwardBtn.x = 400;
            _forwardBtn.y = 10;
            _forwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onForwardBtnDown);
            addChild(_forwardBtn);

            //_player.loadVideoById("NMNgbISmF4I", 0, "default"); //Crazy
            //_player.loadVideoById("qfNmyxV2Ncw", 0, "default"); //Cryin'
            //_player.loadVideoById("CBTOGVb_cQg", 0, "default"); //Ange
            //ect...
            _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //１曲目「With Or Without You」再生
        }
        
        private function onPreviousBtnDown(event:MouseEvent):void {
            if (_movieIdListIndex > 0) { //動画リストの最前列でない場合は動画を1つもどしてプレイ開始
                _movieIdListIndex = _movieIdListIndex - 1;
                _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //配列インデックスで指定して曲再生
            } else if (_movieIdListIndex == 0) {
                _movieIdListIndex = _movieIdList.length - 1 //動画リストが先頭の場合は動画リストの最後尾へ
                _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //配列インデックスで指定して曲再生
            }
        }

        private function onForwardBtnDown(event:MouseEvent):void {
            if (_movieIdList.length - 1 > _movieIdListIndex) { //動画リストの最後列でない場合は動画を1つすすめてプレイ開始
                _movieIdListIndex = _movieIdListIndex + 1;
                _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //配列インデックスで指定して曲再生
            } else if (_movieIdListIndex == _movieIdList.length - 1) {
                _movieIdListIndex = 0 //動画リストが最後尾の場合は動画リストの先頭へ
                _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //配列インデックスで指定して曲再生
            }
        }

        //private function onSearchBtnDown(event:MouseEvent):void {
        //    //encodeURIComponent()を使うことによって、#や日本語にも対応
        //    _urlLoader.load(new URLRequest(APIURL + encodeURIComponent(_searchBox.text)));
        //    if (_movieIdList.lenght > 0) { //動画リストが存在する場合はプレイ開始
        //        _movieIdListIndex = 0;
        //        _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default"); //１曲目再生　うまく動いてない？？？
        //    }
        //}

        private function onPlayerError(event:Event):void {
            // Event.data contains the event parameter, which is the error code
        }
        
        private function onPlayerStateChange(event:Event):void {
            // Event.data contains the event parameter, which is the new _player state
            //プレイヤーの状態を判定
            //未開始（-1）、終了（0）、再生中（1）、一時停止中（2）、バッファリング中（3）、頭出し済み（5）
            if (Object(event).data == "0") { //動画が終了した場合
                _movieIdListIndex++;
                if(_movieIdListIndex > _movieIdList.length - 1) return; //動画IDリストを超えた場合は処理を行わない
                    _player.loadVideoById(_movieIdList[_movieIdListIndex], 0, "default");
            }
        }
        
        private function onVideoPlaybackQualityChange(event:Event):void {
            // Event.data contains the event parameter, which is the new video quality
        }
                
    }
    
}

import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
    private var btnName : String = "";//ボタン名
    private var btnNo : int = 0;//ボタン番号
    //コンストラクタ    
    public function CustomButton(label:String="",no:int=0) {
        btnName = label;
        btnNo = no;
        //状態
        upState = makeSprite(label,0x99DDFF);
        overState = upState;
        downState = makeSprite(label,0x0000FF);
        hitTestState = upState;
    }
    public function getBtnName():String {
        return btnName;
    }
    public function getBtnNo():int {
        return btnNo;
    }
    //ボタン用スプライト作成
    private function makeSprite(text:String,color:uint):Sprite{
        //ボタン用ラベル作成
        var label : TextField = new TextField();
        label.text = text;
        label.autoSize = TextFieldAutoSize.CENTER;
        label.selectable = false;
        //ボタン用スプライト作成
        var sp:Sprite = new Sprite();
        sp.graphics.beginFill(color);
        sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
        sp.graphics.endFill();
        sp.alpha = 0.8;            
        sp.addChild(label);
        //ラベル用フォーマット設定
        var format:TextFormat=new TextFormat();
        format.font = "Courier New";
        format.bold = true;
        format.size = 13;
        label.setTextFormat(format);
        return sp;
    }
}
