/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kdHO
 */

// forked from siouxcitizen's 前回ソースから「まち」の機能の実装
//
//前回ソースから3DPlaneでハリボテの看板とボスを作成しました
//
//まち看板に接触しながら「まち」ボタン押下するとまち機能
//ボス看板に接触しながら「バトる」ボタンを押下するとボスと戦闘
//ボスは攻撃力・防御力・ライフを一回づつ強化すれば倒せるぐらいです
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.filters.GlowFilter;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.objects.parsers.DAE;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    [SWF(width="500", height="500", backgroundColor="#0055FF")]
    public class ThreeDimentionRPGPractice extends Sprite {
        private var goLandScrnBtn : SimpleButton;//ランド画面への遷移ボタン 
        private var goTitleScrnBtn : SimpleButton;//タイトル画面への遷移ボタン
        private var battleBtn : SimpleButton;//「バトる」状態へのボタン
        private var townBtn : SimpleButton;//「まち」状態へのボタン
        private var forwardBtn : SimpleButton;//前進ボタン
        private var leftRotBtn : SimpleButton;//左回転ボタン
        private var rightRotBtn : SimpleButton;//右回転ボタン
        private var backwardBtn : SimpleButton;//後退ボタン
        private var bDashBtn : SimpleButton;//Bダッシュボタン
        private var forwardState : Boolean = false; //操作矢印「前進」制御用
        private var backwardState : Boolean = false; //操作矢印「後退」制御用
        private var bDashState : Boolean = false; //操作矢印「Bダッシュ」制御用
        private var leftRotState : Boolean = false; //操作矢印「左回転」制御用
        private var rightRotState : Boolean = false; //操作矢印「右回転」制御用
        private var screenId : int = 0;  //0:タイトル画面 1:ランド画面
        private const TITLE_SCREEN_ID : int = 0;  //タイトル画面ID
        private const LAND_SCREEN_ID : int = 1;  //ランド画面ID
        private var txtField:Object=new Object(); //テキストフィールド用
        private var txtFormat:Object=new Object();//テキストフォーマット用
        //3D表示用
        private var Objs : Object = new Object(); //3Dオブジェクト保持用
        private var container : Sprite;
        private var viewport : Viewport3D;
        private var scene : Scene3D;
        private var camera : Camera3D;
        private var material : ColorMaterial;
        private var bitmapMaterial : BitmapMaterial;
        private var planeObj : Plane; 
        private var crystalBoxCube : Cube; //透明キューブ　飾り用クリスタル役
        private var renderer : BasicRenderEngine;
        private var materialList : MaterialsList = new MaterialsList();
        private var cameraPitch: int = 90; //カメラのX軸回転の値　
        private var cameraYaw : int = 270; //カメラのY軸回転の値　
        private var cameraDistStat: int = 1; //カメラ設置場所の距離種類　0～2
        private var title3DText : Text3D //タイトル3D文字
        private var letterformat : Letter3DMaterial; //タイトル3D文字フォーマット
        private var tempPlaneName : String;
        private var daeNomaneko : DAE; //操作「のまねこ」用DAE
        //「バトる」用データ
        private var battleStatus : Boolean = false; //「バトる」状態判定
        private const INITIAL_MONEY : int = 100;
        private var statusKeeper : StatusKeeper = new StatusKeeper(100,30,30,INITIAL_MONEY); //操作用キャラステータス保持用　引数1：ライフ、引数2：攻撃力、引数3：防御力、引数4：所持金
        private var planeEnemy : Enemy; //3D敵オブジェクト
        //「バトる」ふきだし用
        private var battleFukidashiContena : Sprite = new Sprite(); //ふきだし入れ物
        private var battleFukidashi : Shape = new Shape(); //ふきだしの黒い外枠
        private var onBattleFukidashi : Shape = new Shape(); //ふきだしのテキスト表示部分
        private var battleComandFukidashiContena : Sprite = new Sprite(); //「バトる」状態コマンド用ふきだし入れ物
        private var battleComandFukidashi : Shape = new Shape(); //「バトる」状態コマンド用ふきだし
        //「バトる」ふきだしで使用するボタン
        private var attackBtn : SimpleButton; //「たたかう」ボタン
        private var escapeBtn : SimpleButton; //「にげる」ボタン
        //「まち」用データ
        private var townStatus : Boolean = false; //「まち」状態判定
        private var maxMoneyEarned : int = INITIAL_MONEY;
        //「まち」ふきだし用
        private var townFukidashiContena : Sprite = new Sprite(); //ふきだし入れ物
        private var townFukidashi : Shape = new Shape(); //ふきだしの黒い外枠
        private var onTownFukidashi : Shape = new Shape(); //ふきだしのテキスト表示部分
        private var townComandFukidashiContena : Sprite = new Sprite(); //「バトる」状態コマンド用ふきだし入れ物
        private var townComandFukidashi : Shape = new Shape(); //「バトる」状態コマンド用ふきだし
        //「まち」ふきだしで使用するボタン
        private var attackPointUpBtn : SimpleButton; //「攻撃力アップ」ボタン1
        private var defencePointUpBtn : SimpleButton; //「防御力」ボタン1
        private var lifePointUpBtn : SimpleButton; //「ライフアップ」ボタン1
        private var exitTownBtn : SimpleButton; //「まちをでる」ボタン
        //攻撃力・防御力・ライフ制御用
        private var attackLevel : int = 1;
        private var defenceLevel : int = 1;
        private var lifeLevel : int = 1;
        private const ATTACK_LEVEL_MAX : int = 5;
        private const DEFENCE_LEVEL_MAX : int = 5;
        private const LIFE_LEVEL_MAX : int = 5;
        private var attackBasePrice : int = 500;
        private var defenceBasePrice : int = 500;
        private var lifeBasePrice : int = 500;
        //Bitmap貼りつけ用
        private var url : String;
        private var urlReq : URLRequest;
        private var loader : Loader;
        private var bmp : Bitmap;
        private var bmd : BitmapData;
        private var count:int = 0;    // 読み込んだ画像数
        private var images : Array;    // 読み込んだBitmap画像保持用配列
        private const LAND_MAP_DATA:Array = //ランド画面用マップデータ配列
            [[ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2],
             [ 2, 1, 1, 0, 0, 0, 0, 0, 1, 1, 2],
             [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
             [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
             [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
             [ 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0],
             [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
             [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
             [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
             [ 2, 1, 1, 0, 0, 0, 0, 0, 1, 1, 2],
             [ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2]]; //0:芝生Bitmap指定、1:砂Bitmap指定、2:水Bitmap指定
        private const IMAGE_URL:Array =
        [
            "http://assets.wonderfl.net/images/related_images/5/55/558c/558cd91da870c2bc32c54502d98d2d447833e1fd",
            "http://assets.wonderfl.net/images/related_images/0/02/0210/02104ec89c3ba9dd49dc3e636d3e97a8d55674f8",
            "http://assets.wonderfl.net/images/related_images/f/f6/f696/f696b4e7bc2541a9812b81fe89a27a1c00fbe447"
        ]; //Bitmap画像URL配列
        private var townKanban : Kanban;
        private var bossKanban : Kanban;
        public function ThreeDimentionRPGPractice() {
            //情報表示用テキストフィールドを初期化
            txtFieldInit();
            //「ふきだし」を初期化
            initFukidashi()
            //3D空間を初期化
            init3DSpace();
            //タイトル画面ボタンを初期化
            initTitleScrnBtn();
            //ランド画面ボタンを初期化
            initLandScrnBtn();
        }
        //テキストフィールドの初期化処理
        private function txtFieldInit():void{
            //テキストフィールド(ラベル)の生成
            txtField["titleScrnInfo"]=Util.makeTxtField(10,10,10,10);//タイトル画面表示用のテキストを設定
            txtField["landScrnInfo"]=Util.makeTxtField(10,10,300,40);//ランド画面表示用のテキストを設定
            txtField["battleFukidashiText"]=Util.makeTxtField(10,10,450,150);//「バトる」ふきだし用のテキストを設定
            txtField["battleStatus"]=Util.makeTxtField(10,10,120,75);//「バトる」ステータス表示用のテキストを設定
            txtField["townFukidashiText"]=Util.makeTxtField(10,10,450,150);//「まち」ふきだし用のテキストを設定
            txtField["townStatus"]=Util.makeTxtField(330,150,150,400);//「まち」状態でのステータス表示用のテキストを設定
            txtField["kaimonoInfo"]=Util.makeTxtField(10,10,300,130);//「かいもの」ふきだし用のテキストを設定
            txtField["attackPointUpPrice"]=Util.makeTxtField(120,150,170,70);//攻撃力アップ値段表示用テキストを設定
            txtField["defencePointUpPrice"]=Util.makeTxtField(120,180,170,70);//防御力アップ値段表示用テキストを設定
            txtField["lifePointUpPrice"]=Util.makeTxtField(120,210,270,70);//ライフポイントアップ値段表示用テキストを設定

            //テキストフォーマットの生成
            txtFormat["titleScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["landScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["battleFukidashiText"]=Util.makeTextFormat(15,0x000000);
            txtFormat["battleStatus"]=Util.makeTextFormat(15,0xEEEEEE);
            txtFormat["townFukidashiText"]=Util.makeTextFormat(15,0x000000);
            txtFormat["townStatus"]=Util.makeTextFormat(15,0xEEEEEE);
            txtFormat["kaimonoInfo"]=Util.makeTextFormat(15,0xFFFFFF);
            txtFormat["attackPointUpPrice"]=Util.makeTextFormat(15,0xFFFFFF);
            txtFormat["defencePointUpPrice"]=Util.makeTextFormat(15,0xFFFFFF);
            txtFormat["lifePointUpPrice"]=Util.makeTextFormat(15,0xFFFFFF);
        }
        //テキストフィールドの編集
        private function editLabel(key:String,text:String):void {
            txtField[key].text=text;
            txtField[key].setTextFormat(txtFormat[key]);        
        }

        //タイトル画面情報テキストを設定
        public function addTitleScrnTxt():void {
            addChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを表示(今回は使用せず)
            editLabel("titleScrnInfo", "");
        }
        //タイトル画面情報テキストを設定解除
        public function removeTitleScrnTxt():void {
            editLabel("titleScrnInfo", "");
            removeChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを非表示(今回は使用せず)
        }
        //ランド画面情報テキストを設定
        private function addLandScrnTxt():void {
            addChild(txtField["landScrnInfo"]);
            var landScrnInfoTxt : String = "A,W,S,D,F,Rボタンで視点変更します" + "\n";
            editLabel("landScrnInfo",landScrnInfoTxt);
        }
        //ランド画面情報テキストを設定解除
        private function removeLandScrnTxt():void {
            editLabel("landScrnInfo", "");
            removeChild(txtField["landScrnInfo"]);
        }
        //「バトる」＆「まち」用ふきだし表示オブジェクトの初期化処理
        private function initFukidashi():void{
            //「バトる」用ふきだし入れ物
            battleFukidashiContena.x = 5;
            battleFukidashiContena.y = 370;
            //「バトる」用ふきだしの黒外枠用の画像を描画
            battleFukidashi.graphics.beginFill(0x333333, 1.0);
            battleFukidashi.graphics.drawRoundRect(0, 0, 480+10, 100 + 10 * 2, 10, 10);
            battleFukidashi.graphics.endFill();
            //「バトる」用ふきだしのテキスト表示部分を描画
            onBattleFukidashi.graphics.beginFill(0xeeeeee, 1.0);
            onBattleFukidashi.graphics.drawRoundRect(0, 0, 480, 100 + 10 , 10, 10);
            onBattleFukidashi.x = onBattleFukidashi.y = 10 / 2;

            //「たたかう」ボタン
            attackBtn = new CustomButton("たたかう");
            attackBtn.addEventListener(MouseEvent.CLICK,attackBtnClick);
            //attackBtn.addEventListener(MouseEvent.MOUSE_OVER,overAttackBtn);
            attackBtn.x = 10;
            attackBtn.y = 95;
            //「にげる」ボタン
            escapeBtn = new CustomButton("にげる");
            escapeBtn.addEventListener(MouseEvent.CLICK,escapeBtnClick);
            //escapeBtn.addEventListener(MouseEvent.MOUSE_OVER,overEscapeBtn);
            escapeBtn.x = 10;
            escapeBtn.y = 125;
            //「バトる」状態コマンド用ふきだし入れ物
            battleComandFukidashiContena.x = 370;
            battleComandFukidashiContena.y = 200;
            //「バトる」状態コマンド用ふきだし
            battleComandFukidashi.graphics.beginFill(0x333333, 1.0);
            battleComandFukidashi.graphics.drawRoundRect(0, 0, 120, 160, 10, 10);
            battleComandFukidashi.graphics.endFill();
            //「バトる」状態コマンド用ふきだしのボタンを設定
            battleComandFukidashiContena.addChild(battleComandFukidashi);
            battleComandFukidashiContena.addChild(attackBtn);
            battleComandFukidashiContena.addChild(escapeBtn);

            //「まち」用ふきだし入れ物
            townFukidashiContena.x = 5;
            townFukidashiContena.y = 370;
            //「まち」用ふきだしの黒外枠用の画像を描画
            townFukidashi.graphics.beginFill(0x333333, 1.0);
            townFukidashi.graphics.drawRoundRect(0, 0, 480+10, 100 + 10 * 2, 10, 10);
            townFukidashi.graphics.endFill();
            //「まち」用ふきだしのテキスト表示部分を描画
            onTownFukidashi.graphics.beginFill(0xeeeeee, 1.0);
            onTownFukidashi.graphics.drawRoundRect(0, 0, 480, 100 + 10 , 10, 10);
            onTownFukidashi.x = onTownFukidashi.y = 10 / 2;

            //「攻撃力アップ」ボタン
            attackPointUpBtn = new CustomButton("攻撃力アップ");
            attackPointUpBtn.addEventListener(MouseEvent.CLICK,attackPointUpBtnClick);
            attackPointUpBtn.addEventListener(MouseEvent.MOUSE_OVER,overAttackPointUpBtn);
            attackPointUpBtn.addEventListener(MouseEvent.MOUSE_OUT,outAttackPointUpBtn);
            attackPointUpBtn.x = 10;
            attackPointUpBtn.y = 150;
            //「防御力アップ」ボタン
            defencePointUpBtn = new CustomButton("防御力アップ");
            defencePointUpBtn.addEventListener(MouseEvent.CLICK,defencePointUpBtnClick);
            defencePointUpBtn.addEventListener(MouseEvent.MOUSE_OVER,overDefencePointUpBtn);
            defencePointUpBtn.addEventListener(MouseEvent.MOUSE_OUT,outDefencePointUpBtn);
            defencePointUpBtn.x = 10;
            defencePointUpBtn.y = 180;
            //「ライフポイントアップ」ボタン
            lifePointUpBtn = new CustomButton("ライフアップ");
            lifePointUpBtn.addEventListener(MouseEvent.CLICK,lifePointUpBtnClick);
            lifePointUpBtn.addEventListener(MouseEvent.MOUSE_OVER,overLifePointUpBtn);
            lifePointUpBtn.addEventListener(MouseEvent.MOUSE_OUT,outLifePointUpBtn);
            lifePointUpBtn.x = 10;
            lifePointUpBtn.y = 210;
            //「まちをでる」ボタン
            exitTownBtn = new CustomButton("まちをでる");
            exitTownBtn.addEventListener(MouseEvent.CLICK,exitTownBtnClick);
            exitTownBtn.addEventListener(MouseEvent.MOUSE_OVER,overExitTownBtn);
            exitTownBtn.addEventListener(MouseEvent.MOUSE_OUT,outExitTownBtn);
            exitTownBtn.x = 10;
            exitTownBtn.y = 260;
            //「まち」状態コマンド用ふきだし入れ物
            townComandFukidashiContena.x = 5;
            townComandFukidashiContena.y = 45;
            //「まち」状態コマンド用ふきだし
            townComandFukidashi.graphics.beginFill(0x333333, 1.0);
            townComandFukidashi.graphics.drawRoundRect(0, 0, 490, 310, 10, 10);
            townComandFukidashi.graphics.endFill();
            //「まち」状態コマンド用ふきだしのボタンを設定
            townComandFukidashiContena.addChild(townComandFukidashi);
            townComandFukidashiContena.addChild(attackPointUpBtn);
            townComandFukidashiContena.addChild(defencePointUpBtn);
            townComandFukidashiContena.addChild(lifePointUpBtn);
            townComandFukidashiContena.addChild(exitTownBtn);
        }
//■■■ふきだしボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■「バトる」ふきだしボタン処理スタート■■■■■■■■■■■■■■■■■■
        //「たたかう」ボタン押下時処理
        private function attackBtnClick(event:MouseEvent):void {
            if (battleStatus == false) { //敵を倒したか、倒された場合に戦闘終了している状態時
                endBattleCommand(); //「バトる」コマンド状態終了処理をよびだす
                return;
            }
            var fukidashiTxt : String;
            var attackPoint : int = 0; //敵に与えたダメージ
            var attackedPoint : int = 0; //敵から受けたダメージ

            attackPoint = statusKeeper.getAttackPoint() - planeEnemy.getDefencePoint(); //敵に与えるダメージを計算 
            attackedPoint = planeEnemy.getAttackPoint() - statusKeeper.getDefencePoint(); //敵から受けたダメージを計算
            //上記減算の差が、正の値(攻撃力＞防御力)の場合ダメージを追加　負の値(防御力＞攻撃力)の場合ダメージは0に設定
            if(attackPoint <= 0) {attackPoint = 0; }
            if(attackedPoint <= 0) {attackedPoint = 0; }

            fukidashiTxt = "「のまねこ」のこうげき\n"
                         + "「" + planeEnemy.getName() + "」に" + attackPoint + "のダメージをあたえた\n";
            planeEnemy.minusLifePoint(attackPoint);
            if (planeEnemy.getLifePoint() <= 0) {
                fukidashiTxt += "「" + planeEnemy.getName() + "」をたおした！\n";
                fukidashiTxt += planeEnemy.getKanePoint() + "カーネを手に入れた！\n";
                statusKeeper.addKanePoint(planeEnemy.getKanePoint());
                //カーネ最高所持金の設定を行う
                if (statusKeeper.getKanePoint() > maxMoneyEarned) {maxMoneyEarned = statusKeeper.getKanePoint();}
                battleFukidashiTextDisplay(fukidashiTxt); //「バトる」用ふきだしテキスト表示
                battleStatus = false;
                return;
            }

            fukidashiTxt += "「" + planeEnemy.getName() + "」のこうげき\n"
                          + "「のまねこ」は" + attackedPoint + "のダメージをうけた\n";
            statusKeeper.minusLifePoint(attackedPoint);
            if (statusKeeper.getLifePoint() <= 0) {
                fukidashiTxt += "「のまねこ」はやられてしまった！\n";
                statusKeeper.setKanePoint((statusKeeper.getKanePoint())/2); //やられた場合カーネポイントを4分の1に設定
                battleFukidashiTextDisplay(fukidashiTxt); //「バトる」用ふきだしテキスト表示
                battleStatusDisplay(); //「バトる」状態ステータス表示
                battleStatus = false;
                return;
            }
            battleFukidashiTextDisplay(fukidashiTxt); //「バトる」用ふきだしテキスト表示
            battleStatusDisplay(); //「バトる」状態ステータス表示
        }
        //「バトる」用ふきだしテキスト表示
        private function battleFukidashiTextDisplay(dispTxt:String):void {
            editLabel("battleFukidashiText",dispTxt);
            battleFukidashiContena.addChild(txtField["battleFukidashiText"]);
        }
        //「バトる」状態ステータスを「バトる」計算後に再表示
        private function battleStatusDisplay():void {
            var battleStatusTxt : String;
            battleStatusTxt = "ライフ: " + statusKeeper.getLifePoint() + "\n" 
                            + "攻撃力: " + statusKeeper.getAttackPoint() + "\n"
                            + "防御力: " + statusKeeper.getDefencePoint() + "\n"
                            + "カーネ: " + statusKeeper.getKanePoint() + "\n";
            editLabel("battleStatus",battleStatusTxt);
            battleComandFukidashiContena.addChild(txtField["battleStatus"]);
        }
        //「にげる」ボタン押下時処理
        private function escapeBtnClick(event:MouseEvent):void {
            endBattleCommand(); //「バトる」コマンド状態終了処理をよびだす
            battleStatus = false;
        }
        //「バトる」コマンド状態終了処理
        private function endBattleCommand():void {
            //「バトる」終了後はライフをもとに戻す
            statusKeeper.fillLifePoint(); 
            //敵オブジェクトリリース
            scene.removeChildByName("planeEnemyBody");
            //「バトる」用ふきだしリリース
            removeChild(battleFukidashiContena);
            //「バトる」状態コマンド用ふきだしリリース
            removeChild(battleComandFukidashiContena);
            //「バトる」後、一時的に非表示にしていたまち看板を再表示
            scene.addChild(townKanban.body, "townKanban"); 
            //「バトる」後、一時的に非表示にしていたボス看板を再表示
            scene.addChild(bossKanban.body, "bossKanban"); 
        }
//■■■「バトる」ふきだしボタン処理エンド■■■■■■■■■■■■■■■■■■■
//■■■「まち」ふきだしボタン処理スタート■■■■■■■■■■■■■■■■■■■
        //「攻撃力アップ」ボタン押下時処理
        //ATTACK_LEVEL_MAX == 5 attackBasePrice == 500
        private function attackPointUpBtnClick(event:MouseEvent):void {
            if (attackLevel < ATTACK_LEVEL_MAX) { //攻撃力がまだMAXとなっていない場合
                if (attackLevel*attackBasePrice <= statusKeeper.getKanePoint()) { //カーネが足りている場合
                    statusKeeper.minusKanePoint(attackLevel*attackBasePrice);
                    statusKeeper.addAttackPoint(1);
                    editKaimonoInfoTxt("攻撃力：+1　"+"カーネ：-"+(attackLevel*attackBasePrice));
                    attackLevel++;
                    dispTownStatusTxt();
                    dispAttackPointUpPriceTxt();
                } else { //カーネ不足時
                    editKaimonoInfoTxt("カーネが不足しています");
                }
            } else { //攻撃力MAX時
                editKaimonoInfoTxt("攻撃力は最高になっています");
            }
        }//「攻撃力アップ」マウスオーバー時処理
        private function overAttackPointUpBtn(event:MouseEvent):void {
            editKaimonoInfoTxt((attackLevel*500) + "カーネで攻撃力を1アップさせます" + "\n");
        }//「攻撃力アップ」マウスアウト時処理
        private function outAttackPointUpBtn(event:MouseEvent):void {
            editKaimonoInfoTxt("\n");
        }
        //「防御力アップ」ボタン押下時処理
        //DEFENCE_LEVEL_MAX == 5 defenceBasePrice == 500
        private function defencePointUpBtnClick(event:MouseEvent):void {
            if (defenceLevel < DEFENCE_LEVEL_MAX) { //防御力がまだMAXとなっていない場合
                if (defenceLevel*defenceBasePrice <= statusKeeper.getKanePoint()) { //カーネが足りている場合
                    statusKeeper.minusKanePoint(defenceLevel*defenceBasePrice);
                    statusKeeper.addDefencePoint(1);
                    editKaimonoInfoTxt("防御力：+1　"+"カーネ：-"+(defenceLevel*defenceBasePrice));
                    defenceLevel++;
                    dispTownStatusTxt();
                    dispDefencePointUpPriceTxt();
                } else { //カーネ不足時
                    editKaimonoInfoTxt("カーネが不足しています");
                }
            } else { //防御力MAX時
                editKaimonoInfoTxt("防御力は最高になっています");
            }
        }//「防御力アップ」マウスオーバー時処理
        private function overDefencePointUpBtn(event:MouseEvent):void {
            editKaimonoInfoTxt((defenceLevel*500) + "カーネで防御力を1アップさせます" + "\n");
        }//「防御力アップ」マウスアウト時処理
        private function outDefencePointUpBtn(event:MouseEvent):void {
            editKaimonoInfoTxt("\n");
        }
        //「ライフアップ」ボタン押下時処理
        //LIFE_LEVEL_MAX == 5 lifeBasePrice == 500
        private function lifePointUpBtnClick(event:MouseEvent):void {
            if (lifeLevel < LIFE_LEVEL_MAX) { //ライフがまだMAXとなっていない場合
                if (lifeLevel*lifeBasePrice <= statusKeeper.getKanePoint()) { //カーネが足りている場合
                    statusKeeper.minusKanePoint(lifeLevel*lifeBasePrice);
                    statusKeeper.addLifePoint(10);
                    statusKeeper.addMaxLifePoint(10);
                    editKaimonoInfoTxt("ライフ：+10　"+"カーネ：-"+(lifeLevel*lifeBasePrice));
                    lifeLevel++;
                    dispTownStatusTxt();
                    dispLifePointUpPriceTxt();
                } else { //カーネ不足時
                    editKaimonoInfoTxt("カーネが不足しています");
                }
            } else { //ライフMAX時
                editKaimonoInfoTxt("ライフは最高になっています");
            }
        }//「ライフアップ」マウスオーバー時処理
        private function overLifePointUpBtn(event:MouseEvent):void {
            editKaimonoInfoTxt((lifeLevel*500) + "カーネでライフを10アップさせます" + "\n");
        }//「ライフアップ」マウスアウト時処理
        private function outLifePointUpBtn(event:MouseEvent):void {
            editKaimonoInfoTxt("\n");
        }
        //「まちをでる」ボタン押下時処理
        private function exitTownBtnClick(event:MouseEvent):void {
            endTownCommand(); //「バトる」コマンド状態終了処理をよびだす
            townStatus = false;
        }//「まちをでる」マウスオーバー時処理
        private function overExitTownBtn(event:MouseEvent):void {
            editKaimonoInfoTxt("「まち」からでて、フィールドに戻ります" + "\n");
        }//「まちをでる」マウスアウト時処理
        private function outExitTownBtn(event:MouseEvent):void {
            editKaimonoInfoTxt("\n");
        }//「まち」状態での攻撃・防御・ライフアップ購入関連情報のテキスト表示
        private function editKaimonoInfoTxt(kaimonoInfoTxt:String):void {
            editLabel("kaimonoInfo",kaimonoInfoTxt);
            townComandFukidashiContena.addChild(txtField["kaimonoInfo"]);
        }//「まち」状態での「現在ステータス」関連テキストを表示
        private function dispTownStatusTxt():void {
            var townStatusTxt : String;
            townStatusTxt = "現在ステータス" + "\n"
                          + "\n"
                          + "ライフ: " + statusKeeper.getLifePoint() + "\n" 
                          + "攻撃力: " + statusKeeper.getAttackPoint() + "\n"
                          + "防御力: " + statusKeeper.getDefencePoint() + "\n"
                          + "カーネ: " + statusKeeper.getKanePoint() + "\n"
                          + "\n"
                          + "最高カーネ貯蓄額：" + "\n" 
                          + maxMoneyEarned + "\n";
            editLabel("townStatus",townStatusTxt);
            townComandFukidashiContena.addChild(txtField["townStatus"]);
        }//「攻撃力アップ」ボタン用のテキストを表示
        private function dispAttackPointUpPriceTxt():void {
            var attackPointUpPriceTxt : String;
            attackPointUpPriceTxt = "攻撃力+1：　" + (attackLevel*500) + "カーネ\n";
            editLabel("attackPointUpPrice",attackPointUpPriceTxt);
            townComandFukidashiContena.addChild(txtField["attackPointUpPrice"]);
        }//「防御力アップ」ボタン用のテキストを表示
        private function dispDefencePointUpPriceTxt():void {
            var defencePointUpPriceTxt : String;
            defencePointUpPriceTxt = "防御力+1：　" + (defenceLevel*500) + "カーネ\n";
            editLabel("defencePointUpPrice",defencePointUpPriceTxt);
            townComandFukidashiContena.addChild(txtField["defencePointUpPrice"]);
        }//「ライフアップ」ボタン用のテキストを表示
        private function dispLifePointUpPriceTxt():void {
            var lifePointUpPriceTxt : String;
            lifePointUpPriceTxt = "ライフ+10：　" + (lifeLevel*500) + "カーネ\n";
            editLabel("lifePointUpPrice",lifePointUpPriceTxt);
            townComandFukidashiContena.addChild(txtField["lifePointUpPrice"]);
        }
        //「まち」コマンド状態終了処理
        private function endTownCommand():void {
            //「まち」用ふきだしリリース
            removeChild(townFukidashiContena);
            //「まち」状態コマンド用ふきだしリリース
            removeChild(townComandFukidashiContena);
        }
//■■■「まち」ふきだしボタン処理エンド■■■■■■■■■■■■■■■■■■■■
//■■■ふきだしボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■タイトル画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //タイトル画面ボタンを初期化する
        public function initTitleScrnBtn():void {
            goLandScrnBtn = new CustomButton("ランド画面");
            goLandScrnBtn.x = 400;
            goLandScrnBtn.y = 280;
            goLandScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goLandScrnBtnDown);
            addChild(goLandScrnBtn);
        }
        //タイトル画面ボタンを非表示にする
        public function hideTitleScrnBtn():void {
            goLandScrnBtn.visible = false;
        }
        //タイトル画面ボタンを表示する
        public function dispTitleScrnBtn():void {
            goLandScrnBtn.visible = true;
        }
//■■■タイトル画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ランド画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //ランド画面ボタンを初期化する
        public function initLandScrnBtn():void {
            //「タイトル画面」ボタン設定
            goTitleScrnBtn = new CustomButton("タイトル画面");
            goTitleScrnBtn.x = 390;
            goTitleScrnBtn.y = 270;
            goTitleScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goTitleScrnBtnDown);
            addChild(goTitleScrnBtn);
            battleBtn = new CustomButton("バトる");
            battleBtn.x = 390;
            battleBtn.y = 300;
            battleBtn.addEventListener(MouseEvent.MOUSE_DOWN,battleBtnDown);
            addChild(battleBtn);
            townBtn = new CustomButton("まち");
            townBtn.x = 390;
            townBtn.y = 330;
            townBtn.addEventListener(MouseEvent.MOUSE_DOWN,townBtnDown);
            addChild(townBtn);

            forwardBtn = new CustomButton("前進");
            forwardBtn.x = 200;
            forwardBtn.y = 410;
            leftRotBtn = new CustomButton("左回転");
            leftRotBtn.x = 90;
            leftRotBtn.y = 440;
            bDashBtn = new CustomButton("Bダッシュ");
            bDashBtn.x = 200;
            bDashBtn.y = 440;
            rightRotBtn = new CustomButton("右回転");
            rightRotBtn.x = 310;
            rightRotBtn.y = 440;
            backwardBtn = new CustomButton("後退");
            backwardBtn.x = 200;
            backwardBtn.y = 470;
            forwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onForwardBtnDown);
            forwardBtn.addEventListener(MouseEvent.MOUSE_UP,onForwardBtnUp);
            forwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onForwardBtnOut);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onLeftRotBtnDown);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_UP,onLeftRotBtnUp);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onLeftRotBtnOut);
            bDashBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBDashBtnDown);
            bDashBtn.addEventListener(MouseEvent.MOUSE_UP,onBDashBtnUp);
            bDashBtn.addEventListener(MouseEvent.MOUSE_OUT,onBDashBtnOut);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onRightRotBtnDown);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_UP,onRightRotBtnUp);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onRightRotBtnOut);
            backwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBackwardBtnDown);
            backwardBtn.addEventListener(MouseEvent.MOUSE_UP,onBackwardBtnUp);
            backwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onBackwardBtnOut);
            addChild(forwardBtn);
            addChild(leftRotBtn);
            addChild(bDashBtn);
            addChild(rightRotBtn);
            addChild(backwardBtn);

            //ランド画面に遷移するまでボタンを非表示
            hideLandScrnBtn();
        }
        //ランド画面ボタンを非表示
        private function hideLandScrnBtn():void {
            goTitleScrnBtn.visible = false;
            battleBtn.visible = false;
            townBtn.visible = false;
            forwardBtn.visible = false;
            leftRotBtn.visible = false;
            rightRotBtn.visible = false;
            backwardBtn.visible = false;
            bDashBtn.visible = false;
        }
        //ランド画面ボタンを再表示
        private function dispLandScrnBtn():void {
            goTitleScrnBtn.visible = true;
            battleBtn.visible = true;
            townBtn.visible = true;
            forwardBtn.visible = true;
            leftRotBtn.visible = true;
            rightRotBtn.visible = true;
            backwardBtn.visible = true;
            bDashBtn.visible = true;
        }
//■■■ランド画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■3D空間を初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //3D空間を初期化
        private function init3DSpace():void {
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            viewport.opaqueBackground = 0x0055FF;
            addChild(viewport);
            //シーン生成
            scene = new Scene3D();
            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

             //カメラ設定
            camera = new Camera3D();
            camera.y = 200;
            camera.target = DisplayObject3D.ZERO;

            //タイトル文字の設定　引数は色コード・透過度
            letterformat = new Letter3DMaterial(0xFF9999 , 0.9);
            letterformat.doubleSided = true
            title3DText = new Text3D("3D RPG Practice 04" , new HelveticaBold() , letterformat);
            title3DText.y += 400;
            title3DText.scale = 1;
            Objs["title3DText"] = title3DText;
            scene.addChild(Objs["title3DText"], "title3DText");

            //最初のクエスト画面用に3Dオブジェクト初期化
            var tempBlueColorMaterial : ColorMaterial = new ColorMaterial(0x0000EE, 0.5);
            tempBlueColorMaterial.doubleSided = true;
            var tempRedColorMaterial : ColorMaterial = new ColorMaterial(0xEE0000, 0.5);
            tempRedColorMaterial.doubleSided = true;
            var tempGreenColorMaterial : ColorMaterial = new ColorMaterial(0x00EE00, 0.5);
            tempGreenColorMaterial.doubleSided = true;
            materialList.addMaterial(tempRedColorMaterial, "front");
            materialList.addMaterial(tempBlueColorMaterial, "back");
            materialList.addMaterial(tempGreenColorMaterial, "right");
            materialList.addMaterial(tempBlueColorMaterial, "left");
            materialList.addMaterial(tempRedColorMaterial, "top");
            materialList.addMaterial(tempGreenColorMaterial, "bottom");
            //飾り用3Dクリスタル表示
            crystalBoxCube = new Cube(materialList, 350, 350, 350);
            Objs["crystalBoxCube"] = crystalBoxCube;
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");

            //ランド画面土台3DPlaneオブジェクトにBitmap画像を貼りつけ
            images = new Array(IMAGE_URL.length);
            for (var i:int = 0; i < IMAGE_URL.length; i++) {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
                loader.load(new URLRequest(IMAGE_URL[i]), new LoaderContext(true));
                loader.name = i.toString();
            }

            //DAEファイルより3D「のまねこ」を読み込み生成
            daeNomaneko = new DAE();
            daeNomaneko.load("http://oretaikan.atukan.com/ActionScript/DaeTest/DaeTest10/nomaNeko.dae");
            daeNomaneko.scale = 50;
            Objs["daeNomaneko"] = daeNomaneko;

            townKanban = new Kanban("まちへ\nようこそ!", 0, 1500, 1500, "", 200, 0x1A2630, 0xDDDD00);
            bossKanban = new Kanban("ボスです\nようこそ!!!", 0, 1500, 3000, "", 200, 0xEEEEEE, 0x111111);
            Objs["townKanban"] = townKanban;
            Objs["bossKanban"] = bossKanban;

            //マウスイベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }

        private function onComplete(e:Event):void
        {
            bmp = new Bitmap();
            bmd = new BitmapData(e.currentTarget.loader.width, e.currentTarget.loader.height, true, 0x000000)
            bmd.draw(e.currentTarget.loader);
            bmp.bitmapData = bmd;
            images[e.currentTarget.loader.name] = bmp;           
            if (++count == IMAGE_URL.length) initPlaneWithBitmap();
        }

        //ランド画面土台3DPlaneオブジェクトにBitmap画像を貼りつけ
        private function initPlaneWithBitmap():void { 
            //ランド画面土台Planeオブジェクト設定
            for (var xIndex:int = 0; xIndex < LAND_MAP_DATA.length; xIndex++) {
                var horizontalMapData:Array = LAND_MAP_DATA[xIndex];
                for (var zIndex:int = 0; zIndex < horizontalMapData.length; zIndex++) {
                    var mapData:int = horizontalMapData[zIndex]
                    var bmp:Bitmap = images[mapData];
                    var material:BitmapMaterial = new BitmapMaterial(bmp.bitmapData, true);

                    planeObj = new Plane(material, 300, 300, 1, 1);
                    planeObj.name = "planeX" + xIndex + "_Z" + zIndex;
                    planeObj.x = (300 * xIndex);
                    planeObj.z = 300 * zIndex;
                    planeObj.rotationX += 90;
                    planeObj.name = "green";
                    //Planeオブジェクトに名前を割り振り
                    //7行3列の場合の名前例："planeX7_Z3"
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    Objs[tempPlaneName] = planeObj;
                }
            }
        }
//■■■イベント処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //イベント処理
        private function onEnterFrame(e:Event):void{
            if (screenId == TITLE_SCREEN_ID) {
                title3DText.rotationX -= 10;
                crystalBoxCube.rotationX = viewport.mouseY; //飾り用クリスタルの座標をマウス座標から設定
                crystalBoxCube.rotationY = viewport.mouseX; //飾り用クリスタルの座標をマウス座標から設定
                setCameraForTitleScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            } else if (screenId == LAND_SCREEN_ID) {
                calcNomanekoPos(); //操作用3D「のまねこ」座標を計算
                calcKanbanPos(); //看板用3DPlane座標を計算
                setCameraForLandScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            }
        }
        //ランド画面の操作用3D「のまねこ」座標を計算
        private function calcNomanekoPos():void{
            if (forwardState == true) {//前進
                daeNomaneko.moveForward(-30);
            } else if (backwardState == true) {//後退
                daeNomaneko.moveForward(30);
            } else if (leftRotState == true) {//左回転
                daeNomaneko.rotationY -= 10;
            } else if (rightRotState == true) {//右回転
                daeNomaneko.rotationY += 10;
            } else if (bDashState == true) {//Bダッシュ
                daeNomaneko.moveForward(-60);
            }
        }
        //ランド画面の看板用3DPlane座標を計算
        private function calcKanbanPos():void{
            townKanban.body.rotationY += 5;
            bossKanban.body.rotationY += 7;
        }
        //タイトル画面用カメラ視点設定
        private function setCameraForTitleScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            camera.x=cameraDist*Math.cos((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.x;  
            camera.z=cameraDist*Math.sin((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.z;
            camera.target.x=crystalBoxCube.x;
            camera.target.y=crystalBoxCube.y;
            camera.target.z=crystalBoxCube.z;
            cameraPitch = 90; //カメラのX軸回転の値　
            cameraYaw = 270; //カメラのY軸回転の値
            camera.orbit(cameraPitch, cameraYaw, true, crystalBoxCube);
        }
        //ランド画面用カメラ視点設定
        private function setCameraForLandScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            if (cameraDistStat == 0) {
                cameraDist = -500;
            } else if (cameraDistStat == 1) {
                cameraDist = -1000;
            } else if (cameraDistStat == 2) {
                cameraDist = -1500;
            }
            camera.x=cameraDist*Math.cos((90-daeNomaneko.rotationY)*Math.PI/180)+daeNomaneko.x;  
            camera.z=cameraDist*Math.sin((90-daeNomaneko.rotationY)*Math.PI/180)+daeNomaneko.z;
            camera.target.x=daeNomaneko.x;
            camera.target.y=daeNomaneko.y;
            camera.target.z=daeNomaneko.z;
            camera.orbit(cameraPitch, cameraYaw, true, daeNomaneko);
        }

        private function onKeyDown(event:KeyboardEvent):void{
            if (screenId == TITLE_SCREEN_ID) {return;} //タイトル画面の場合は何も処理を行わない
            //Aボタン　操作オブジェクトを中心にカメラを左回り回転(Y軸回転)
            //4度づつ左回り回転  
            if (event.keyCode == 65) {
                cameraYaw = cameraYaw - 4;
                if(cameraYaw < 0) {cameraYaw = 360;}
            //Dボタン　操作オブジェクトを中心にカメラを右回り回転(Y軸回転)    
            //4度づつ右回り回転
            } else if (event.keyCode == 68) {
                cameraYaw = cameraYaw + 4;
                if(cameraYaw > 360) {cameraYaw = 0;}
            //Wボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 87) {        
                if(cameraPitch > 50) {cameraPitch = cameraPitch - 10;}
            //Sボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 83) {           
                if(cameraPitch < 100) {cameraPitch = cameraPitch + 10;}
            //Fボタン　カメラと操作オブジェクトの距離を変更
            } else if (event.keyCode == 70) {
                cameraDistStat -= 1;
                if(cameraDistStat < 0) {cameraDistStat = 2;}
            //Rボタン　カメラの初期化　カメラの距離と高さを初期状態に設定＆操作矢印の真後ろに設定
            } else if (event.keyCode == 82) {
                cameraDistStat = 1;
                cameraPitch = 80; //カメラのX軸回転の値　
                cameraYaw = 90 - daeNomaneko.rotationY;
            }
        }
//■■■イベント処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■3D空間を初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■画面遷移ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■タイトル画面←→ランド画面　遷移処理スタート■■■■■■■■■■■■■■■■■■
        //タイトル画面からランド画面に遷移
        private function goLandScrnBtnDown(evt:MouseEvent):void {
            hideTitleScrnBtn(); //タイトル画面ボタンを非表示
            dispLandScrnBtn(); //ランド画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeTitleScrn3DObjs();
            addLandScrn3DObjs();

            addLandScrnTxt(); //ランド画面情報テキストを設定

            //スクリーンID設定
            screenId = LAND_SCREEN_ID;

            //ランド画面用のカメラ初期設定
            cameraDistStat = 1;
            cameraPitch = 80;
        }
        //ランド画面からタイトル画面に遷移
        private function goTitleScrnBtnDown(evt:MouseEvent):void {
            hideLandScrnBtn(); //ランド画面ボタンを非表示
            dispTitleScrnBtn(); //タイトル画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeLandScrn3DObjs();
            addTitleScrn3DObjs();

            removeLandScrnTxt(); //ランド画面情報テキストを設定解除

            //スクリーンID設定
            screenId = TITLE_SCREEN_ID;
        }
        //タイトル画面に3Dオブジェクトをセット
        private function addTitleScrn3DObjs():void {
            scene.addChild(Objs["title3DText"], "title3DText");
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");
        }
        //タイトル画面の3Dオブジェクトをリリース
        private function removeTitleScrn3DObjs():void {
            scene.removeChildByName("title3DText");
            scene.removeChildByName("crystalBoxCube");
        }
        //ランド画面に3Dオブジェクトをセット
        private function addLandScrn3DObjs():void {
            var horizontalLength:int = LAND_MAP_DATA[0].length; //ランドマップ配列内の子配列1つ分の長さ
            for (var xIndex:int = 0; xIndex < LAND_MAP_DATA.length; xIndex++){
                for (var zIndex:int = 0; zIndex < horizontalLength; zIndex++){
                    //3DPlaneオブジェクトを取り出す
                    //Planeオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："planeX7_Z3" 
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    scene.addChild(Objs[tempPlaneName], tempPlaneName);
                }
            }
            //操作「のまねこ」をセット
            daeNomaneko = Objs["daeNomaneko"];
            daeNomaneko.y = 180;
            daeNomaneko.x = 1500; 
            daeNomaneko.z = 750;
            daeNomaneko.rotationY = 180;
            scene.addChild(daeNomaneko, "daeNomaneko");

            //看板Planeをセット
            townKanban = Objs["townKanban"];
            bossKanban = Objs["bossKanban"];
            scene.addChild(townKanban.body, "townKanban");
            scene.addChild(bossKanban.body, "bossKanban");
        }
        //ランド画面から3Dオブジェクトをリリース
        private function removeLandScrn3DObjs():void {
            //ランドマップ配列分の処理
            var horizontalLength:int = LAND_MAP_DATA[0].length; //ランドマップ配列内の子配列1つ分の長さ
            for (var xIndex:int = 0; xIndex < LAND_MAP_DATA.length; xIndex++){
                //ランドマップ配列内の子配列1行分のデータを処理
                for (var zIndex:int = 0; zIndex < horizontalLength; zIndex++){
                    //3DPlaneオブジェクトをリリース
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    scene.removeChildByName(tempPlaneName);
                }
            }
            scene.removeChildByName("daeNomaneko");
            scene.removeChildByName("townKanban");
            scene.removeChildByName("bossKanban");
        }
//■■■タイトル画面←→ランド画面　遷移処理エンド■■■■■■■■■■■■■■■■■■■
//■■■ランド画面←→「バトる」状態への遷移処理スタート■■■■■■■■■■■■■■■■
        private function battleBtnDown(evt:MouseEvent):void {
            if (!battleStatus) {
                //敵オブジェクト設定
                if (!(daeNomaneko.hitTestObject(bossKanban.body))) { //ボス看板接触時以外　「白い紙切れ」
                    planeEnemy = new Enemy(daeNomaneko.rotationY + 180, daeNomaneko.x, daeNomaneko.z);
                    scene.addChild(planeEnemy.body, "planeEnemyBody");
                } else { //ボス看板接触時　「黒い紙切れ」
                    planeEnemy = new Enemy(daeNomaneko.rotationY + 180, daeNomaneko.x, daeNomaneko.z, 30, 35, 29, 300, 0x111111, "黒い紙切れ");
                    scene.addChild(planeEnemy.body, "planeEnemyBody");
                }
                scene.removeChildByName("townKanban"); //「バトる」時はまち看板を一時的に非表示
                scene.removeChildByName("bossKanban"); //「バトる」時はボス看板を一時的に非表示

                //「バトる」状態用ふきだし設定
                var fukidashiTxt : String;
                fukidashiTxt = "「" + planeEnemy.getName() + "」が現れた！"
                editLabel("battleFukidashiText",fukidashiTxt);
                addChild(battleFukidashiContena);
                battleFukidashiContena.addChild(battleFukidashi);
                battleFukidashiContena.addChild(onBattleFukidashi);
                battleFukidashiContena.addChild(txtField["battleFukidashiText"]);
                //「バトる」状態コマンド用ふきだし設定
                addChild(battleComandFukidashiContena);
                var battleStatusTxt : String;
                battleStatusTxt = "ライフ: " + statusKeeper.getLifePoint() + "\n" 
                                + "攻撃力: " + statusKeeper.getAttackPoint() + "\n"
                                + "防御力: " + statusKeeper.getDefencePoint() + "\n"
                                + "カーネ: " + statusKeeper.getKanePoint() + "\n";
                editLabel("battleStatus",battleStatusTxt);
                battleComandFukidashiContena.addChild(txtField["battleStatus"]);
                battleStatus = true;
            }
        }
//■■■ランド画面←→「バトる」状態への遷移処理エンド■■■■■■■■■■■■■■■■■
//■■■ランド画面←→「まち」状態への遷移処理スタート■■■■■■■■■■■■■■■■■
        private function townBtnDown(evt:MouseEvent):void {
            if (!townStatus) {
                //まち看板に触れていない場合は「まち」処理を行わない
                if (!(daeNomaneko.hitTestObject(townKanban.body))) { return; } 
                //「まち」状態用ふきだし設定
                var fukidashiTxt : String;
                fukidashiTxt = "「まち」に入りました"
                editLabel("townFukidashiText",fukidashiTxt);
                addChild(townFukidashiContena);
                townFukidashiContena.addChild(townFukidashi);
                townFukidashiContena.addChild(onTownFukidashi);
                townFukidashiContena.addChild(txtField["townFukidashiText"]);
                //「まち」状態コマンド用ふきだし設定
                addChild(townComandFukidashiContena);

                dispTownStatusTxt();
                dispAttackPointUpPriceTxt();
                dispDefencePointUpPriceTxt();
                dispLifePointUpPriceTxt();

                townStatus = true;
            }
        }
//■■■ランド画面←→「まち」状態への遷移処理エンド■■■■■■■■■■■■■■■■■
//■■■画面遷移ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ランド画面ボタン処理スタート(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■
        //前進ボタン押下時処理設定
        private function onForwardBtnDown(evt:MouseEvent):void {
            forwardState = true;
        }
        //前進ボタンリリース時処理設定1
        private function onForwardBtnUp(evt:MouseEvent):void {
            forwardState = false;
        }
        //前進ボタンリリース時処理設定2
        private function onForwardBtnOut(evt:MouseEvent):void {
            forwardState = false;
        }
        //後退ボタン押下時処理設定
        private function onBackwardBtnDown(evt:MouseEvent):void {
            backwardState = true;
        }
        //後退ボタンリリース時処理設定1
        private function onBackwardBtnUp(evt:MouseEvent):void {
            backwardState = false;
        }
        //後退ボタンリリース時処理設定2
        private function onBackwardBtnOut(evt:MouseEvent):void {
            backwardState = false;
        }
        //左回転ボタン押下時処理設定
        private function onLeftRotBtnDown(evt:MouseEvent):void {
            leftRotState = true;
        }
        //左回転ボタンリリース時処理設定1
        private function onLeftRotBtnUp(evt:MouseEvent):void {
            leftRotState = false;
        }
        //左回転ボタンリリース時処理設定2
        private function onLeftRotBtnOut(evt:MouseEvent):void {
            leftRotState = false;
        }
        //右回転ボタン押下時処理設定
        private function onRightRotBtnDown(evt:MouseEvent):void {
            rightRotState = true;
        }
        //右回転ボタンリリース時処理設定1
        private function onRightRotBtnUp(evt:MouseEvent):void {
            rightRotState = false;
        }
        //右回転ボタンリリース時処理設定2
        private function onRightRotBtnOut(evt:MouseEvent):void {
            rightRotState = false;
        }
        //Bダッシュボタン押下時処理設定
        private function onBDashBtnDown(evt:MouseEvent):void {
            bDashState = true;
        }
        //Bダッシュボタンリリース時処理設定1
        private function onBDashBtnUp(evt:MouseEvent):void {
            bDashState = false;
        }
        //Bダッシュボタンリリース時処理設定2
        private function onBDashBtnOut(evt:MouseEvent):void {
            bDashState = false;
        }
//■■■ランド画面ボタン処理エンド(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
    }
}
//■■■操作キャラステータス保持クラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//操作キャラのステータス保持を行うクラスを作成
class StatusKeeper
{
    private var maxLifePoint : int = 100;　
    private var lifePoint : int = 100;　
    private var attackPoint : int = 30;
    private var defencePoint : int = 30;
    private var kanePoint : int = 100;　
    public function StatusKeeper(initLifePoint:int=100,initAttackPoint:int=30,initDefencePoint:int=30,initKanePoint:int=100):void {
        this.maxLifePoint = initLifePoint;　
        this.lifePoint = initLifePoint;　
        this.attackPoint = initAttackPoint;
        this.defencePoint = initDefencePoint;
        this.kanePoint = initKanePoint;
    }
    
    //ライフポイント用メソッド
    public function fillLifePoint():void {
        this.lifePoint = maxLifePoint;
    }
    public function addLifePoint(addPoint:int):void {
        this.lifePoint += addPoint;
    }   
    public function minusLifePoint(minusPoint:int):void {
        this.lifePoint -= minusPoint;
    }
    public function getLifePoint():int {
        return this.lifePoint;
    }
    //MAXライフポイント用メソッド
    public function addMaxLifePoint(addPoint:int):void {
        this.maxLifePoint += addPoint;
    }
    public function getMaxLifePoint():int {
        return this.maxLifePoint;
    }

    //攻撃力・防御力用メソッド
    public function getAttackPoint():int {
        return this.attackPoint;
    }
    public function getDefencePoint():int {
        return this.defencePoint;
    }
    public function addAttackPoint(addPoint:int):void {
        this.attackPoint += addPoint;
    }
    public function addDefencePoint(addPoint:int):void {
        this.defencePoint += addPoint;
    }

    //カーネポイント用メソッド
    public function addKanePoint(addPoint:int):void {
        this.kanePoint += addPoint;
        if (this.kanePoint > 9999) {this.kanePoint = 9999}
    }
    public function minusKanePoint(minusPoint:int):void {
        this.kanePoint -= minusPoint;
        if (this.kanePoint < 0) {this.kanePoint = 0}
    }
    public function getKanePoint():int {
        return this.kanePoint;
    }
    public function setKanePoint(newKanePoint:int):void {
        this.kanePoint = newKanePoint;
    }
}
//■■■看板クラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.display.BitmapData;
import org.papervision3d.objects.primitives.Plane;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.special.CompositeMaterial;
//看板用Planeを作成
class Kanban
{
    public var body : Plane; //看板用Plane
    public function Kanban(kanbanTxt:String="Nothing", kanbanRotation:int=0, kanbanX:int=0, kanbanZ:int=0, 
                           font:String="", size:int=200, fontColor:uint=0xFFFFFF, bgColor:uint=0x000000):void {
        //テキストデータ設定
        var format:TextFormat;
        format = new TextFormat(font, size, fontColor);
        var tf:TextField = new TextField();
        tf.defaultTextFormat = format;
        tf.text = kanbanTxt;
        tf.autoSize = TextFieldAutoSize.LEFT;

        //Bitmapデータ設定
        var bd:BitmapData = new BitmapData(tf.width, tf.height, true, 0xF);
        bd.draw(tf);

        //マテリアル設定
        var material:CompositeMaterial = new CompositeMaterial();
        material.addMaterial(new ColorMaterial(bgColor));
        material.addMaterial(new BitmapMaterial(bd, true));
        material.doubleSided = true;

        body= new Plane(material, 300, 300, 1, 1);
        body.x = kanbanX; //X軸の初期値を設定
        body.y = 250; //Y軸の初期値を設定
        body.z = kanbanZ; //Z軸の初期値を設定
        body.rotationY = kanbanRotation; //初期Y軸角度を設定
    }
    
    //
    public function getPara():void {
    }
}                             
//■■■Plane敵クラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import org.papervision3d.objects.primitives.Plane;  
import org.papervision3d.materials.ColorMaterial;
//敵Planeを作成
class Enemy
{
    public var body : Plane; //敵本体Plane
    private var speedX : int = 0; //敵PlaneX方向速度
    private var speedZ : int = 0; //敵PlaneZ方向速度　
    private const SPEED : int = 30; //敵Planeの速度
    private var distX : int = 0; //敵PlaneX方向距離
    private var distZ : int = 0; //敵PlaneZ方向距離　
    private const DIST : int = 700; //ユーザー操作キャラからの敵Planeの距離
    private var colorMaterial : ColorMaterial;
    private var lifePoint : int = 20;　
    private var attackPoint : int = 35;
    private var defencePoint : int = 20;
    private var kanePoint : int = 50;
    private var name : String = "白い紙切れ";
    public function Enemy(figRotation:int=0, figX:int=0, figZ:int=0,
                          lifePoint:int=20, attackPoint:int=35, defencePoint:int=20, kanePoint:int=50,
                          matColor:uint=0xEEEEEE, name:String="白い紙切れ"):void {
        this.lifePoint = lifePoint;　
        this.attackPoint = attackPoint;
        this.defencePoint = defencePoint;
        this.kanePoint = kanePoint;
        this.name = name;

        colorMaterial = new ColorMaterial(matColor);
        colorMaterial.doubleSided = true;
        body = new Plane(colorMaterial, 300, 300, 1, 1);
        body.x = figX; //　敵のX軸の初期値を設定
        body.y = 250; //　敵のY軸の初期値を設定
        body.z = figZ; //　敵のZ軸の初期値を設定
        body.rotationY = figRotation; //角度を操作キャラと同じにする

        //弾丸速度をX軸の速度成分に分解
        speedX = SPEED * Math.cos((90-figRotation)*Math.PI/180);
        //弾丸速度をZ軸の速度成分に分解
        speedZ = SPEED * Math.sin((90-figRotation)*Math.PI/180);

        //敵Planeの距離をX軸の距離成分に分解
        distX = DIST * Math.cos((90-figRotation)*Math.PI/180);
        //敵Planeの距離をZ軸の距離成分に分解
        distZ = DIST * Math.sin((90-figRotation)*Math.PI/180);

        body.x += distX;
        body.z += distZ;
    }
    
    //X軸とZ軸の速度成分を加算して、X軸とZ軸の移動先の座標を計算
    public function move():void {
        body.x += speedX;
        body.z += speedZ;
    }
    //ライフポイントを返す
    public function getLifePoint():int {
        return lifePoint;
    }
    //ライフポイント減算メソッド
    public function minusLifePoint(minusPoint:int):void {
        lifePoint -= minusPoint;
    }

    //攻撃力を返す 
    public function getAttackPoint():int {
        return attackPoint;
    }
    //防御力を返す
    public function getDefencePoint():int {
        return defencePoint;
    }
    //カーネポイントを返す
    public function getKanePoint():int {
        return kanePoint;
    }
    //敵名前を返す
    public function getName():String {
        return name;
    }
}                                         
//■■■カスタムボタンクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
        private var btnName : String = "";//ボタン名
        private var btnNo : int = 0;//ボタン番号
        //コンストラクタ    
        public function CustomButton(label:String="",no:int=0) {
            btnName = label;
            btnNo = no;
            //状態
            upState = makeSprite(label,0x999999);
            overState = upState;
            downState = makeSprite(label,0x0000FF);
            hitTestState = upState;
        }
        public function getBtnName():String {
            return btnName;
        }
        public function getBtnNo():int {
            return btnNo;
        }
        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;
            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);
            return sp;
        }
}
//■■■ユーティリティクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.AntiAliasType;
import flash.text.TextFormatAlign;
//ユーティリティ
class Util
{
    //テキストフィールドの生成
    public static function makeTxtField(posX:int,posY:int,width:int,height:int):TextField {
        var label:TextField=new TextField();
        label.selectable=false;
        label.x       =posX;
        label.y       =posY;
        label.width   =width;
        label.height  =height;
        label.antiAliasType=AntiAliasType.ADVANCED;
        return label;
    }
    //テキストフォーマットの生成
    public static function makeTextFormat(size:uint,color:uint,
        align:String=TextFormatAlign.LEFT):TextFormat {
        var format:TextFormat=new TextFormat();
        format.font ="Courier New"; // 等幅フォント
        format.size =size;  
        format.color=color;
        format.bold =true;
        format.align=align;
        return format;
    }
}