/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kc39
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;

   [SWF(frameRate="30", backgroundColor="#333333")]
	public class HSVTest extends Sprite{
		private var _color:uint = 0xFFFFFF;
		private var prog:int = 0;

		public function set color( value:uint ):void{
			_color = value;
			updateView();
		}
		
		public function HSVTest(){
			addEventListener( Event.ENTER_FRAME, changeColor );
		}
		
		private function changeColor( event:Event ):void{
			prog++;
			var h:Number = prog;
			var s:Number = ( Math.sin( prog / 100 ) + 1 ) * 0.25 + 0.5;
			var v:Number = ( Math.cos( prog / 50 ) + 1 ) * 0.25 + 0.5;
			color = HSVtoRGB( h, s, v );
		}
		
		private function HSVtoRGB( h:Number, s:Number, v:Number ):uint{
			var r:Number, g:Number, b:Number;
			if( s != 0 ){
				h %= 360;
				var hi:uint = h / 60 % 6;
				var f:Number = h / 60 - hi;
				var p:Number = v * ( 1 - s );
				var q:Number = v * ( 1 - f * s );
				var t:Number = v * ( 1 - ( 1 - f ) * s );
				switch( hi ){
					case 0: r = v; g = t; b = p; break;
					case 1: r = q; g = v; b = p; break;
					case 2: r = p; g = v; b = t; break;
					case 3: r = p; g = q; b = v; break;
					case 4: r = t; g = p; b = v; break;
					case 5: r = v; g = p; b = q; break;
				}
			} else r = g = b = v;
			return ( 0xFF * r << 16 ) + ( 0xFF * g << 8 ) + ( 0xFF * b );
		}
		
		private function updateView():void{
		    graphics.clear();
			graphics.beginFill( _color );
			graphics.drawCircle(100,100,50);
		}
	}
}