/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kbuj
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.geom.*;
  import flash.net.URLRequest;
  import flash.system.LoaderContext;
  
  [SWF(frameRate="10")]
  public class ch36ex2 extends Sprite {
    protected const SIZE:Rectangle = new Rectangle(0, 0, 48, 48);
    protected const SCALE:int = 4;
    protected var TOTALFRAMES:int;
    protected var bmp1:BitmapData; //on the left, no smoothing
    protected var bmp2:BitmapData; //on the right, smoothing
    protected var filmstrip:BitmapData;
    protected var frame:int = 0;
    public function ch36ex2() {
      var loader:Loader = new Loader();
      //Animation by Derek Yu - www.derekyu.com - used with permission
      loader.load(
        new URLRequest("http://actionscriptbible.com/files/monkey.png"),
        new LoaderContext(true));
      loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad);
      
      bmp1 = new BitmapData(SIZE.width * SCALE, SIZE.height * SCALE);
      bmp2 = bmp1.clone();
      var bitmap:Bitmap = new Bitmap(bmp1);
      addChild(bitmap);
      bitmap = new Bitmap(bmp2);
      addChild(bitmap);
      bitmap.x = bmp1.width + 10;
    }
    protected function onLoad(event:Event):void {
      filmstrip = Bitmap(LoaderInfo(event.target).content).bitmapData;
      TOTALFRAMES = filmstrip.width / SIZE.width;
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      frame = ++frame % TOTALFRAMES;
      //clear the bitmaps
      bmp1.fillRect(bmp1.rect, 0);
      bmp2.fillRect(bmp2.rect, 0);
      //shift the filmstrip left to put the correct frame in place; scale up
      var transform:Matrix = new Matrix();
      transform.translate(-frame * SIZE.width, 0);
      transform.scale(SCALE, SCALE);
      //omit sourceRect, let bitmap's own size clip the output
      bmp1.draw(filmstrip, transform, null, null, null, false);
      bmp2.draw(filmstrip, transform, null, null, null, true);
    }
  }
}