/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kbVa
 */

package {
    
    import flash.display.Sprite;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.events.Event;
    
    public class Electricity extends Sprite {
        
        private var startPoint:Point = new Point ( 10, 10 );
        private var lineCount:uint = 1;
        private var breakCounts:Point = new Point ( 4, 20 );
        private var offsetAngles:Point = new Point ( 2, 10 );
        private var electricitySprite:Sprite = new Sprite ();
        
        public function Electricity () {
        
            addEventListener ( Event.ENTER_FRAME, core );
            
            addChild ( electricitySprite );
            electricitySprite.filters = [new GlowFilter ( 0x0000FF, .5, 20, 20, 2 )];

        }
        
        private function core ( event:Event ) :void {
            
            var endPoint:Point = new Point ( mouseX, mouseY );
            var distance:Number = Point.distance ( endPoint, startPoint );
            var electroAngle:Number = Math.atan2 ( endPoint.y - startPoint.y, endPoint.x - startPoint.x );
            electricitySprite.graphics.clear ();
            electricitySprite.graphics.lineStyle ( 1, 0x0000FF, .8 );
            for ( var i:uint; i <= lineCount; i++ ) {
                var breakCount:uint = Math.floor ( Math.random () * ( breakCounts.y - breakCounts.x ) ) + breakCounts.x;
                var breakDistance:Number = distance / breakCount;
                electricitySprite.graphics.moveTo ( startPoint.x, startPoint.y );
                for ( var j:uint = 0; j <= breakCount; j++ ) {
                    var currentOffset:uint = Math.floor ( Math.random () * ( offsetAngles.y - offsetAngles.x ) ) + offsetAngles.x;
                    var selectDirection:int = 1;
                    if ( Math.random () >= .5 )
                        selectDirection = -1;
                    var currentAngle:Number = electroAngle + selectDirection * currentOffset * ( Math.PI / 180 );
                    electricitySprite.graphics.lineTo ( startPoint.x + ( j * breakDistance ) * Math.cos ( currentAngle ), startPoint.y + ( j * breakDistance ) * Math.sin ( currentAngle ) );
                }
            }
            
        }
        
    }
    
}