/**
 * Copyright y_tti ( http://wonderfl.net/user/y_tti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kb8G
 */

/*

■参考
http://net2.cocolog-nifty.com/blog/2009/11/post-dbea.html

XY GetCrossPoint(XY a1, XY a2, XY b1, XY b2)
{
　　XY tmp;　　// 計算用

　　// １つめの式
　　float v1a = (a1.y - a2.y) / (a1.x - a2.x);
　　float v1b = (a1.x*a2.y - a1.y*a2.x) / (a1.x - a2.x);

　　// ２つめの式
　　float v2a = (b1.y - b2.y) / (b1.x - b2.x);
　　float v2b = (b1.x*b2.y - b1.y*b2.x) / (b1.x - b2.x);

　　// 最終的な交点
　　tmp.x = (v2b-v1b) / (v1a-v2a);
　　tmp.y = v1a * tmp.x + v1b;

　　return tmp;　　// x,yの答えを返す
}

*/

package
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;

    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0xFFFFFF")]
    public class CrossTest1 extends Sprite
    {
        private var _state:int = 0;
        private var _line1:Line;
        private var _line2:Line;
        
        public function CrossTest1()
        {
            addEventListener(Event.ADDED_TO_STAGE ,_init);
        }

        private function _init(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE ,_init);
            
            _line1 = new Line();
            addChild(_line1);
            _line2 = new Line();
            addChild(_line2);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN , _mouseDownHandler); 
        }
        
        private function _mouseDownHandler(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_DOWN , _mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_MOVE , _mouseMoveHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP , _mouseUpHandler );
            
            if(_state == 0){
                _line1.sPoint = new Point(mouseX,mouseY);
            } else if(_state == 1) {
                _line2.sPoint = new Point(mouseX,mouseY);
                
            }
        }
        
        private function _mouseUpHandler(e:MouseEvent):void {
            stage.addEventListener(MouseEvent.MOUSE_DOWN , _mouseDownHandler);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE , _mouseMoveHandler);
            stage.removeEventListener(MouseEvent.MOUSE_UP , _mouseUpHandler );
            _state++;
            if(_state >=2){
                _line1.clear();
                _line2.clear();
                this.graphics.clear();
                _state = 0;
            }
            
        }
        
        private function _mouseMoveHandler(e:MouseEvent):void {
            if(_state == 0){
                _line1.ePoint = new Point(mouseX,mouseY);
                _line1.update();
            } else if(_state == 1) {
                _line2.ePoint = new Point(mouseX,mouseY);
                _line2.update();
                
                var p:Point = _getCrossPoint(_line1.sPoint,_line1.ePoint,_line2.sPoint,_line2.ePoint);
                this.graphics.clear();
                this.graphics.beginFill(0xFF0000,1);
                this.graphics.drawCircle(p.x,p.y,4);
            }
        }
        
        private function _getCrossPoint(a1:Point , a2:Point , b1:Point , b2:Point):Point {
            var tmp:Point = new Point();
            
            // １つめの式
            var v1a:Number = (a1.y - a2.y) / (a1.x - a2.x);
            var v1b:Number = (a1.x*a2.y - a1.y*a2.x) / (a1.x - a2.x);
            
            // ２つめの式
            var v2a:Number = (b1.y - b2.y) / (b1.x - b2.x);
            var v2b:Number = (b1.x*b2.y - b1.y*b2.x) / (b1.x - b2.x);
            
            // 最終的な交点
            tmp.x = (v2b-v1b) / (v1a-v2a);
            tmp.y = v1a * tmp.x + v1b;
            
            return tmp;　　// x,yの答えを返す
        }
        
    }
}
import flash.display.Shape;
import flash.geom.Point;

class Line extends Shape {
    public var sPoint:Point;
    public var ePoint:Point;
    public function Line():void{
        
    }
    
    public function update():void{
        this.graphics.clear();
        this.graphics.lineStyle(2,0x0,1);
        this.graphics.moveTo(sPoint.x,sPoint.y);
        this.graphics.lineTo(ePoint.x,ePoint.y);
    }
    
    public function clear():void{
        this.graphics.clear();
    }
}
