/**
 * Copyright kuma360 ( http://wonderfl.net/user/kuma360 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ka0l
 */

//言葉と音楽の力を借りてみる。
package {
    
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.getTimer;
    
    [SWF(width = "465", height = "465", frameRate = "30" , backgroundColor='#000000' )]
    public class Main extends Sprite {
        
        ///////////////////
        public function Main () {
            
            var sound:CmySound = new CmySound ;
            addChild ( sound ) ;
            
            var img:CimageLoader = new CimageLoader ;
            addChild ( img ) ;
            
            var mei:Cmeigen = new Cmeigen ;
            addChild ( mei ) ;
            
            var last:int = getTimer() ;
            addEventListener (
                Event.ENTER_FRAME ,
                function () :void {
                    
                    sound.update() ;
                    
                    if ( 3000 < getTimer() - last  && 100 < sound.RUN() ) {
                        img.change ( ) ;
                        mei.change ( ) ;
                        last = getTimer() ;
                    }
                    
                }
            ) ;
            
        }
        
    }
}

import flash.display.*;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.geom.ColorTransform;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.media.Sound;
import flash.media.SoundLoaderContext;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.events.IOErrorEvent;
import flash.utils.ByteArray;
import flash.system.Security;
import flash.media.SoundMixer;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.core.easing.*;

class Cimg extends Sprite {
    
    public var _bd:BitmapData = new BitmapData ( __WIDTH , __HEIGHT , true , 0 ) ;
    public var _b :Bitmap = new Bitmap ( _bd ) ;
    public var _it:ITween;
    
    public function Cimg () {
        _b.alpha = 0 ;
        addChild ( _b ) ;
    }
    
    private function itClear ():void {
        if ( _it ) {
            _it.stop () ;
            _it = null ;
        }
    }
    
    public function setTween_IN () :void {
        itClear () ;
        _it = BetweenAS3.tween ( _b , { alpha:1 , _blurFilter:{blurX:0,blurY:0} } , { alpha:0 , _blurFilter:{blurX:30,blurY:10} } , .5 ) ;
        _it.play();
    }
    
    public function setTween_OUT ():void {
        itClear() ;
        _it = BetweenAS3.to ( _b , { alpha:0 } , 1 ) ;
        _it.play () ;
    }
    
    public function colorTransform ( color:uint ):void {
        _bd.colorTransform ( _bd.rect , new ColorTransform ( 1, 1, 1, 1, 255, 255, 255 ) ) ;
        _bd.colorTransform ( _bd.rect , new ColorTransform ( ( ( color >> 16 ) & 0xFF ) / 255 , ( ( color >> 8 ) & 0xFF ) / 255 , ( ( color ) & 0xFF ) / 255 ) ) ;
    }
    
}


class CimageLoader extends Cimg {
    
    private const _FEED:String = "http://api.flickr.com/services/feeds/photos_public.gne?tags=kamakura&format=rss_200";
    private const _MEDIA:Namespace = new Namespace ( "http://search.yahoo.com/mrss/" ) ; 

    private var _v:Vector.<Cimg> = new Vector.<Cimg> ;
    private var _bindex:int = 0 ;
    private var _index:int = 0 ;
    
    ////////////////////
    public function CimageLoader ( ) {
        
        var ldr:URLLoader = new URLLoader;
        ldr.addEventListener (
            IOErrorEvent.IO_ERROR,
            function (e:Event):void {
                trace(e.type);
            }
        );
        ldr.addEventListener ( Event.COMPLETE, function _load(e:Event):void {
            ldr.removeEventListener(Event.COMPLETE, _load);
            loaded ( XML(ldr.data).._MEDIA::thumbnail.@url.toXMLString().split('\n') );
        } );
        ldr.load ( new URLRequest ( _FEED ) ) ;
        
        this.setTween_IN();

    }
   
    ////////////////////
    private function loaded ( $images:Array ) :void {
        
        for ( var i:int = 0; i < $images.length ; ++i ) {
            
            var ldr:Loader;
            ldr = new Loader;
            ldr.contentLoaderInfo.addEventListener ( Event.COMPLETE , loadComp ) ;
            
            var strArray:String = $images[ i ].replace ( "_s" , "" ) ;
            ldr.load ( new URLRequest ( strArray ) , new LoaderContext ( true ) ) ;
            
        }
        
    }
    
    ////////////////////
    private function loadComp ( e:Event ) :void {
        
        var data:Bitmap = e.target.content as Bitmap ;
        
        if ( data ) {
            
            var C:Cimg = new Cimg ;
            addChild ( C ) ;
            
            var SCALE:Number = 1 ;
            SCALE = 400 / data.height ;
            
            var M:Matrix = new Matrix ;
            M.scale ( SCALE , SCALE ) ;
            M.translate ( ( __WIDTH - data.width * SCALE ) / 2 , ( __HEIGHT - data.height * SCALE ) / 2 ) ;
            C._bd.draw ( data , M ) ;
            
            _v.push ( C ) ;
            
        }
        
    }
    
    ////////////////////
    public function change ( ):void {
        
        _bindex = _index ;
        _index = Math.floor ( Math.random() * _v.length ) ;
        if ( _bindex == _index ) {
            return ;
        }
         
        if ( _bindex < _v.length ) {
            _v[_bindex].setTween_OUT() ;
        }
        
        if ( _index < _v.length ) {
            _v[_index].setTween_IN () ;
        }
        
    }
    
}


////////////////////////////////////
class Cmeigen extends Cimg {
    
    private var _v:Vector.<Cimg> = new Vector.<Cimg> ;
    
    private var _bindex:int = 0 ;
    private var _index:int = 0 ;
    
    ////////////////////
    public function Cmeigen () {
       
        default xml namespace = new Namespace ( "http://www.w3.org/2005/Atom" ) ;
        
        var A:URLLoader = new URLLoader ( ) ;
        
        A.addEventListener (
            IOErrorEvent.IO_ERROR,
            function (e:Event):void {
                trace(e.type);
            }
        );
        
        A.addEventListener (
            Event.COMPLETE,
            function ( e:Event ) :void {
                
                var tf:TextField = new TextField ;
                tf.width = 465 ;
                tf.height = 465 ;
                tf.defaultTextFormat = new TextFormat ( null , 15 , 0xFFFFFF , null , null , null , null , null , "center" ) ;
                tf.autoSize = "center" ;
                tf.textColor = 0xFFFFFFF ;
                
                var myXML:XML = new XML ( e.currentTarget.data ) ;
                var L:int = myXML.entry.length() ;
                
                for ( var I:int = 0 ; I < L ; I++ ) {
                    
                    var T1:String = myXML.entry[I].title ;
                    var T2:String = T1.slice ( T1.search ( "@meigenbot" ) + 10 ) ;
                    
                    T2 = T2.replace ( ":" , "" ) ;
                    T2 = T2.replace ( "◆" , "" ) ;
                    
                    //スマートな方法が分からない
                    var LEN:int = T1.length ;
                    for ( var J:int = 0 ; J < LEN ; ++ J ) {
                        T2 = T2.replace ( "、" , "\n\n" ) ;
                        T2 = T2.replace ( "。" , "\n\n" ) ;
                    }
                    
                    if ( 5 < T2.length && T2.length < 60 ) {
                        
                        tf.text = T2 ;
                        
                        var Y:int = 465 / 2 - tf.height / 2 - 100 ;
                        
                        var mat:Matrix = new Matrix ;
                        mat.identity ( ) ;
                        mat.translate ( 0 , Y ) ;
                        
                        var C:Cimg = new Cimg;
                        addChild ( C ) ;
                        
                        var R:Rectangle = tf.getRect ( C ) ;
                        R.x       = 0 ;
                        R.y       =   Y - 20 ;
                        R.width   = 465 ;
                        R.height  += 40 ;
                        
                        var TB:BitmapData = new BitmapData ( 465 , 465 , true , 0 ) ;
                        TB.draw ( tf , mat ) ;
                        TB.applyFilter ( TB , TB.rect , new Point , new BlurFilter ( 18 , 18 , 3 ) ) ;
                        TB.draw ( TB , null , null , "add" ) ;
                        TB.draw ( tf , mat ) ;
                        
                        C._bd.fillRect ( C._bd.rect , 0 ) ;
                        C._bd.fillRect ( R , 0x60000000 ) ;
                        C._bd.draw ( TB ) ;
                        
                        _v.push ( C ) ;
                        
                    }
                    
                }
                
            }
            
        );
        
        //拝借 @meigenbot
        //A.load ( new URLRequest ( "a.txt" ) ) ;
        A.load ( new URLRequest ( "http://search.twitter.com/search.atom?q=%40meigenbot&rpp=100" ) ) ;
        
        this.setTween_IN();
       
    }
    
    
    ////////////////////
    public function change ( ):void {
        
        _bindex = _index ;
        _index = Math.floor ( Math.random() * _v.length ) ;
        if ( _bindex == _index ) {
            return ;
        }
         
        if ( _bindex < _v.length ) {
            _v[_bindex].setTween_OUT() ;
            
        }
        
        if ( _index < _v.length ) {
            //_v[_index].colorTransform ( color ) ;
            _v[_index].setTween_IN () ;
        }
        
    }
    
}


//fork from [http://wonderfl.net/c/5ddY]    
class CmySound extends Cimg {
    
    private const _s:ByteArray = new ByteArray();
    
    ////////////////////////////////////
    public function CmySound():void {
        
        Security.loadPolicyFile("http://hycro.crz.jp/crossdomain.xml");
        
        var s:Sound = new Sound( 
            new URLRequest("http://hycro.crz.jp/wonderfl/sound/u-chi-u.mp3"), 
            new SoundLoaderContext(1000, true) 
        );
        
        s.play();
        
        this.setTween_IN () ;
       
    }
    
    
    
    ////////////////////////////////////
    public function RUN ():Number {
        
        var I:int = 0 ;
        var v:int = 512 / 4 ;
        var avg:Number= 0 ;
        
        _s.position = 0 ;
        SoundMixer.computeSpectrum ( _s, true , v ) ;
        return _s.readFloat() * 100 ;
        
        /*
        for ( I = 0 ; I < v ; ++ I ) {
            avg += _s.readFloat() * 100 ;
        }
        
        return avg / v ;
        */
    }
    
    
    ////////////////////////////////////
    public function update ( ):void {
        
        var I:int = 0 ;
        var V:Number = 0 ;
        
        _bd.fillRect ( _bd.rect , 0 ) ;
        
        _s.position = 0 ;
        SoundMixer.computeSpectrum ( _s, false , 0 ) ;
        for ( I = 0 ; I < 256 ; ++ I ) {
            V = _s.readFloat() * 100 + 230 ;
            _bd.setPixel32 ( 465 * I / 256 , V , 0x60FFFFFF ) ;
        }
        for ( I = 0 ; I < 256 ; ++ I ) {
            V = _s.readFloat() * 100 + 230 ;
            _bd.setPixel32 ( 465 * I / 256 , V , 0x60FFFFFF ) ;
        }
        
    }
    
    
}



//////////////////////////////////////////////////////
var __WIDTH  :int = 465 ;
var __HEIGHT :int = 465 ;
