/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kZhA
 */

// forked from 0color's forked from: [PV3D] サウンドビジュアライザー (残像付き)
// forked from clockmaker's [PV3D] サウンドビジュアライザー (残像付き)
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.media.*;
    import flash.net.*;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;

    public class Main extends BasicView {
        
        private var soundChannel        :SoundChannel;
        private var sphere              :Sphere;
        
        public function Main() {
            // 背景を黒に設定
            viewport.opaqueBackground = 0x000000;
            
            // エフェクトレイヤーを作成
            var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, 465, 465);
            bfx.addEffect(new BitmapLayerEffect(new BlurFilter(16, 16, 2)));
            bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 0.2, 0.2, 0.15), BlendMode.ADD);
            bfx.clippingPoint = new Point(0, -10);
            viewport.containerSprite.addLayer(bfx);
            
            // 球体を作成
            var material:WireframeMaterial = new WireframeMaterial(0x0099FF);
            sphere = new Sphere(material, 800, 20, 20);
            scene.addChild(sphere);
            
            // エフェクトレイヤーに追加
            bfx.addDisplayObject3D(sphere);
            
            // 音楽読み込み
            var sound:Sound = new Sound(new URLRequest("http://clockmaker.jp/labs/wonderfl/music.mp3"));
            soundChannel = sound.play();
            
            // レンダリング
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            // 音量取得
            var volume:Number = (soundChannel.leftPeak + soundChannel.rightPeak) / 2;
            
            // 球体のスケールを制御
            sphere.scale -= 0.02;
            sphere.scale = Math.max(volume, sphere.scale);
            
            // 球体の回転を制御
            sphere.rotationX += soundChannel.leftPeak * 10;
            sphere.rotationY += soundChannel.rightPeak * 5;
        }
    }
}
