/**
 * Copyright Hiiragi ( http://wonderfl.net/user/Hiiragi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kZUu
 */

// forked from ProjectNya's PanelMenu (1)
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] じわっと出るパネル
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1063
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.MouseEvent;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class PanelTest extends Sprite {
        private var panel:PanelMenu;
        private var blurMenu:TabMenu;
        private var fadeMenu:TabMenu;
        private var blured:Boolean = true;
        private var faded:Boolean = false;

        public function PanelTest() {
            //Wonderfl.capture_delay(1);
            draw();
            init();
        }

        private function init():void {
            panel = new PanelMenu();
            addChild(panel);
            panel.x = 232;
            panel.y = 232;
            panel.init(290, 170);
            panel.blur(0.5);
            blurMenu = new TabMenu();
            addChild(blurMenu);
            blurMenu.x = 395;
            blurMenu.y = 0;
            blurMenu.init({id: 0, label: "blurFilter effect", width: 120, direction: TabMenu.DOWN});
            blurMenu.addEventListener(MouseEvent.CLICK, blur, false, 0, true);
            fadeMenu = new TabMenu();
            addChild(fadeMenu);
            fadeMenu.x = 70;
            fadeMenu.y = 465;
            fadeMenu.init({id: 1, label: "fadeIn / fadeOut", width: 120, direction: TabMenu.UP});
            fadeMenu.addEventListener(MouseEvent.CLICK, fade, false, 0, true);
        }
        private function blur(evt:MouseEvent):void {
            var target:Number = (blured = !blured) ? 0.5 : 1;
            panel.blur(target);
        }
        private function fade(evt:MouseEvent):void {
            var target:Number = (faded = !faded) ? 0 : 1;
            panel.fade(target);
        }
        private function draw():void {
            var tile:Tile = new Tile();
            var bitmapdata:BitmapData = new BitmapData(tile.width, tile.height);
            var colorTrans:ColorTransform = new ColorTransform();
            colorTrans.color = 0x99CCCC;
            bitmapdata.draw(tile, null, colorTrans);
            graphics.beginBitmapFill(bitmapdata, null, true);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            /*
            var tile:BitmapAsset = BitmapAsset(new Tile());
            var bitmapdata:BitmapData = new BitmapData(tile.width, tile.height);
            var colorTrans:ColorTransform = new ColorTransform();
            colorTrans.color = 0x99CCCC;
            bitmapdata.draw(tile, null, colorTrans);
            graphics.beginBitmapFill(bitmapdata, null, true);
            graphics.drawRect(0, 0, 500, 300);
            graphics.endFill();
            */
        }

    }

}


import flash.display.Bitmap;
import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.filters.DropShadowFilter;
import flash.filters.BlurFilter;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.GridFitType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.display.BitmapData

class PanelMenu extends Sprite {
    private var _width:uint;
    private var _height:uint;
    private var txt:TextField;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var fontType:String = "_ゴシック";
    private var scale:Number = 1;
    private var targetScale:Number;
    private var depth:Number = 0;
    private var targetAlpha:Number;
    private static var deceleration:Number = 0.5;

    
    public function PanelMenu() {
    }

    public function init(w:uint, h:uint):void {
        _width = w;
        _height = h;
        draw();
    }
    private function draw():void {
        var base:Shape = new Shape();
        addChild(base);
        createBase(base);
        var shade:DropShadowFilter = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 2, 3, false, false);
        base.filters = [shade];
        var light:Shape = new Shape();
        addChild(light);
        createLight(light);
        var upper:TextField = new TextField();
        addChild(upper);
        upper.x = -90;
        upper.y = -30;
        upper.width = 180;
        upper.height = 30;
        createText(upper, 20);
        upper.text = "fadeIn / fadeOut";
        var lower:TextField = new TextField();
        //addChild(lower);
        lower.x = -110;
        lower.y = 1;
        lower.width = 220;
        lower.height = 39;
        createText(lower, 24);
        lower.text = "blurFilter effect";
        
        var bmpd:BitmapData = new BitmapData(220, 39, true, 0x0);
        bmpd.draw(lower);
        var bmp:Bitmap = new Bitmap(bmpd);
        bmp.x = -110;
        bmp.y = 1;
        this.addChild(bmp);
    }
    public function blur(target:Number):void {
        targetScale = target;
        addEventListener(Event.ENTER_FRAME, blurPanel, false, 0, true);
    }
    private function blurPanel(evt:Event):void {
        scale += (targetScale - scale)*deceleration;
        if (Math.abs(targetScale - scale) < 0.005) {
            scale = targetScale;
            removeEventListener(Event.ENTER_FRAME, blurPanel);
        }
        scaleX = scaleY = scale;
        depth = 1 - scale;
        changeBlur(depth);
    }
    private function changeBlur(targetDepth:Number):void {
        var length:Number = targetDepth*20;
        var filter:BlurFilter = new BlurFilter(length, length, 3);
        filters = [filter];
    }
    public function fade(target:Number):void {
        targetAlpha = target;
        addEventListener(Event.ENTER_FRAME, fadePanel, false, 0, true);
    }
    private function fadePanel(evt:Event):void {
        if (targetAlpha > 0) {
            alpha += (targetAlpha - alpha)*0.1;
        } else {
            alpha += (targetAlpha - alpha)*0.2;
        }
        if (Math.abs(targetAlpha - alpha) < 0.005) {
            alpha = targetAlpha;
            removeEventListener(Event.ENTER_FRAME, fadePanel);
        }
    }
    private function createBase(target:Shape):void {
        var w:uint = _width;
        var h:uint = _height;
        var colors:Array = [0x0088CC, 0x19B2FF, 0x7FD4FF];
        var alphas:Array = [1, 1, 1];
        var ratios:Array = [0, 153, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w*0.5, -h*0.5);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, 16);
        target.graphics.endFill();
    }
    private function createLight(target:Shape):void {
        var w:uint = _width - 2;
        var h:uint = _height - 2;
        var colors:Array = [bColor, bColor];
        var alphas:Array = [0.6, 0.2];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w*0.5, -h*0.5);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRectComplex(-w*0.5, -h*0.5, w, h*0.5, 7, 7, 0, 0);
        target.graphics.endFill();
    }
    private function createText(txt:TextField, size:uint):void {
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = 0xFFFFFF;
    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.events.Event;
import flash.events.MouseEvent;

class TabMenu extends Sprite {
    public var id:uint;
    private var menu:Sprite;
    private var btn:Shape;
    private var txt:TextField;
    private var base:Shape;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var bHeight:uint = 40;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var tColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    public static const UP:String = "up";
    public static const DOWN:String = "down";
    private var direction:String = TabMenu.UP;
    private var slideIn:Function;
    private static var yTarget:uint = 10;
    private static var deceleration:Number = 0.5;
    private var _enabled:Boolean = true;

    public function TabMenu() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        if (option.direction != undefined) direction = option.direction;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            tColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            tColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        menu = new Sprite();
        btn = new Shape();
        txt = new TextField();
        base = new Shape();
        addChild(menu);
        menu.addChild(btn);
        menu.addChild(txt);
        addChild(base);
        var shade:DropShadowFilter = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 2, 3, false, false);
        menu.filters = [shade];
        menu.mask = base;
        createBox(btn, _width, bHeight, corner);
        createMask(base, _width + 10, bHeight);
        txt.x = -_width*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        switch (direction) {
        case TabMenu.UP :
            txt.y = - _height;
            base.y = - _height;
            slideIn = slideUp;
            break;
        case TabMenu.DOWN :
            txt.y = 1;
            base.y = _height;
            slideIn = slideDown;
            break;
        }
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
        removeEventListener(Event.ENTER_FRAME, slideOut);
        addEventListener(Event.ENTER_FRAME, slideIn, false, 0, true);
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
        removeEventListener(Event.ENTER_FRAME, slideIn);
        addEventListener(Event.ENTER_FRAME, slideOut, false, 0, true);
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.textColor = tColor;
    }
    private function _over():void {
        txt.textColor = tColor;
    }
    private function _down():void {
        txt.textColor = tColor;
    }
    private function _off():void {
        txt.textColor = offColor;
    }
    private function slideUp(evt:Event):void {
        menu.y += (- yTarget - menu.y)*deceleration;
        if (Math.abs(- yTarget - menu.y) < 0.5) {
        menu.y = - yTarget;
        removeEventListener(Event.ENTER_FRAME, slideIn);
        }
    }
    private function slideDown(evt:Event):void {
        menu.y += (yTarget - menu.y)*deceleration;
        if (Math.abs(yTarget - menu.y) < 0.5) {
        menu.y = yTarget;
        removeEventListener(Event.ENTER_FRAME, slideIn);
        }
    }
    private function slideOut(evt:Event):void {
        menu.y -= menu.y*deceleration;
        if (Math.abs(menu.y) < 0.5) {
        menu.y = 0;
        removeEventListener(Event.ENTER_FRAME, slideOut);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
        _up();
        addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
        addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
        _off();
        removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
        removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        removeEventListener(MouseEvent.MOUSE_DOWN, press);
        removeEventListener(MouseEvent.MOUSE_UP, release);
        removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBox(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }
    private function createMask(target:Shape, w:uint, h:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.drawRect(-w*0.5, -h*0.5, w, h);
        target.graphics.endFill();
    }

}


import flash.display.BitmapData;

class Tile extends BitmapData {
    private static var size:uint = 6;
    private static var color:uint = 0xFF000000;

    public function Tile() {
        super(size, size, true, 0x00000000);
        init();
    }

    private function init():void {
        setPixel32(0, 2, color);
        setPixel32(0, 5, color);
        setPixel32(1, 1, color);
        setPixel32(1, 4, color);
        setPixel32(2, 0, color);
        setPixel32(2, 3, color);
        setPixel32(3, 2, color);
        setPixel32(3, 5, color);
        setPixel32(4, 1, color);
        setPixel32(4, 4, color);
        setPixel32(5, 0, color);
        setPixel32(5, 3, color);
    }

}