/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kYsz
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.ui.Mouse;

  public class ch7ex1 extends Sprite {
    protected var compass:Sprite;
    protected var crosshairs:Sprite;
    public function ch7ex1() {
      drawCompass();
      drawCrosshairs();
      addEventListener(Event.ENTER_FRAME, tick);
    }
    protected function tick(event:Event):void {
      Mouse.hide();
      crosshairs.x = stage.mouseX;
      crosshairs.y = stage.mouseY;
      compass.rotation = Math.atan2(
        stage.mouseY - compass.y,
        stage.mouseX - compass.x)
        * 180 / Math.PI;
    }
    protected function drawCompass():void {
      var RADIUS:Number = 30;
      compass = new Sprite();
      var g:Graphics = compass.graphics;
      g.lineStyle(4, 0xe03030);
      g.beginFill(0xd0d0d0);
      g.drawCircle(0, 0, RADIUS);
      g.endFill();
      g.moveTo(0, 0);
      g.lineTo(RADIUS, 0);
      addChild(compass);
      compass.x = stage.stageWidth / 2;
      compass.y = stage.stageHeight / 2;
    }
    protected function drawCrosshairs():void {
      var SIZE:Number = 10;
      crosshairs = new Sprite();
      var g:Graphics = crosshairs.graphics;
      g.lineStyle(8, 0x4040f0, 1, false, LineScaleMode.NONE, CapsStyle.SQUARE);
      g.moveTo(0, SIZE);
      g.lineTo(0, -SIZE);
      g.moveTo(SIZE, 0);
      g.lineTo(-SIZE, 0);
      crosshairs.blendMode = BlendMode.MULTIPLY;
      addChild(crosshairs);
    }
  }
}