/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kYnE
 */

// forked from imleon's forked from: flash on 2009-12-13
// forked from imleon's flash on 2009-12-13
package {
    import flash.events.KeyboardEvent;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.*;
    import flash.text.TextField;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.special.BitmapParticleMaterial;
    import org.papervision3d.core.geom.Particles;
    import org.papervision3d.core.geom.renderables.Particle;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import flash.text.*;

    public class FlashTest extends Sprite {
        private var scale:Number = 5;
        private var radius:Number = 350;
        private var smoothing:Boolean = true;
        private var minAlpha:Number = 0.3;
        private var glow:GlowFilter;
        private var tags:Array;
        private var tag_num:uint;
        private var bv:BasicView;
        private var tagArray:Array;
        private var tagContainer:DisplayObject3D;
        private var tagHolder:Particles; 
        private var inputText:TextField;   // テキスト入力欄

        public function FlashTest() {
            
            init ();
            
            // テキスト入力欄を作成
            inputText = new TextField();
            inputText.border = true;
            inputText.type = "input";
            inputText.width = 100;
            inputText.height = 18; 
            inputText.text = "Wonderfl";
            addChild(inputText);
            inputText.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
        }
        
        //キーボードイベント
        private function KeyDown(event:KeyboardEvent):void{
            if(event.keyCode == 13){
                tags.push(inputText.text);
                inputText.text = "";
                update();
            }

        }
        
        private function update():void{
            
            var txt:TextField = new TextField ();

            tag_num = tags.length;
            
            // 2D
            txt.text = tags[tag_num-1];
                
            var txtW:Number = txt.textWidth + 4;
            var txtH:Number = txt.textHeight + 4;
            //bitmap作成
            var bitmap:BitmapData = new BitmapData (txtW, txtH, true, 0x01FFFFFF);
                bitmap.draw (txt);

            //位置関係？
            var phi:Number = Math.acos((2 * Math.random()*(tag_num - 1)) / tag_num - 1);
            var theta:Number = Math.sqrt(tag_num * Math.PI) * phi;

            // 3D
            var material:BitmapParticleMaterial = new BitmapParticleMaterial (bitmap);
                material.interactive = true;
                material.smooth = smoothing;
            var tag:Particle = new Particle (material, scale, 0, 0, 0);
                    
                tagHolder = new Particles("tag_");
                tagHolder.addParticle (tag);
                tagHolder.x = radius * Math.cos (theta) * Math.sin (phi);
                tagHolder.y = radius * Math.sin (theta) * Math.sin (phi);
                tagHolder.z = radius * Math.cos (phi);
                tagHolder.useOwnContainer = true;
                tagHolder.autoCalcScreenCoords = true;
                tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
                tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
                //tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_PRESS, objectPressHandler);

            tagContainer.addChild (tagHolder);
            tagArray.push (tagHolder);         
            
            //buildTags();
        }


        
        private function init ():void {
            glow = new GlowFilter (0x003366, 1, 8, 8, 2, BitmapFilterQuality.LOW, true, false);
            tags = [];
            tag_num = tags.length;
            tagArray = [];
            tagContainer = new DisplayObject3D ("tag_container");
            tagContainer.x = -radius * 0.25;
            tagContainer.y =  radius * 0.25;
            
            bv = new BasicView (stage.stageWidth, stage.stageHeight, true, true);
            bv.viewport.interactive = true;
            bv.scene.addChild (tagContainer);
            bv.camera.z = -2 * radius;
            bv.camera.zoom = 20;
            bv.startRendering ();
            
            addChild (bv);
            
            buildTags ();
            
            addEventListener (Event.ENTER_FRAME, enterFrameHandler);
        }




        
        private function buildTags ():void {
            var i:uint;
            var txt:TextField = new TextField ();
            
            for (i = 0; i < tag_num; i++) {
                // 2D
                txt.text = tags[i];
                
                var txtW:Number = txt.textWidth + 4;
                var txtH:Number = txt.textHeight + 4;
                //bitmap作成
                var bitmap:BitmapData = new BitmapData (txtW, txtH, true, 0x01FFFFFF);
                    bitmap.draw (txt);

                //位置関係？
                var phi:Number = Math.acos((2 * (i + 1) - 1) / tag_num - 1);
                var theta:Number = Math.sqrt(tag_num * Math.PI) * phi;

                // 3D
                var material:BitmapParticleMaterial = new BitmapParticleMaterial (bitmap);
                    material.interactive = true;
                    material.smooth = smoothing;
                var tag:Particle = new Particle (material, scale, 0, 0, 0);
                    
                    tagHolder = new Particles("tag_");
                    tagHolder.addParticle (tag);
                    tagHolder.x = radius * Math.cos (theta) * Math.sin (phi);
                    tagHolder.y = radius * Math.sin (theta) * Math.sin (phi);
                    tagHolder.z = radius * Math.cos (phi);
                    tagHolder.useOwnContainer = true;
                    tagHolder.autoCalcScreenCoords = true;
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
                    //tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_PRESS, objectPressHandler);

                tagContainer.addChild (tagHolder);
                tagArray.push (tagHolder);
            }
        }
        
        private function objectOverHandler (e:InteractiveScene3DEvent):void {
        bv.viewport.buttonMode = true;
            e.target.filters = [glow];
        }

        private function objectOutHandler (e:InteractiveScene3DEvent):void {
        bv.viewport.buttonMode = false;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray [j].filters = [];
            }
        }
        
        private function enterFrameHandler (e:Event):void {
            tagContainer.rotationX += (mouseY - stage.stageHeight * 0.5) * 0.01;
            tagContainer.rotationY += (mouseX - stage.stageWidth * 0.5) * 0.01;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray[j].alpha = minAlpha + (1 - minAlpha) * (1 - (tagArray[j].screen.z - radius) / (2 * radius));
            }
        }
    }
}