/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kYdV
 */

// forked from esukei's BitmapTest
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    
    /**
     * MX2004時代が長かった所為でBitmapDataの扱いに弱いので練習してみる。
     *
     * 色を自分で作ったHSVColorつかって色かえてみた。
     *
     * なんか前振り長かったけど「彩度を落とさないで色をランダム」とかを感覚的にしたいなあと思って
     * HSVの実験をしたのでした。
     *
     */
    public class BitmapTest extends Sprite {
        
        private var bitmapData:BitmapData;
        private var AMOUNT:uint = 10000;
        
        //コンストラクタ
        public function BitmapTest() {
            
            /**
             * ビットマップデータ作る
             * 幅高さはステージと一緒
             * 透明度有効
             * 色は真っ黒で不透明
             */
            bitmapData = new BitmapData(stage.stageWidth, stage.stageWidth, true, 0xFF000000);
            
            //ステージに置く
            addChild( new Bitmap(bitmapData) );
            
            /**
             * ランダムにドットおいてみる
             * 色はHSVColorでパステル～純色でランダムしてみる。
             * あたりまえだけどノイズになった。
             */
            addEventListener(Event.ENTER_FRAME,function(event:Event):void{
                bitmapData.lock();
                for(var i:int = 0; i<AMOUNT; i++){
                    var tmpARGB:Number = 0xFF000000 | HSVColor.HSVtoRGB(360.0 * Math.random() , 0.5 + 0.5 * Math.random(), 1.0);
                    bitmapData.setPixel32(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight, tmpARGB );
                }
                bitmapData.unlock();
            });
            
        }
    }
}

/**
 * HSVColorクラス
 * @author esukei 
 */
class HSVColor
{
    public function HSVColor(){}
    
    /**
     * rgbを放り込むとhsvオブジェクトを返してくれるメソッド
     * @param  rgb:uint - RGB値
     * @return hsv:Object(HSV)  - h:Number,s:Number,v:Numberを含むObject(HSV)
     */
    public static function RGBtoHSV(rgb:uint):HSV
    {
        //rgbを分解して0.0～1.0になるようにする
        var r:Number = ( (rgb & 0xFF0000) >> 16 ) / 0xFF;
        var g:Number = ( (rgb & 0x00FF00) >> 8 ) / 0xFF;
        var b:Number = ( (rgb & 0x0000FF) ) / 0xFF;
        
        //HSVオブジェクトを作る
        var hsv:HSV = new HSV();
        hsv.h = 0.0;
        hsv.s = 0.0;
        hsv.v = 0.0;
        
        //RGBの各色の最大、最小をとる
        var max:Number = Math.max(r, Math.max(g, b) );
        var min:Number = Math.min(r, Math.min(g, b) );
        
        //最大、最小によってhの求め方を変える
        switch(max)
        {
            case r:
            {
                hsv.h = 60 * (g - b) / (max - min);
                break;
            }
            case g:
            {
                hsv.h = 60 * (b - r) / (max - min) + 120;
                break;
            }
            case b:
            {
                hsv.h = 60 * (r - g) / (max - min) + 240;
                break;
            }
            default:
            {
                break;
            }
        }
        
        //sとvを求める
        hsv.s = (max - min) / max;
        hsv.v = max;
        
        return hsv;
    }
    
    /**
     * h,s,vを放り込むとrgbを返してくれるメソッド
     * @param  h:Number - 色相のディグリー値 (0.0～360.0)
     * @param  s:Number - 彩度 (0.0～1.0)
     * @param  v:Number - 明度 (0.0～1.0)
     * @return rgb:uint - RGB値
     */
    public static function HSVtoRGB(h:Number, s:Number, v:Number):uint
    {
        var tmpR:uint = 0;
        var tmpG:uint = 0;
        var tmpB:uint = 0;
            
        //0.0～360.0に丸める
        h = (h % 360.0 + 360.0) % 360.0;
        
        //0.0～1.0に丸める
        s = Math.min( Math.max(s, 0.0) , 1.0);
        v = Math.min( Math.max(v, 0.0) , 1.0);
        
        //sが0.0の時はすべての値がvに等しい
        if(s == 0.0)
        {
            tmpR = v;
            tmpG = v;
            tmpB = v;
        }
        else
        {
            var hi:uint = (h / 60) % 6;
            var f:Number = h / 60 - hi;
            var p:Number = v * (1.0 - s);
            var q:Number = v * (1.0 - f * s);
            var t:Number = v * (1.0 - (1.0 - f) * s);
            
            switch(hi)
            {
                case 0:
                {
                    tmpR = v * 255;
                    tmpG = t * 255;
                    tmpB = p * 255;
                    break;
                }
                case 1:
                {
                    tmpR = q * 255;
                    tmpG = v * 255;
                    tmpB = p * 255;
                    break;
                }
                case 2:
                {
                    tmpR = p * 255;
                    tmpG = v * 255;
                    tmpB = t * 255;
                    break;
                }
                case 3:
                {
                    tmpR = p * 255;
                    tmpG = q * 255;
                    tmpB = v * 255;
                    break;
                }
                case 4:
                {
                    tmpR = t * 255;
                    tmpG = p * 255;
                    tmpB = v * 255;
                    break;
                }
                case 5:
                {
                    tmpR = v * 255;
                    tmpG = p * 255;
                    tmpB = q * 255;
                    break;
                }
                default:
                {
                    tmpR = 0;
                    tmpG = 0;
                    tmpB = 0;
                    break;
                }
            }        
        }
        
        return tmpR << 16 | tmpG << 8 | tmpB;
    }
}

//HSV型を作っておく
//Objectってクラスにする以外に中身に型指定って出来なかったっけ？
class HSV extends Object
{
    public var h:Number;
    public var s:Number;
    public var v:Number;
    function HSV(){}
}
