/**
 * Copyright Farzanmc ( http://wonderfl.net/user/Farzanmc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kXpT
 */

package 
{

	import flash.display.MovieClip;
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	
	[SWF(width=600, height=600, backgroundColor=0x333333)]
	
	public class DrawingCurves extends MovieClip
	{
		private var _stageMC:MovieClip;
		private var _controlPoint0:MovieClip;
		private var _controlPoint1:MovieClip;
		private var _controlPoint2:MovieClip;
		private var _controlPoint3:MovieClip;
		private var _anchor0:MovieClip;
		private var _anchor1:MovieClip;
		private var _anchor2:MovieClip;
		private var _anchor3:MovieClip;
		private var _anchor4:MovieClip;
		private var _speed;
		
		
		public function DrawingCurves() {
			
			/*var farzan:MovieClip = new MovieClip();
			farzan.name="farzan";
			var farzan_txt:TextField = new TextField;
			farzan_txt.selectable = false;
			farzan_txt.autoSize = TextFieldAutoSize.CENTER;
			farzan_txt.text = "www.FarzanMohajerani.com";
			var format:TextFormat = new TextFormat;
			format.color=0xFFFFFF;
			format.size=25;
			farzan_txt.defaultTextFormat=format;
			farzan.addChild(farzan_txt);
			farzan.x= stage.stageWidth/2-farzan.width;
			farzan.y = stage.stageHeight/2-farzan.height;*/
			
			stage.scaleMode = "noScale";
			stage.align = "TL";
			
			stage.addEventListener(Event.RESIZE,stageResized);
			 _controlPoint0 = addPoint(stage.stageWidth/2-150,stage.stageHeight/2);
			 _controlPoint1 = addPoint(stage.stageWidth/2-50,stage.stageHeight/2+100);
			 _controlPoint2 = addPoint(stage.stageWidth/2+50,stage.stageHeight/2);
			 _controlPoint3 = addPoint(stage.stageWidth/2+150,stage.stageHeight/2+100);
			 _anchor0 = addPoint(stage.stageWidth/2-200,stage.stageHeight/2+50);
			 _anchor1 = addPoint(stage.stageWidth/2-100,stage.stageHeight/2+50);
			 _anchor2 = addPoint(stage.stageWidth/2,stage.stageHeight/2+50);
			 _anchor3 = addPoint(stage.stageWidth/2+100,stage.stageHeight/2+50);
			 _anchor4 = addPoint(stage.stageWidth/2+200,stage.stageHeight/2+50);
			 drawCurve();
		}
		
		public function stageResized(evt:Event) {
			_stageMC.width = stage.stageWidth;
			_stageMC.height = stage.stageHeight;
		}
		
		public function addPoint(x:Number, y:Number):MovieClip {
			
			var point:MovieClip = new MovieClip();
			point.wayX=randomWay();
			point.wayY=randomWay();
			point._speed=Math.round(Math.random()*6)+2;
			point.graphics.lineStyle(25,0xFFFFFF,0.5);
			point.graphics.lineTo(1,0);
			addChild(point);
			point.x=x;
			point.y=y;
			point.addEventListener(MouseEvent.MOUSE_DOWN,onControlDown);
			point.addEventListener(MouseEvent.MOUSE_UP,onControlUp);
			point.buttonMode=true;
			point.addEventListener(Event.ENTER_FRAME,onEnterFrame_func);
			return point;
		}
		
		public function drawCurve() {
			graphics.clear();
			graphics.lineStyle(3,0xFFF);
			graphics.moveTo(_anchor0.x,_anchor0.y);
			graphics.beginFill(0xFFFFFF,0.4);
			graphics.curveTo(_controlPoint0.x,_controlPoint0.y,_anchor1.x,_anchor1.y);
			graphics.curveTo(_controlPoint1.x,_controlPoint1.y,_anchor2.x,_anchor2.y);
			graphics.curveTo(_controlPoint2.x,_controlPoint2.y,_anchor3.x,_anchor3.y);
			graphics.curveTo(_controlPoint3.x,_controlPoint3.y,_anchor4.x,_anchor4.y);
			graphics.lineStyle(1,0xFFFFFF,.5);
			graphics.lineTo(_controlPoint3.x,_controlPoint3.y);
			graphics.lineTo(_anchor3.x,_anchor3.y);
			graphics.lineTo(_controlPoint2.x,_controlPoint2.y);
			graphics.lineTo(_anchor2.x,_anchor2.y);
			graphics.lineTo(_controlPoint1.x,_controlPoint1.y);
			graphics.lineTo(_anchor1.x,_anchor1.y);
			graphics.lineTo(_controlPoint0.x,_controlPoint0.y);
			graphics.lineTo(_anchor0.x,_anchor0.y);
			graphics.endFill()
		}
		
		public function onControlDown(evt:MouseEvent) {
			(evt.target as MovieClip).startDrag();
			evt.target.removeEventListener(Event.ENTER_FRAME,onEnterFrame_func);
			stage.addEventListener(MouseEvent.MOUSE_MOVE,onControlMove);
		}
		public function onControlUp(evt:MouseEvent) {
			(evt.target as MovieClip).stopDrag();
			evt.target.addEventListener(Event.ENTER_FRAME,onEnterFrame_func);
			stage.removeEventListener(MouseEvent.MOUSE_MOVE,onControlMove);
		}
		public function onControlMove(evt:MouseEvent) {
			drawCurve();
			evt.updateAfterEvent();
			
		}
		
		function randomWay():Number {
			var i:Number = Math.round(Math.random()*10);
			if (i%2==0) {
				return 1;
			}else {
				return -1;
			}
		}
		
		function onEnterFrame_func(evt:Event)  {
			(evt.target as MovieClip).x+=(evt.target as MovieClip)._speed*(evt.target as MovieClip).wayX;
			(evt.target as MovieClip).y+=(evt.target as MovieClip)._speed*(evt.target as MovieClip).wayY;
			if((evt.target as MovieClip).x>stage.stageWidth ) {
				(evt.target as MovieClip).x = stage.stageWidth;
				(evt.target as MovieClip).wayX*=-1;
			}
			if((evt.target as MovieClip).x<0 ) {
				(evt.target as MovieClip).x = 0;
				(evt.target as MovieClip).wayX*=-1;
			}
			if((evt.target as MovieClip).y>stage.stageHeight ) {
				(evt.target as MovieClip).y = stage.stageHeight;
				(evt.target as MovieClip).wayY*=-1;
			}
			if((evt.target as MovieClip).y<0 ) {
				(evt.target as MovieClip).y = 0;
				(evt.target as MovieClip).wayY*=-1;
			}
			drawCurve();
			//evt.updateAfterEvent();
		}

	}

}