/**
 * Copyright more_more_for ( http://wonderfl.net/user/more_more_for )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kXXI
 */

/* Flash Text Engine Test01
	** reference--------
	** http://wonderfl.net/code/5e65da9e6bca520c4f9e864ddb0743bfe4252a8e-detail.html (Text Engine 縦書きサンプル)
	** http://wonderfl.net/code/1cfbdb766ff1faee601b35ef6555e8dee32e087f#code_forked (FTE（FlashTextEngine）を使ってみる on 2010-1-29)
	** http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/index.html (Adobe)
	** http://www.aozora.gr.jp/cards/000081/files/456_15050.html (青空文庫,宮沢 賢治「銀河鉄道の夜」)
	/* auther--------
	** more_more_for
	*/

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.text.engine.TextLine;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextElement;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    import flash.text.engine.EastAsianJustifier;
    import flash.text.engine.LineJustification;
    import flash.text.engine.TextRotation;
    
    public class FTETest01 extends Sprite {
    	
    		private var baseSprite:Sprite;
    		private var grid:Shape;
    		private var txtStr:String;
    		private var fontDesc:FontDescription;
    		private var elFormat:ElementFormat;
    		private var txtElement:TextElement;
    		private var txtBlock:TextBlock;
    		private var txtWidth:int = 420;
    		private var fSize:int = 13;
    	
        public function FTETest01() {
        	
        		//baseSprite setting
        		baseSprite = new Sprite();
        		baseSprite.graphics.beginFill(0x002255,0.9);
        		baseSprite.graphics.drawRect(0,0,txtWidth+45,txtWidth+45);
        		baseSprite.graphics.endFill();
        		this.addChild(baseSprite);
            
            //Font
            fontDesc =new FontDescription();
            fontDesc.fontName = "Kozuka Mincho Pro M";
            
            //Text setting
            txtStr = "・・・・・・\n「そうよ。だけどいい虫だわ、お父さん斯う云ったのよ。むかしのバルドラの野原に一ぴきの蝎がいて小さな虫やなんか殺してたべて生きていたんですって。するとある日いたちに見附かって食べられそうになったんですって。さそりは一生けん命遁にげて遁げたけどとうとういたちに押おさえられそうになったわ、そのときいきなり前に井戸があってその中に落ちてしまったわ、もうどうしてもあがられないでさそりは溺おぼれはじめたのよ。そのときさそりは斯う云ってお祈りしたというの、\n　ああ、わたしはいままでいくつのものの命をとったかわからない、そしてその私がこんどいたちにとられようとしたときはあんなに一生けん命にげた。それでもとうとうこんなになってしまった。ああなんにもあてにならない。どうしてわたしはわたしのからだをだまっていたちに呉くれてやらなかったろう。そしたらいたちも一日生きのびたろうに。どうか神さま。私の心をごらん下さい。こんなにむなしく命をすてずどうかこの次にはまことのみんなの幸のために私のからだをおつかい下さい。って云ったというの。そしたらいつか蝎はじぶんのからだがまっ赤なうつくしい火になって燃えてよるのやみを照らしているのを見たって。いまでも燃えてるってお父さん仰おっしゃったわ。ほんとうにあの火それだわ。」\n（宮沢賢治　銀河鉄道の夜より）";
            
            elFormat = new ElementFormat();
            elFormat.locale = "ja";
            elFormat.fontSize = fSize;
            elFormat.color = 0xFFFFFF;
            elFormat.fontDescription = fontDesc;
            txtElement = new TextElement(txtStr,elFormat);
            
            txtBlock = new TextBlock();
            txtBlock.textJustifier = new EastAsianJustifier("ja", LineJustification.UNJUSTIFIED);
            txtBlock.lineRotation = TextRotation.ROTATE_90;
            txtBlock.content = txtElement;
            
            var preTxtLine:TextLine = null;
            var curTxtLine:TextLine;
            var posX:int = txtWidth - (stage.stageWidth - txtWidth) /2 + 25;
            var posY:int = 22;
            var cnt:int = 0;
            var offset:int = 8;
            
            while(txtWidth > (cnt*offset + cnt*fSize)){
            curTxtLine = txtBlock.createTextLine(preTxtLine,txtWidth);
            curTxtLine.x = posX - (cnt*(offset+fSize));
            curTxtLine.y = posY;
            baseSprite.addChild(curTxtLine);
            preTxtLine = curTxtLine;
            cnt++;
            }
            
        }
    }
}