/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kWzP
 */

/**
 * Copyright spanvega ( http://wonderfl.net/user/spanvega )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gYWo
 */

package
{
    import com.greensock.TweenMax;
    import com.greensock.easing.*;

    import flash.geom.Matrix;
    import flash.geom.Rectangle;

    import flash.net.FileFilter;
    import flash.net.FileReference;
    
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.LoaderInfo;
    import flash.display.BitmapData;
    import flash.filters.DropShadowFilter;

    import com.bit101.components.Label;
    import com.bit101.components.CheckBox;
    import com.bit101.components.ComboBox;
    import com.bit101.components.PushButton;

    import org.papervision3d.view.BasicView;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.core.geom.renderables.Vertex3D;

    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.shadematerials.EnvMapMaterial;
    
    /* 
    * EXTENSION BASED ON THE FORMER VERTEX3D TWEEN http://wonderfl.net/c/1pGc
    * DEFAULT TEXTURE IS LOADED RANDOMLY FROM A FIVE SUPERNOVAS PHOTOS SERIE (400x400)
    * PANEL ALLOWS TO UPLOAD ANOTHER TEXTURE AND DISPLAYS IT ON THE RUN, CHANGE TWEEN AND EASE TYPES
    * BOTTOM BAR DISPLAYS THE VERTICES TWEENS PROGRESSION
    */

    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '25') ]
    
    /**
    *    @author SPANVEGA // CHRISTIAN //
    **/

    public class CUBASTIC_NOVA extends BasicView
    {
        // --o PROPERTIES

        private var filter : DropShadowFilter = new DropShadowFilter (0, 0, 0xAAAAAA, 1, 5, 5);

        private var type_ease : String = 'easeOut'; // DEFAULT EASE TYPE

        private var type_tween : Class = Elastic;  // DEFAULT TWEEN TYPE

        private var light_point : PointLight3D;

        private var bar_display : BitmapData;

        private var panel_button : CheckBox;

        private var size_min : uint = 300;
        private var size_max : uint = 750;

        private var texture : BitmapData;

        private var file : FileReference;

        private var bar_bitmap : Bitmap;

        private var ratio_step : uint;
        private var vertex_num : uint;

        private var size_cur : Number;

        private var panel : Sprite;

        private var stageW : uint;
        private var stageH : uint;

        private var cube : Cube;

        // --o CONSTRUCTOR

        public function CUBASTIC_NOVA ()
        {
            stage ? main () : addEventListener (Event.ADDED_TO_STAGE, main);
        }

        // --o PRIVATE METHODS

        private function main (e : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {
                removeEventListener (Event.ADDED_TO_STAGE, init);
            }

            stage.addEventListener (Event.RESIZE, onResize);

            onResize ();

            // --o DISPLAY BAR

            bar_bitmap = new Bitmap ();

            addChild (bar_bitmap);

            onBarDraw ();
            
            // --o PANEL

            onPanel ();

            //

            var bitmap : BitmapFileMaterial = new BitmapFileMaterial ();

            var bitmap_num : uint = 1 + Math.round (Math.random () * 4);

            bitmap.addEventListener
            (
                FileLoadEvent.LOAD_COMPLETE, onComplete
            );
            bitmap.addEventListener
            (
                FileLoadEvent.LOAD_PROGRESS, onProgress
            );
            bitmap.addEventListener
            (
                FileLoadEvent.LOAD_ERROR, onIOError
            );
            bitmap.addEventListener
            (
                FileLoadEvent.SECURITY_LOAD_ERROR, onSecurityError
            );

            bitmap.interactive = true;

            bitmap.checkPolicyFile = true;

            bitmap.texture =  'http://mm4d.free.fr/images/sample_nova_'+ bitmap_num + '.jpg';
        }

        private function init () : void
        {
            viewport.buttonMode = true;
            viewport.interactive = true;

            //

            light_point = new PointLight3D ();

            //

            cube = new Cube
            (   
                new MaterialsList
                (
                    {
                        all : onSetMaterial ()
                    }
                ),
                1, 1, 1,
                2, 2, 2
            );

            cube.useOwnContainer = true;

            cube.filters = [filter];

            cube.addEventListener
            (
                InteractiveScene3DEvent.OBJECT_PRESS,
                onNova
            );

            //

            super.scene.addChild (cube);

            super.startRendering ();

            //

            onNova ();
        }
        
        private function onSetMaterial () : EnvMapMaterial
        {
            var material : EnvMapMaterial = new EnvMapMaterial
            (
                light_point, texture
            );

            material.interactive = true;

            // --o OVERRIDE DEFAULT BACKENVMAP OPAQUE BITMAPDATA WITH A TRANSPARENT BACKGROUND 
            //     ONE TO HIDE UNESTHETIC AMBIENTCOLOR ON BACK FACES WHEN VERTICES ARE RESIZED

            var alpha_bitmap : BitmapData = new BitmapData (texture.width, texture.height, true, 0);
            alpha_bitmap.draw (texture);

            material.backenvmap = alpha_bitmap;

            return material;
        }

        private function onNova (e : InteractiveScene3DEvent = null) : void
        {
            // --o COMPLETE QUEUED VERTICES TWEEN

            for each (var tween : TweenMax in TweenMax.getAllTweens())
            {
                tween.complete (false, true);
            }

            //

            var size : Number = size_min + (Math.random () * (size_max - size_min));

            var scaleRatio : Number;

            if (! size_cur)
            {
                scaleRatio = size_cur = size;
            }
            else
            {
                scaleRatio = size / size_cur;

                size_cur = size;
            }

            // --o RESET DISPLAY BAR TO FULL WIDTH

            bar_bitmap.bitmapData = bar_display;

            vertex_num = cube.geometry.vertices.length;

            ratio_step = stageW / vertex_num;

            // --o VERTEX3D PROP TWEEN

            for each (var v : Vertex3D in cube.geometry.vertices)
            {
                TweenMax.to
                (
                    v,
                    Math.random () * 5,
                    {
                        x : v.x * scaleRatio,
                        y : v.y * scaleRatio,
                        z : v.z * scaleRatio,
                        onComplete : onTweenEnd,
                        ease : type_tween[type_ease]
                    }
                );
            }
        }

        private function onTweenEnd () : void
        {
            var b : BitmapData = new BitmapData
            (
                1 + (ratio_step * --vertex_num), 10, true, 0
            );
            b.draw (bar_display);

            bar_bitmap.bitmapData = b;
        }

        override protected function onRenderTick (e : Event = null) : void
        {
            var p1 : Number = mouseY - (stageH / 2);
            var p2 : Number = mouseX - (stageW / 2);

            TweenMax.to
            (
                cube,
                1,
                {
                    rotationX : p1,
                    rotationY : p2
                }
            );

            cube.rotationZ ++;

            // --o FILTER DISTANCE | ALPHA

            var distance : Number = Math.sqrt (p1 * p1 + p2 * p2);

            filter.alpha = 1 - distance / 500;
            filter.distance = distance / 10;

            // --o FILTER ANGLE

            var degrees : Number = Math.atan2 (p1, p2) * (180 / Math.PI);

            filter.angle = degrees + 180;

            // --o LIGHT POINT

            light_point.x = p2;
            light_point.y = p1;

            //

            super.onRenderTick ();
        }

        //

        private function onComplete (e : FileLoadEvent) : void
        {
            texture = e.target.bitmap;

            //

            init ();
        }

        private function onProgress (e : FileLoadEvent) : void
        {
            var n : Number = 1 - e.bytesLoaded / e.bytesTotal;

            var b : BitmapData = new BitmapData
            (
                Math.round (stageW * n) + 1, 10, true, 0
            );
            b.draw (bar_display);

            bar_bitmap.bitmapData = b;
        }

        private function onIOError (e : FileLoadEvent) : void
        {
            trace ('LOAD : FILE ERROR -> ' + e.message);
        }

        private function onSecurityError (e : FileLoadEvent) : void
        {
            trace ('LOAD : SECURITY ERROR -> ' + e.message)
        }

        //

        private function onUpload (e : Event) : void
        {
            file =  new FileReference ();

            file.addEventListener
            (
                Event.SELECT, onFileSelect
            );

            file.addEventListener
            (
                Event.COMPLETE, onFileComplete
            );

            var type : Array = 
            [
                new FileFilter
                (
                    'Images (*.jpeg, *.jpg, *.gif, *.png)',
                    '*.jpeg; *.jpg; *.gif; *.png;',
                    'JPEG; jp2_; GIFF'
                )
            ];

            file.browse (type);
        }

        private function onFileSelect (e : Event) : void
        {
            file.load ();
        }

        private function onFileComplete (e : Event) : void
        {
            var loader : Loader = new Loader();

            loader.loadBytes (file.data);

            loader.contentLoaderInfo.addEventListener
            (
                Event.COMPLETE,
                onLoadComplete
            );
        }

        private function onLoadComplete (e : Event) : void
        {
            var loaderInfo : LoaderInfo = LoaderInfo (e.target);

            texture = new BitmapData (loaderInfo.width, loaderInfo.height);
            texture.draw(loaderInfo.loader);

            //

            cube.replaceMaterialByName (onSetMaterial (), 'all');
        }

        private function onResize (e : Event = null) : void
        {
            stageW = stage.stageWidth;

            stageH = stage.stageHeight;

            if (bar_bitmap) onBarDraw ();

            if (panel) onPanelDisplay ();

            // --o UPDATE BAR WIDTH PER TWEEN

            ratio_step = stageW / vertex_num;
        }

        private function onBarDraw () : void
        {
            var mat : Matrix = new Matrix ();
            mat.createGradientBox (2, 10);

            var bar : Shape = new Shape ();
            bar.graphics.beginGradientFill
            (
                'linear', [0xAAAAAA, 0xFFFFFF], [1, 0], [0, 127], mat, 'repeat'
            );
            bar.graphics.drawRect
            (
                0, 0, stageW, 10
            );
            bar.graphics.endFill ();

            bar_display = new BitmapData (bar.width, bar.height, true, 0);
            bar_display.draw (bar);

            bar_bitmap.y = stageH - 10;
        }
        
        //
        
        private function onPanel () : void
        {
            panel = new Sprite ();

            // --o SHAPE

            var rect : Shape = new Shape ();
            rect.graphics.lineStyle (1, 0xAAAAAA);
            rect.graphics.beginFill (0xFFFFFF, 0.5);
            rect.graphics.moveTo (0, 0);
            rect.graphics.lineTo (130, 0);
            rect.graphics.lineTo (130, 80);
            rect.graphics.lineTo (20, 80);
            rect.graphics.lineTo (20, 20);
            rect.graphics.lineTo (0, 20);
            rect.graphics.lineTo (0, 0);
            rect.graphics.endFill ();

            //

            panel.addChild (rect);

            // --o CHECKBOX | BUTTON

            panel_button = new CheckBox (panel, 5, 5, null, onPanelDisplay);
            panel_button.selected = true;

            // --o BUTTON

            var button : PushButton = new PushButton (panel, 25, 5, 'TEXTURE', onUpload);

            // --o COMBOBOXES

            var array_tween : Array =
            [
                {label:'BACK', data:Back},
                {label:'BOUNCE', data:Bounce},
                {label:'CIRC', data:Circ},
                {label:'CUBIC', data:Cubic},
                {label:'EASE LOOKUP', data:EaseLookup},
                {label:'ELASTIC', data:Elastic},
                {label:'EXPO', data:Expo},
                {label:'FAST EASE', data:FastEase},
                {label:'LINEAR', data:Linear},
                {label:'QUAD', data:Quad},
                {label:'QUART', data:Quart},
                {label:'QUINT', data:Quint},
                {label:'ROUGH EASE', data:RoughEase},
                {label:'SINE', data:Sine},
                {label:'STEPPED EASE', data:SteppedEase},
                {label:'STRONG', data:Strong}
            ];

            var combo_tween : ComboBox = new ComboBox (panel, 25, 30, 'TWEEN', array_tween);
            combo_tween.numVisibleItems = array_tween.length;
            combo_tween.addEventListener
            (
                Event.SELECT, onSelectTween
            );

            var array_ease : Array = [{label:'EASE IN', data:'easeIn'}, {label:'EASE OUT', data:'easeOut'}, {label:'EASE IN OUT', data:'easeInOut'}];
    
            var combo_ease  : ComboBox = new ComboBox (panel, 25, 55, 'EASE', array_ease);
            combo_ease.numVisibleItems = array_ease.length;
            combo_ease.addEventListener
            (
                Event.SELECT, onSelectEase
            );

            //

            panel.x = stageW - (panel.width + 20);
            panel.y = 20;

            addChild (panel);
        }
        
        private function onPanelDisplay (e : Event = null) : void
        {
            var position : Number = stageW - (panel_button.selected ? panel.width + 20 : 20);

            TweenMax.to (panel, 1,  {x : position, ease : Elastic.easeOut});
        }
        
        private function onSelectTween (e : Event) : void
        {
            type_tween = e.target.selectedItem.data;
        }

        private function onSelectEase (e : Event) : void
        {
            type_ease = e.target.selectedItem.data;
        }
    }
}