/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kWEL
 */

// forked from s8t1h12akj's forked from: forked from: forked from: forked from: SoundVisualizer [mini/color] BGM
// forked from s8t1h12akj's forked from: forked from: forked from: SoundVisualizer [mini/color] BGM
// forked from Cesar.Hernandez's forked from: forked from: SoundVisualizer [mini/color] BGM
// forked from kadnare's forked from: SoundVisualizer [mini/color] BGM
// forked from ProjectNya's SoundVisualizer [mini/color] BGM
////////////////////////////////////////////////////////////////////////////////
// SoundVisualizer [mini/color] BGM
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var visualizer:SoundVisualizer;
        private var se:SoundEffect;
        private static var bgmPath:String = "http://kouetu.sakura.ne.jp/mp3_mujic/sesibon.mp3";
        private var playBtn:Btn;
        private var stopBtn:Btn;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            visualizer = new SoundVisualizer(50, 0xCDAD00);
            addChild(visualizer);
            visualizer.x = 232;
            visualizer.y = 232;
            visualizer.alpha = 0.4;
            //
            se = new SoundEffect();
            se.addEventListener(Event.COMPLETE, complete, false, 0, true);
            se.load(bgmPath);
            //
            playBtn = new Btn();
            addChild(playBtn);
            playBtn.x = 232;
            playBtn.y = 400;
            playBtn.init({label: "start", type: 2});
            playBtn.addEventListener(MouseEvent.CLICK, play, false, 0, true);
            playBtn.enabled = false;
            stopBtn = new Btn();
            addChild(stopBtn);
            stopBtn.x = 232;
            stopBtn.y = 400;
            stopBtn.init({label: "stop", type: 2});
            stopBtn.addEventListener(MouseEvent.CLICK, stop, false, 0, true);
            stopBtn.visible = false;
        }
        private function complete(evt:Event):void {
            se.removeEventListener(Event.COMPLETE, complete);
            visualizer.alpha = 1;
            playBtn.enabled = true;
        }
        private function play(evt:MouseEvent):void {
            playBtn.visible = false;
            stopBtn.visible = true;
            //
            visualizer.start();
            se.play(0.5, true);
        }
        private function stop(evt:MouseEvent):void {
            playBtn.visible = true;
            stopBtn.visible = false;
            //
            visualizer.stop();
            se.stop();
        }

    }

}


//////////////////////////////////////////////////
// SoundVisualizerクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class SoundVisualizer extends Sprite {
    private var max:uint;
    private var color:uint;
    private static var bw:uint = 4;
    private static var bh:uint = 512;
    private static var xoffset:uint = 1;
    private static var yoffset:uint = 2;
    private var indicators:Array;
    private var timer:Timer;
    private static var interval:uint = 75;
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint;

    public function SoundVisualizer(m:uint, c:uint = 0x000000) {
        max = m;
        color = c;
        factors = uint(channels/max);
        draw();
    }

    private function draw():void {
        var base:Shape = new Shape();
        addChild(base);
        var overlay:Sprite = new Sprite();
        addChild(overlay);
        //
        indicators = new Array();
        for (var n:uint = 0; n < max; n++) {
            var indicator:SoundIndicator = new SoundIndicator(bw, bh, color);
            overlay.addChild(indicator);
            indicator.x = - uint((bw + xoffset)*max/2) + (bw + xoffset)*n;
            indicator.y = uint(20);
            indicators.push(indicator);
        }
        //
        var colors:Array = [0xFF7256, 0xE38217];
        var alphas:Array = [0.4, 0.75];
        var ratios:Array = [25, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(overlay.width, bh * 2, Math.PI/2, -uint(overlay.width/2), -bh/2);
        base.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.REPEAT, InterpolationMethod.RGB, 1);
        base.graphics.drawRect(- uint(overlay.width/2), - bh/4, overlay.width, bh+5);
        base.graphics.endFill();
        base.mask = overlay;
        //
        byteArray = new ByteArray();
    }
    public function start():void {
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, update, false, 0, true);
        timer.start();
    }
    public function stop():void {
        if (timer) {
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER, update);
        }
        reset();
    }
    public function update(evt:TimerEvent):void {
        SoundMixer.computeSpectrum(byteArray, false, factors);
        for (var n:uint = 0; n < max; n+= 2) {
            var indicator:SoundIndicator = indicators[n];
            byteArray.position = factors*16*(n / 2);
            var percent:Number = byteArray.readFloat();
            indicator.update(percent);
        }
    }
    public function reset():void {
        for (var n:uint = 0; n < max; n += 4) {
            var indicator:SoundIndicator = indicators[n];
            indicator.reset();
        }
    }

}


//////////////////////////////////////////////////
// SoundIndicatorクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;

class SoundIndicator extends Sprite {
    private var bar:Shape;
    private var color:uint;
    private var _width:uint;
    private var _height:uint;
    private var rectShape:Shape;

    public function SoundIndicator(w:uint, h:uint, c:uint = 0x000000) {
        _width = w;
        _height = h;
        color = c;
        draw();
        reset();
    }

    private function draw():void {
        var base:Shape = new Shape();
        //addChild(base);
        base.graphics.lineStyle(1, color, 1);
        base.graphics.beginFill(color);
        base.graphics.lineTo(_width / 2, _height / 2);
        base.graphics.endFill();
        //
        bar = new Shape();
        //addChild(bar);
        bar.graphics.beginFill(color);
        bar.graphics.drawCircle(0, 0, - 40);
        bar.graphics.endFill();
        
        rectShape = new Shape();
        //addChild(rectShape);
        rectShape.graphics.beginFill(color);
        rectShape.graphics.drawRect(0, 0, _width, - 1);
        rectShape.graphics.endFill();
        
        addChild(base);
        addChild(bar);
    }
    public function update(percent:Number):void {
        bar.scaleY = percent * 2;
        bar.scaleX = percent / 4;
        bar.height = uint(bar.height);
        
    }
    public function reset():void {
        bar.scaleY = 0;
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0xFF5721;
    private static var overColor:uint = 0xFF5721;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0xFF5721;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;
import flash.media.SoundLoaderContext;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;

    public function SoundEffect() {
    }

    public function init(Snd:Class):void {
        sound = new Snd();
    }
    public function load(filePath:String):void {
        sound = new Sound();
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
        try {
            sound.load(new URLRequest(filePath), new SoundLoaderContext(10, true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(lv:Number, loop:Boolean = false):void {
        playing = true;
        if (channel) channel.stop();
        level = lv;
        looping = loop;
        channel = sound.play();
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
        if (looping) {
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
        }
    }
    public function stop():void {
        playing = false;
        if (channel) {
            channel.stop();
            channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        }
    }
    public function setVolume(v:Number):void {
        volume = v;
        if (channel) {
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        }
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}
