/**
 * Copyright gupon ( http://wonderfl.net/user/gupon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kUtk
 */

// forked from ep91ckok's ぐるんぐるん
/*
 * 画面clickでreset
 */
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(width=465, height=465, frameRate=30, backgroundColor=0x888888)]
	public class Main extends Sprite 
	{
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			x = stage.stageWidth / 2;
			y = stage.stageHeight / 2;
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function():void { setCircles() } );
			
			setCircles();
		}
		
		private function setCircles():void
		{
			if (numChildren) removeChildAt(0);
			
			var c:Circle = new Circle(500, true);
			addChild(c);
			var n:int = 20;
			while (n--)
			{
				c.addChild( c = new Circle(c.r) );
			}
		}
		
	}
	
}

import flash.display.Sprite;
import flash.events.Event;

class Circle extends Sprite
{
	public var r:int;
	
	public function Circle(r:int, first:Boolean=false):void
	{
		var r0:int = r;
		
		if(!first)
			r *= Math.random() * 0.1 + 0.7;
			
		this.r = r;
		graphics.beginFill(HSVtoRGB(Math.random()*60+300,.8,Math.random()));
		graphics.drawCircle(0, 0, r);
		
		x = r0 - r;
		rotation = Math.random() * 360;
		
		var n:Number = Math.random()*1+0.5;
		addEventListener(Event.ENTER_FRAME, function(e:Event):void {
			rotation += n;
		});
	}
	
	private function HSVtoRGB( h:Number, s:Number, v:Number ):uint{
		var r:Number, g:Number, b:Number;
		if( s != 0 ){
			h %= 360;
			var hi:uint = h / 60 % 6;
			var f:Number = h / 60 - hi;
			var p:Number = v * ( 1 - s );
			var q:Number = v * ( 1 - f * s );
			var t:Number = v * ( 1 - ( 1 - f ) * s );
			
			switch( hi ){
				case 0: r = v; g = t; b = p; break;
				case 1: r = q; g = v; b = p; break;
				case 2:	r = p; g = v; b = t; break;
				case 3: r = p; g = q; b = v; break;
				case 4: r = t; g = p; b = v; break;
				case 5: r = v; g = p; b = q; break;
			}
		} else r = g = b = v;
		return ( 0xFF * r << 16 ) + ( 0xFF * g << 8 ) + ( 0xFF * b );
	}
}