/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kUSk
 */


/*
 * SAFLY ADD IT TO STAGE 
 *     stage.addChildAt( new BLuePrintBackground() , 0 );
 *  - that's it !
 * 
 * */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.InterpolationMethod;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    public class BluePrintBackground extends Sprite
    {
        static public const GIRD_SIZE:int = 12;
        static public const GIRD_COUNT:int = 8;
        private var w:int;
        private var h:int;
        
        private var prelinNoise:Bitmap;
        private var bluePrint:Sprite;
        
        public function BluePrintBackground()
        {
            if ( stage ) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init( e:Event = null ):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            
            
            initBluePrint( w * 1.4, h * 1.4 );
            bluePrint.x = -0.2 * w;
            bluePrint.y = -0.2 * h;
            
            
            //initBluePrint( w, h);
            
            initPrelinNoise();
            
            prelinNoise.alpha = 0.15;
            //prelinNoise.blendMode = BlendMode.MULTIPLY;
            
            //prelinNoise.alpha = 0;
            
            //var bgColor:Bitmap = new Bitmap(new BitmapData(w, h, false, 0xFF000000));
            //addChild(bgColor);
            
            bluePrint.rotationX = 160;
            
            var spawn:Function = function(e:*):void
            {
                bluePrint.rotationX -= 8;
                if ( bluePrint.rotationX < -2 ) 
                    removeEventListener('enterFrame', spawn);
            };
            addEventListener('enterFrame', spawn);
            
        }
        
        private function initBluePrint( w:Number, h:Number ):void 
        {
            var m:Matrix = new Matrix();
            m.createGradientBox( w, h, 0);
            
            bluePrint = new Sprite();
            addChild( bluePrint );
            var g:Graphics = bluePrint.graphics;
            
            g.beginGradientFill(
                GradientType.RADIAL, 
                [0x5587DD, 0x253C78],
                [1, 1], 
                [0, 255],
                m,
                SpreadMethod.PAD,
                InterpolationMethod.RGB
            );
            
            g.drawRect(0, 0, w, h);
            g.endFill();
            
            var s1:int = GIRD_SIZE;
            var s2:int = GIRD_COUNT;
            
            var s:Shape = new Shape();
            g = s.graphics;
            bluePrint.addChild( s );
            
            for ( var x:int = 0; x < w; x += s1 )
            {
                g.lineStyle((x/s1) % s2 % x == 0 ? 1.5 : 1, 0xE4E3FD, 0.4);
                g.moveTo(x, 0);
                g.lineTo(x,h);
            }
            for ( var y:int = 0; y < h; y += s1 )
            {
                g.lineStyle((y/s1) % s2 == 0 ? 1.5 : 1, 0xE4E3FD, 0.4);
                g.moveTo(0, y);
                g.lineTo(w,y);
            }
            
            s.cacheAsBitmap = true;
            //s.alpha = .4;
        }
        
        private function initPrelinNoise():void 
        {
            
            // http://www.houseofthead.com/blog/flash-as3-perlin-noise-explained-and-demonstrated-part-1/
            
            var bitmapData:BitmapData = new BitmapData(w, h, true);
            prelinNoise = new Bitmap(bitmapData);
            
            addChild(prelinNoise);
            
            var offsets:Array = []; var speeds:Array = [];
            var numOctaves:int = 5;
            
            for (var o:int = 0; o < numOctaves; o++)
            {
                offsets[o] = new Point(0,0);
            }
            
            speeds[0] = new Point( -2, -0.6); 
            speeds[1] = new Point( -0.3, -1.4); 
            speeds[2] = new Point(0.3, -1.3); 
            speeds[3] = new Point( -1.8, -1.1); 
            speeds[4] = new Point(0.9,1.6); 
            
            //addEventListener(Event.ENTER_FRAME, animate);
            
            bitmapData.perlinNoise(234,190,numOctaves,33997,true,true,11,true,offsets);
            
            function animate(e:Event):void {
                
                for(var o:int=0;o<numOctaves;o++){
                    offsets[o].x += speeds[o].x;
                    offsets[o].y += speeds[o].y;
                }
                
                bitmapData.perlinNoise(234,190,numOctaves,33997,true,true,11,true,offsets);
            }
        }
    }
    
}