/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kSpy
 */

package {
    import flash.ui.Keyboard;
    import flash.text.TextFieldType;
    import flash.events.KeyboardEvent;
    import flash.display.Graphics;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var tf:TextField = new TextField();
        private var values_a:Array = [
                   25, 17, 0];
        private var values_b:Array = [9];
        private var graph:Sprite = new Sprite();
        private var graph2:Sprite = new Sprite();
        
        private var geomStart:TextField;
        private var geomVal:TextField;
        
        private var positive:Number = 36;
        private var negative:Number = 34;
        private var posPercent:Number = 0;
        
        // показатели EUR/USD с полуночи в пятницу
        
        private var maxDown:Number = 10;
        
        public function FlashTest() {
            // write as3 code here..
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = 'start';
            tf.scaleX = tf.scaleY = 1.2;
            addChild(tf);
            printGeom(1,2.43);
            
            addChild(graph2);
            addChild(graph);
            drawValuer(graph,0xffaa00,values_a,2,400);
            
            drawValuer(graph2,0xaa0033,values_b,1,400);
            
            geomStart = new TextField();
            geomStart.type = TextFieldType.INPUT;
            geomStart.border = true;
            geomStart.autoSize = TextFieldAutoSize.LEFT;
            geomStart.x = 240;
            geomStart.y = 10;
            geomStart.scaleX = geomStart.scaleY = 1.2;
            geomStart.text = '20';
            addChild(geomStart);
            
            geomVal = new TextField();
            geomVal.type = TextFieldType.INPUT;
            geomVal.border = true;
            geomVal.autoSize = TextFieldAutoSize.LEFT;
            geomVal.x = 240;
            geomVal.y = 40;
            geomVal.scaleX = geomVal.scaleY = 1.2;
            geomVal.text = '2.43';
            addChild(geomVal);
            
            posPercent = Math.floor(positive/((positive+negative)/100));
            tf.appendText('\n\n positive = '+posPercent+'%\t \t negative = '+(100-posPercent)+'%\n profit = '+(80*positive-100*negative)/100+'%');
            tf.appendText('\n непрерывный проигрыш '+maxDown);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN,calculate);
        }
        private function calculate(e:KeyboardEvent):void {
            if(e.keyCode == Keyboard.ENTER){
                //geomStart.text = String(Number(geomStart.text));
                //geomVal.type = String(Number(geomVal.text));
                
                printGeom(Number(geomStart.text),Number(geomVal.text));
            }
        }

        private function printGeom(start:Number,val:Number):void {
            tf.text = '';
            for(var i:int=1; i<=5; i++){
                tf.appendText('\n'+i+' step = '+nGeom(start,val,i)+'\t summ = '+sGeom(start,val,i));
                //values_b.push(sGeom(start,val,i));
            }
        }

        private function drawValuer(to:Sprite, color:uint, values:Array, lower:Number = 100,width:Number = 300):void {
            var g:Graphics = to.graphics;
            var st:Number = width/values.length;
            g.beginFill(color,0.4);
            g.lineStyle(1,color);
            g.moveTo(0,300);
            g.lineTo(0,300-values[0]/lower);
            for(var i:int=1; i<values.length; i++){
                g.lineTo(i*st,300-values[i]/lower);
            }
            g.lineTo((i-1)*st,300);
            g.lineTo(0,300);
        }
        
        // return n of geometric progression
        private function nGeom(b1:Number, q:Number, n:Number):Number {
            return Math.floor(b1*Math.pow(q,n-1));
        }
        
        // return summ of n geometric progression
        private function sGeom(b1:Number, q:Number, n:Number):Number {
            return Math.floor( (b1*(1-Math.pow(q,n)))/(1-q) );
        }


    }
}