/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kSW4
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	[SWF(backgroundColor="0x333333")]
	public class ActTest extends Sprite
	{
		/**
		 * load an *.ACT file ( Adobe Color Table )
		 * and renders the swatches
		 */
		private var act:ACTLoader;
		public function ActTest()
		{
			act = new ACTLoader();
			act.addEventListener( Event.COMPLETE, onComplete );
			// try "birds_" + 0 - 15 + ".act"
			act.load( "http://www.nicoptere.net/dump/act/birds_5.act" );
		}
		
		private function onComplete(e:Event):void 
		{
			act.removeEventListener( Event.COMPLETE, onComplete );
			act.renderPalette( graphics, new Rectangle( 10, 10, stage.stageWidth - 20, stage.stageHeight -20 ) );
		}
	}
}
import flash.display.Graphics;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.geom.Rectangle;
import flash.net.URLRequest;
import flash.net.URLStream;
import flash.utils.ByteArray;

/**
 * @author Nicolas Barradeau
 * http://en.nicoptere.net
 */
internal class ACTLoader extends EventDispatcher 
{
	
	private var loader:URLStream;
	private var _colors:Vector.<int>;
	public function ACTLoader() 
	{
		
		loader = new URLStream();
		loader.addEventListener( Event.COMPLETE, onComplete );
		
	}
	
	public function load( url:String ):void
	{
		
		loader.load( new URLRequest( url ) );
		
	}
	
	private function onComplete(e:Event):void 
	{
		var ba:ByteArray = new ByteArray();
		loader.readBytes( ba );
		ba.position = 0;
		
		var blackfoundOnce:Boolean = false;
		
		colors = new Vector.<int>();
		while ( ba.bytesAvailable > 0 )
		{
			
			var r:int = ba.readByte() << 16;
			var g:int = ba.readByte() << 8;
			var b:int = ba.readByte();
			var col:int = r | g | b;
			
			if ( col == 0 && blackfoundOnce ) break;
			if ( col == 0 ) blackfoundOnce = true;
			
			colors.push( col );
			
		}
		//removes last black swatch
		if( colors.length < 0xFF && colors[colors.length -1 ] == 0 ) colors.pop();
		dispatchEvent( new Event( Event.COMPLETE ) );
		
	}
	
	public function renderPalette( graphics:Graphics, rect:Rectangle ):void 
	{
		var w:int = rect.width / colors.length;
		var ox:int = 0;
		for each (var col:int in colors) 
		{
			graphics.beginFill( col );
			graphics.drawRect( rect.x + ox, rect.y, w, rect.height );
			ox += w;
		}
	}
	
	public function get colors():Vector.<int> 
	{
		return _colors;
	}
	
	public function set colors(value:Vector.<int>):void 
	{
		_colors = value;
	}
}