/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kRbx
 */

/*
 * press any key
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.filters.*;
	import flash.system.Capabilities;
	import flash.system.IME;
	import caurina.transitions.Tweener;
	
	[SWF(width = "465", height = "465", backgroundColor = 0xFFFFFF, frameRate = "60")]
	
	public class Kirari extends Sprite 
	{
		private var container:Sprite = new Sprite();
		private var tft:TextFormat = new TextFormat();
		public var t:Number = 0;
		public var lastT:Number = 0;
		public function Kirari():void 
		{
			//bg
			graphics.beginFill(0);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			
			//ime off
			if (Capabilities.hasIME)
			{
				try
				{
					IME.enabled = false;
				}
				catch (e:Error) {}
			}
			
			//text
			tft.align = TextFormatAlign.CENTER;
			tft.bold = true;
			tft.font = "Verdana";
			tft.size = 60;
			
			//texts container
			container.x = stage.stageWidth / 2;
			container.y = stage.stageHeight / 2;
			addChild(container);
			
			//event
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
		}
		private function keyDownHandler(e:KeyboardEvent):void 
		{
			var cc:uint = e.charCode;
			
			// lower case keys, so make upper case.
			if (97 <= cc && cc <= 122) cc -= 32;
			
			if ( cc == 8) //Backspace
			{
				delText();
			}
			else if (
				cc == 32 // Space
				|| (cc >= 65 && cc <= 90) //letters
				|| (cc >= 48 && cc <= 57) //numbers 
			)
			{
				addText(String.fromCharCode(cc));
			}
		}
		private function addText(str:String):void 
		{
			if (30 < container.numChildren) return;
			var tfd:KirariText = new KirariText();
			tfd.defaultTextFormat = tft;
			tfd.text = str;
			tfd.textColor = 0xddce44;
			tfd.mouseEnabled = false;
			tfd.autoSize = TextFieldAutoSize.CENTER;
			container.addChild(tfd);
			relocTexts();
		}
		private function delText():void 
		{
			if (container.numChildren < 1) return;
			container.removeChildAt(container.numChildren - 1);
			if (0 < container.numChildren) 
			{
				relocTexts();
			}
			else
			{
				Tweener.removeTweens(this);
			}
		}
		private function relocTexts():void 
		{
			for (var i:Number = 0; i < container.numChildren; i++)
			{
				var pt:Point = Point.polar(5 * container.numChildren + 30, Math.PI + Math.PI * 2 * i / container.numChildren);
				var tfd:TextField = TextField(container.getChildAt(i));
				
				tfd.filters = [
					new BevelFilter(4, 180, 0xffffc6, 1.0, 0x6c5718, 0.5, 4, 4, 1 )
				]		
				
				Tweener.addTween(tfd, {
					x: pt.x - tfd.width/2,
					y: pt.y * 0.9 - tfd.height/2,
					time: 0.5
				})
			}
			
			
			t = 0;
			lastT = 0;
			Tweener.removeTweens(this);
			Tweener.addTween(this, {
				t: container.numChildren,
				delay:0.4,
				time: 1.0,//container.numChildren * 0.1,
				transition: "linear",
				onUpdate: function ():void 
				{
					for (var i:int= lastT; i < t; i++)
					{
						var tfd:KirariText = KirariText(container.getChildAt(i));
						
						tfd.t = 0;
						Tweener.addTween(tfd, {
							t:1.0,
							time:0.5 +Math.random()*0.5,
							transition:"easeOutSine",
							onUpdate: function ():void 
							{
								tfd.filters = [
									new BevelFilter(6, 180 * tfd.t, 0xffffc6, 1.0, 0x6c5718, 0.5, 4,4,10)
								];
							},
							onComplete: function ():void 
							{
								tfd.t = 0;
								Tweener.addTween(tfd, {
									t:1.0,
									time:0.5,
									transition: "easeOutCubic",
									onUpdate:function ():void 
									{
										tfd.filters = [
											new BevelFilter(6 - tfd.t * 2, 180, 0xffffc6, 1.0, 0x6c5718, 0.5, 4, 4, 10 - tfd.t * 9 )
										]										
									}
								});
							}
						});
					}
					lastT = Math.ceil(t);
				}
			})
		}
	}
	
}
import flash.text.TextField;
class KirariText
extends TextField
{
	public var t:Number;
}