/**
 * Copyright itkr ( http://wonderfl.net/user/itkr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kRX2
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import caurina.transitions.Tweener;
    
    public class Main extends Sprite {
        /* *******************************
         * 大域変数
         * ****************************** */
        //すべてのボックスを格納する二重配列
        private var boxes:Array = new Array();
        //次に光らせるすべてのボックスを含む配列
        private var allNextShine:Array = new Array();
        //クリック回数を保持する
        private var count:int = 0;

        /* *******************************
         * 定数
         * ****************************** */
         //１リズムの秒数(*1/1000)
        private const BEAT_FRAME:Number = 4;
        //ビート数
        private const BEAT:Number = 16;
        //１ビートの秒数(*1/1000)
        private const BEAT_TIME:Number = BEAT_FRAME/BEAT;

        
        /* *******************************
         * コンストラクタ
         * ****************************** */
        public function Main() {
            var box:Sprite;
            var boxesY:Array;
            for(var i:int=0;i<int(460/10);i++){ //@TODO:定数化
                boxesY = new Array();
                    for(var j:int=0;j<int(460/10);j++){ //@TODO:定数化
                        box = new Sprite();
                        box.graphics.beginFill(0x6699cc);
                        box.graphics.drawRect(0,0,9,9);
                        box.graphics.endFill();
                        addChild(box);
                        box.x = i*10;
                        box.y = j*10;
                        box.alpha = 0.2;
                        box.addEventListener(MouseEvent.CLICK,onClick);
                        box.addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
                        box.addEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
                        box.name =i.toString() + "," + j.toString();
                        boxesY.push(box);
                    }
                    boxes.push(boxesY);
            }
            setNextShine(17,20);
            var timer1:Timer = new Timer(BEAT_FRAME*1000);
            timer1.addEventListener(TimerEvent.TIMER,doRhythm);
            timer1.start();
        }

        /* *******************************
         * ボックスを順番に光らせる
         * 第一引数：Array<Sprite>（光らせるボックスの位置）
         * 返り値：なし
         * ****************************** */
         private function doRhythm(obj:TimerEvent):void{
            var i:int=0;
            for each(var mcs:Array in allNextShine){
                i=0;
                //@HAS ISSUE:Booleanを混同させないためにダミーのSpriteを使う？
                for each(var mc in mcs){
                    if(mcs[i]){
                        Tweener.addTween(mcs[i],
                                     {delay:BEAT_TIME + (BEAT_TIME*i),
                                     time:0.25,
                                     alpha:0.5});
                        Tweener.addTween(mcs[i],
                                     {delay:BEAT_TIME + (BEAT_TIME*i)+0.25,
                                     time:3,
                                     alpha:0.2});
                    }
                    i++;
                }
            }
        }

        /* *******************************
         * 次のアクションのリストを作る
         * 第一引数：int
         * 第二引数：int
         * 返り値：なし
         * ****************************** */
        private function setNextShine(x:int, y:int):void{
        　    //@HAS ISSUE:Booleanを混同させないためにダミーのSpriteを使う？
            //リズムを決める配列(@HAS ISSUE:パラメータで受け取る？)
            var rhythm:Array = new Array(true,true,true,true,true,false,true,true,true,false,true,true,false,true,true,true);
            var nextShine:Array = new Array();
            for(var i:int=0;i<BEAT;i++){
                if(x<0||y<0||45<x||45<y){ //@TODO:定数化
                    nextShine.push(false);
                    x++;
                    y++;
                }else if(rhythm[i]){
                    switch(int(count/2)){
                        case 0 :
                            nextShine.push(boxes[x][y]);
                            x++;
                            break;
                        case 1 :
                            nextShine.push(boxes[x][y]);
                            x--;
                            break;
                        case 2 :
                            nextShine.push(boxes[x][y]);
                            y++;
                            break;
                        case 3 :
                            nextShine.push(boxes[x][y]);
                            y--;
                            break;
                        case 4 :
                            nextShine.push(boxes[x][y]);
                            x++;
                            y++;
                            break;
                        case 5 :
                            nextShine.push(boxes[x][y]);
                            x++;
                            y--;
                            break;
                        case 6 :
                            nextShine.push(boxes[x][y]);
                            x--;
                            y--;
                            break;
                        case 7 :
                            nextShine.push(boxes[x][y]);
                            x--;
                            y++;
                            break;
                        default : 
                            nextShine.push(boxes[x][y]);
                            x = x+ int(Math.random()*10/2);
                            y = y+ int(Math.random()*10/2);
                    }
                }else{
                    nextShine.push(false);
                }
            }
            allNextShine.push(nextShine);
            count++;
            if(count>18){
                count = 0;
            }
        }

        /* *******************************
         * ボックスがクリックされたときの動作
         *  =>クリックされたボックスの座標(配列の添字)を取得する
         * 第一引数：MouseEvent
         * 返り値：なし
         * ****************************** */
        private function onClick(obj:MouseEvent):void{
            obj.target.alpha = 0.5;
            var x:int = -1;
            var y:int = -1;
            var i:uint = 0;
            for each(var boxesY:Array in boxes){
                if(boxesY.indexOf(obj.target)!=-1){
                    y = boxesY.indexOf(obj.target);
                    x = i;
                }
                i++;
            }
             setNextShine(x,y);
        }

        /* *******************************
         * ボックスにマウスが乗ったときの動作
         *  =>マウスが乗ったSpriteの大きさを変える
         * 第一引数：MouseEvent
         * 返り値：なし
         * ****************************** */
        private function onMouseOver(obj:MouseEvent):void{
            obj.target.scaleX = 1.2;
            obj.target.scaleY= 1.2;
        }

        /* *******************************
         * ボックスからマウスが離れたときの動作
         *  =>マウスが離れたSpriteの大きさを元に戻す
         * 第一引数：MouseEvent
         * 返り値：なし
         * ****************************** */
        private function onMouseOut(obj:MouseEvent):void{
            obj.target.scaleX = 1;
            obj.target.scaleY= 1;
        }
    }
}
