/**
 * Copyright potix2 ( http://wonderfl.net/user/potix2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kR7y
 */

// forked from potix2's Project Euler 1
//@see http://projecteuler.net/index.php?section=problems&id=8
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.events.Event;
    
    public class Euler extends Sprite {
        private function main():void {
/*
73167176531330624919225119674426574742355349194934
96983520312774506326239578318016984801869478851843
85861560789112949495459501737958331952853208805511
12540698747158523863050715693290963295227443043557
66896648950445244523161731856403098711121722383113
62229893423380308135336276614282806444486645238749
30358907296290491560440772390713810515859307960866
70172427121883998797908792274921901699720888093776
65727333001053367881220235421809751254540594752243
52584907711670556013604839586446706324415722155397
53697817977846174064955149290862569321978468622482
83972241375657056057490261407972968652414535100474
82166370484403199890008895243450658541227588666881
16427171479924442928230863465674813919123162824586
17866458359124566529476545682848912883142607690042
24219022671055626321111109370544217506941658960408
07198403850962455444362981230987879927244284909188
84580156166097919133875499200524063689912560717606
05886116467109405077541002256983155200055935729725
71636269561882670428252483600823257530420752963450
*/	
        		for ( var i:int = 1; i < 40; i++ ) {
        			log('#' + i + ': ' + VectorUtil.product(VectorUtil.range(i, i+5)));
        		}
        }
        
        // setup
    		private var _console:TextField;
        public function Euler() {
        		addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event):void {
        	    	_console = new TextField();
        	    	_console.multiline = true;
        	    	_console.selectable = true;
        	    	_console.autoSize = TextFieldAutoSize.LEFT;
        		addChild(_console);
        		main();
        }
         
        private function log(msg:String):void {
        		_console.appendText("\n" + msg);
        }
        
        private function dumpVector(v:Vector.<Number>):void {
        		v.forEach(function (item:Number, index:uint, vect:Vector.<Number>):void {
        			this.log(item);
        		}, this);       	
        }
        
    }
}
class VectorUtil {
	public static function map(v:Vector.<Number>, func:Function):Vector.<Number> {
			var ret:Vector.<Number> = new Vector.<Number>(v.length);
			v.forEach(function(item:Number, index:int, _v:Vector.<Number>):void {
				ret[index] = func(item);
			});
			return ret;
	}
	
	public static function accumlate(v:Vector.<Number>, init:Number, func:Function):Number {				
			var ret:Number = init;
			v.forEach(function(item:Number, index:int, vect:Vector.<Number>):void {
				ret = func(ret, item);
			});
			return ret;
	}
	
	public static function sum(v:Vector.<Number>):Number {
		return VectorUtil.accumlate(v, 0, function(a:Number, b:Number):Number { return a + b;	 	});
	}
	
	public static function product(v:Vector.<Number>):Number {
		return VectorUtil.accumlate(v, 1, function(a:Number, b:Number):Number { return a * b; });
	}
	
	public static function range(min:Number, max:Number):Vector.<Number> {
		var ret:Vector.<Number> = new Vector.<Number>(max - min + 1);
		var i:Number = 0;
		while(i + min <= max ) {
			ret[i] = min + i;
			i++;
		}
		return ret;
	}
}

