/**
 * Copyright osanine ( http://wonderfl.net/user/osanine )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kQJC
 */

package {
    import flash.geom.Rectangle;
    import flash.display.AVM1Movie;
    import flash.display.Graphics;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.text.TextField;
    import com.bit101.components.HSlider;
    
    [SWF(backgroundcolor="#FFFFFF",width="465",height="465")]
    public class Oppai extends Sprite {
        
        private const PI:Number = 3.1415926535;
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        private const CENTER:Point = new Point(WIDTH/2,HEIGHT/2+40);
        private const R:int = 190;
        private const MAXN:int = 715827882;
        
        //main sprite
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        private var canvas:Sprite;
        
        private var text:TextField;
        private var zoomText:TextField;
        
        private var slider:HSlider;
        private var zoomslider:HSlider;
        
        
        private var pi:Number;
        private var n:int;
        private var zoom:int;
        
        
        
        
        public function Oppai() {
            init();
        }
       
        private function init():void{
            clear();
            
            //setting main sprite
            bmd = new BitmapData(WIDTH,HEIGHT);
            bmp = new Bitmap(bmd);
            canvas = new Sprite();
            addChild(bmp);
            
            //pi slider
            var panel : Sprite = new Sprite();
            addChild(panel);
            slider = new HSlider(panel,15,10,updateN);
            slider.minimum = 0;
            slider.maximum = 10;
            slider.tick = 0.1;
            slider.value = 2.0;
            
            createText(0,8,"pi");
            text = new TextField();
            text.x = 10;
            text.y = 40;
            addChild(text);
            
            setText(3,6);
            
            // zoom slider
            zoomslider = new HSlider(panel,15,25,updateZoom);
            zoomslider.minimum = 0;
            zoomslider.maximum = 9;
           
                      
            createText(0,23,"X");
            zoomText = new TextField();
            zoomText.x = 10;
            zoomText.y = 65;
            zoomText.text = "x1";
            addChild(zoomText);
            
           
            zoom = 1;
            updateN();
            drawPolygon(CENTER,n,R,zoom);
            
            for(var i:int=0;i<10;++i){}
            i+=1;
            
            var j:int = j + 1;
        }
        
        private function clear():void {
            //clear background
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0,0,WIDTH,HEIGHT);
            graphics.endFill();
        }

        
        private function drawPolygon(coord:Point,n:int,r:int,z:int):void{
            var x : Number = coord.x;
            var y : Number = coord.y+r*(z-1);
            
            r *= z;
            
            canvas.graphics.clear();
            canvas.graphics.lineStyle(1,0x000000);
            
            if(n>1000)n=1000;
            
            for(var i:int = 0;i<n;++i){
                var sangle:Number = 2 * PI * i / n;
                var eangle:Number = 2 * PI * ((i+1)%n) / n;
                
                canvas.graphics.moveTo(x+r*Math.sin(sangle),y-r*Math.cos(sangle));
                canvas.graphics.lineTo(x+r*Math.sin(eangle),y-r*Math.cos(eangle));
            }
            
            bmd.lock();
            bmd.fillRect(new Rectangle(0,0,WIDTH,HEIGHT),0xFFFFFF);
            bmd.draw(canvas);
            bmd.unlock();
        }
        
        private function setText(pi:Number,n:int):void{
            text.text = "π = " + pi + "\nN = " + n;
        }

        
        private function f(n:Number,pi:Number):Number{
            return n*Math.cos(PI*(0.5-1.0/n)) - pi;
        }

        
        private function solve(pi:Number):int{
            var maxn:Number = 4;
            while(f(maxn,pi) < 0 && maxn < MAXN){
                maxn *= 2;
            }
            var minn:Number = maxn/2;
            
            if(maxn >= MAXN)return MAXN;
            
            var counter:int = 0;
            while(maxn - minn >= 0.1 && counter < 1000){
                if(f((maxn+minn)/2,pi) > 0){
                    maxn = minn + (maxn-minn)/2.0;
                }else{
                    //if(maxn-minn == 1)minn = maxn;
                    minn = minn + (maxn-minn)/2.0;
                }
            }
            
            //setText(maxn,minn);
           
            return maxn;
        }
        
        private var lastval:int = 0;
        private function updateN(...arg):void{
            var val:Number = slider.value;
            var p:Number = Math.pow(10,Math.floor(val));
            var p2:Number = Math.pow(10,Math.floor(val+1));
            
            var p3:Number = Math.floor(PI*p)/p;
            var p4:Number = Math.floor(PI*p2)/p2;
            
            pi = p3 + (val-Math.floor(val))*(p4-p3);
            n = solve(pi);
            
            setText(pi,n);
            
            if(n==lastval)return;
            lastval = n;
            
            drawPolygon(CENTER,n,R,zoom);
        }
        
        private function updateZoom(...args):void{
            var z:int = Math.pow(2,Math.floor(zoomslider.value));
            
            zoomText.text = "x" + z;
            
            if(zoom == z)return;
            
            zoom = z;
            
            drawPolygon(CENTER,n,R,zoom);
        }


        private function createText(x:int,y:int,str:String):void{
            var t:TextField = new TextField();
            t.text = str;
            t.x = x;
            t.y = y;
            t.width = 15;
            
            addChild(t);
        }

    }
}