/**
 * Copyright itsukichang ( http://wonderfl.net/user/itsukichang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kPYL
 */

package {
    
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.Event;
    
    [SWF(width = "550", height = "400", backgroundColor = "0xffffff", frameRate = "30")]
    
    public class Main extends Sprite {
        
        private var _ballList:Vector.<Ball>;
        private var _ball:Ball;
        private var _oldAns:uint = 0;
        private var _ans:uint = 0;
        
        private var _cnt:uint = 0;
        private var _highScore:uint = 0;
        
        private var _label:Texts;
        private var _countText:Texts;
        private var _highScoreText:Texts;
        
        private var _nowTime:Number;
        private var _ansTime:Number = 10000;
        
        private var _playFlag:Boolean;
        
        public function Main() {
            _ballList = new Vector.<Ball>;
            init();
        }
        
        private function init():void {
            textInit();
            for (var i:uint = 0; i < 10; i++) {
                _ball = new Ball(30, 0x333366);
                _ball.x = i * (stage.stageWidth / 8) - (stage.stageWidth / 16);
                _ball.y = stage.stageHeight / 2;
                _ballList[i] = _ball;
                addChild(_ballList[i]);
                _ballList[i].addEventListener(MouseEvent.MOUSE_OVER, onOver);
                _ballList[i].addEventListener(MouseEvent.MOUSE_OUT, onOut);
                _ballList[i].name = String(i);
                _ballList[i].mouseChildren = false;
                trace(_ballList[i].name);
                
            }
            stage.addEventListener(MouseEvent.CLICK, onClick);
            
        }
        
        private function textInit():void {
            _label = new Texts("クリックでスタート！",30);
            _label.x = stage.stageWidth / 2 - _label.width / 2;
            _label.y = 300;
            addChild(_label);
            
            _countText = new Texts("",30);
            _countText.x = stage.stageWidth / 2 - _countText.width / 2;
            _countText.y = 270;
            addChild(_countText);
            _highScoreText = new Texts("",15);
            addChild(_highScoreText);
        }
        
        private function onOver(e:MouseEvent):void {
            var n:uint = uint(e.target.name);
            _ballList[n].alpha = 0.3;
            _ballList[n-1].alpha = 0.7;
            _ballList[n+1].alpha = 0.7;
            
            if (n == _ans && _playFlag) {
                trace("ok!");
                nextAns();
                _cnt++;
                _countText.txt = _cnt.toString() + "回";
                _countText.x = stage.stageWidth / 2 - _countText.width / 2;
            }
        }
        
        private function onOut(e:MouseEvent):void {
            var n:uint = uint(e.target.name);
            _ballList[n].alpha = 1;
            _ballList[n-1].alpha = 1;
            _ballList[n+1].alpha = 1;
        }
        
        private function nextAns():void {
            do {
                _ans = Math.round(Math.random()*7) + 1;
                trace(_ans);
            } while(_ans == _oldAns);
            
            _ballList[_ans].colorTrans(0x990033);
            
            _ballList[_oldAns].colorTrans(0x333366);
            _oldAns = _ans;
        }
        
        private function onClick(e:MouseEvent):void {
            //_title.visible = false;
            if (!_playFlag) {
                _label.txt = "";
                _cnt = 0;
                _countText.txt = _cnt.toString() + "回";
                do {
                    _ans = Math.round(Math.random()*7) + 1;
                    trace(_ans);
                } while(_ans == _oldAns);
                
                _ballList[_ans].colorTrans(0x990033);
                _ballList[_oldAns].colorTrans(0x333366);
                _oldAns = _ans;
                stage.addEventListener(Event.ENTER_FRAME,onLoop);
                var d:Date = new Date();
                _nowTime = d.getTime();
                _playFlag = true;
            }
        }
        
        private function onLoop(e:Event):void {
                var d:Date = new Date();
                var rem:Number = (_ansTime - (d.getTime() - _nowTime));
                
                if (rem < 0) {
                    _label.txt = "そこまで！";
                    endProcess();                    
                } else {
                    var sec:int = rem / 1000;
                    var msec:int = (rem % 1000) / 10;
                    _label.txt = sec + "." +  msec +  "秒";
                }
                    _label.x = stage.stageWidth / 2 - _label.width / 2;
        }
        
        private function endProcess():void {
            stage.removeEventListener(Event.ENTER_FRAME, onLoop);
            if (_cnt > _highScore) {
                _highScoreText.txt = "HIGI_SCORE: " + _cnt.toString();
            }
            _playFlag = false;
        }
    }
}


    
import flash.display.Sprite;    
class Ball extends Sprite  {
        
    private var _col:uint;
    private var _r:Number;
    private var _sp:Sprite;
    
    public function Ball(r:Number = 10, col:uint = 0x0) {
        _r = r;
        _col = col;
        init();
    }
    
    private function init():void {
        _sp = new Sprite();
        _sp.graphics.beginFill(_col);
        _sp.graphics.drawCircle(0, 0, _r);
        _sp.graphics.endFill();    
        addChild(_sp);
    }
    
    public function colorTrans(col:uint):void {
        _col = col;    
        reDraw();
    }
    
    private function reDraw():void {
        _sp.graphics.clear();
        _sp.graphics.beginFill(_col);
        _sp.graphics.drawCircle(0, 0, _r);
        _sp.graphics.endFill();    
    }
}


import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;

class Texts extends TextField {
    
    private var _s:String;
    private var _size:Number;
    private var _col:uint;
    
    public function Texts(s:String, n:Number = 10, col:uint = 0x0) {
        _s = s;
        _size = n;
        _col = col
        init();
    }
    
    private function init():void {
        this.defaultTextFormat = new TextFormat("", _size, _col);
        this.autoSize = TextFieldAutoSize.LEFT;
        this.text = _s;
    }
    
    public function set txt(s:String):void {
        this.text = s;
    }
}