/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kPNm
 */

// forked from LawrieCape's forked from: PV3d Plane Face Mouse Example
// forked from FlashBum's PV3d Plane Face Mouse Example
//Using Joel Gillman’s Map Function - see - http://www.lawriecape.co.uk/theblog/?p=209
package  
{
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;

    import flash.events.Event;

    /**
     * @author jessefreeman
     */
    public class FlashTest extends BasicView 
    {

        private var plane : Plane;

                public var maxRot:int = 50;

        public function FlashTest()
        {
            super( );
            
            create3dObject( );
            startRendering( );
        }

        private function create3dObject() : void
        {
            var mat : ColorMaterial = new ColorMaterial( 0xCC0000, 1, true );
            plane = new Plane( mat );
            scene.addChild( plane );
        }
        
        /**
         * This rotates the plane to "face" the mouse.
         */
        protected function updateMouseRotation() : void {
            plane.rotationX = map(mouseY,0,stage.stageWidth, maxRot,-maxRot);
            plane.rotationY = map(mouseX,0,stage.stageHeight,maxRot,-maxRot);
        }
        
        override protected function onRenderTick(event:Event = null):void
        {
            updateMouseRotation();
            super.onRenderTick(event);
        }
        
        //Map the plane's rotation to a value in the defined range, based on the mouse position.
        private function map(v:Number, a:Number, b:Number, x:Number = 0, y:Number = 1):Number {
            return (v == a) ? x : (v - a) * (y - x) / (b - a) + x;
        }
        
    }
}
