/**
 * Copyright faunus ( http://wonderfl.net/user/faunus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kP2W
 */

// forked from azuremous's forked from: KazoeSukuiNoLimit
// forked from sekiryou's KazoeSukuiNoLimit
//順番どおりに金魚すくえ！
package {
	import flash.utils.*;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.text.*;
	import flash.utils.Timer;
    import flash.events.TimerEvent;
    import funnel.*;
    import funnel.ui.*;

	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]

	public class KazoeSukuiNoLimit extends Sprite {
		private const STAGE_WIDTH:Number = stage.stageWidth;
		private const STAGE_HEIGHT:Number = stage.stageHeight;
		private const STAGE_CENTER_X:Number = stage.stageWidth / 2;
		private const STAGE_CENTER_Y:Number = stage.stageHeight / 2;
		private var time:Number;
		private var catched:uint;
		private var amount:uint;
		private var next:uint = 0;
		private var goldfishs:Array = [];
		private var catchText:TextField = new TextField();
		private var timeText:TextField = new TextField();
		private const TIME_LIMIT:Number = 600000;
		private var startTime:Number;
		private var nowTime:Number;
		private var arduino:Arduino;
		private var config:Configuration = Arduino.FIRMATA;
		private var timer:Timer;
		//private var button:Pin = arduino.digitalPin(6);
		//private var led:LED =new LED(arduino.digitalPin(11));
		
		public function KazoeSukuiNoLimit() {
			init();
		}
		
		
		private function init():void {
			catched = 0;
			amount = 0;
			next = 0;
			water();
			board();
			add( 5 );
			addEventListener( Event.ENTER_FRAME, _onEnterFrame );
			startTime = getTimer();
			
			
			config.setDigitalPinMode(6, DIN);
            arduino = new Arduino(config);
            var button:Pin = arduino.digitalPin(6);
            var led:LED =new LED(arduino.digitalPin(13));
           
           addEventListener( MouseEvent.MOUSE_DOWN, 
           function ledFresh( e:MouseEvent ):void {
           	
		led.value = 1.0;
		timer = new Timer(400, 0);
		
		timer.addEventListener(TimerEvent.TIMER, function onTimer(e:TimerEvent):void {
			led.value = 0.0;
		});
		
        timer.start();
		
	    });
		}
		
		
		private function water():void {
			var surface:BitmapData = new BitmapData( 465, 465, false, 0x000000 );
			var randomSeed:Number = Math.floor( Math.random() * 0x0000FF );
			surface.perlinNoise( 230, 230, 22, randomSeed, false, true, 0 | 2 | 12 | 0 );
			addChild(new Bitmap(surface));
		}
		private function board():void {
			var s:Sprite = new Sprite();
			var tf:TextFormat = new TextFormat();
			s.graphics.beginFill( 0x111111 );
			s.graphics.drawRect( 0, 0, 465, 50 );
			s.graphics.endFill();
			addChild( s )

			tf.bold = true;
			tf.size = 20;
			tf.align = TextFormatAlign.LEFT;
			catchText.defaultTextFormat = tf;
			catchText.x = 20;
			catchText.y = 15;
			catchText.selectable = false;
			catchText.border = false;
			catchText.background = false;
			catchText.textColor = 0xFFFFFF;
			catchText.type = TextFieldType.DYNAMIC;
			catchText.width = 128;
			catchText.height = 32;
			addChild( catchText );

			tf.align = TextFormatAlign.CENTER;
			timeText.defaultTextFormat = tf;
			timeText.x = 170;
			timeText.y = 15;
			timeText.selectable = false;
			timeText.border = false;
			timeText.background = false;
			timeText.textColor = 0xFFFFFF;
			timeText.type = TextFieldType.DYNAMIC;
			timeText.width = 128;
			timeText.height = 32;
			addChild( timeText );

			var retryBtn:TextField = new TextField();
			tf.align = TextFormatAlign.RIGHT;
			retryBtn.defaultTextFormat = tf;
			retryBtn.x = 320;
			retryBtn.y = 15;
			retryBtn.selectable = false;
			retryBtn.border = false;
			retryBtn.background = false;
			retryBtn.textColor = 0xFFFFFF;
			retryBtn.type = TextFieldType.DYNAMIC;
			retryBtn.width = 128;
			retryBtn.height = 32;
			retryBtn.text = "retry"
			addChild( retryBtn );

			retryBtn.addEventListener( MouseEvent.CLICK, retryPrepare );
		}
		
		private function retryPrepare(e:MouseEvent):void {
			var i:uint = goldfishs.length
			while (i--) {
				goldfishs[ i ].remove();
				goldfishs.splice( i, 1 );
			}
			retry();
		}
		
		private function retry():void {
			catched = 0;
			amount = 0;
			next = 0;
			goldfishs = [];
			add( 5 );
			startTime = getTimer();
		}
		
		private function textUpdate():void {
			catchText.text = String( catched ) +"匹" ;
			if ( nowTime - startTime < TIME_LIMIT ) {
				timeText.text = String( int( ( nowTime - startTime) / 100 ) / 10 );
			} else {
				timeText.text = "終了"
			}
		}
		private function _onEnterFrame(eventObject:Event):void {
			
			var fishLength:uint = goldfishs.length;
			var grace:Number = 20;
			var boardHeight:Number = 60;
			var removeFlag:Boolean = false;
			var removeNumber:uint;
			nowTime = getTimer();
			textUpdate();
			
			if ( nowTime - startTime < TIME_LIMIT ) {
				for ( var i:uint = 0; i < fishLength; i++) {
					var g:Goldfish = goldfishs[ i ];
					if ( g.inFlag == true ) {
						if ( g.x < 0 - grace || g.x > STAGE_WIDTH + grace || g.y < 0 + boardHeight - grace || g.y > STAGE_HEIGHT + grace ) {
							g.turn();
						}
					} else if ( g.x > 0 && g.x < STAGE_WIDTH && g.y > 0 + boardHeight && g.y < STAGE_HEIGHT ) {
						g.inFlag = true;
					}
					g.px += g.vx;
					g.py += g.vy;
					g.x = g.px + STAGE_CENTER_X;
					g.y = g.py + STAGE_CENTER_Y;
					if ( g.catchFlag == true ) {
						if ( g.pn == catched + 1 ) {
							catched += 1;
							amount -= 1;
							add();
							removeFlag = true;
							removeNumber = i;
						} else {
							g.catchFlag = false;
						}
					}
				}
				if ( removeFlag == true ) {
					removeFlag = false ;
					goldfishs[ removeNumber ].remove();
					goldfishs.splice( removeNumber, 1 );
					
				}
			} else {
				i = goldfishs.length;
				while (i--) {
					g = goldfishs[ i ];
					if ( g != null ) {
						g.remove();
						goldfishs.splice( i, 1 );
					}
				}
			}
		}
		private function add( ad:uint = 2 ) :void {
			for ( var i:uint = 0; i < ad; i++) {
				if ( amount < int( catched / 10 ) + 6 ) {
					var g:Goldfish = new Goldfish( next + 1 );
					next += 1;
					amount += 1;
					goldfishs.push( g );
					g.turn();
					addChild( g );
					setChildIndex( g, 1 )
					g.x = g.px + STAGE_CENTER_X;
					g.y = g.py + STAGE_CENTER_Y;
				}
			}
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.*;
class Goldfish extends Sprite {
	public var pn:uint;
	public var px:Number;
	public var py:Number;
	public var vx:Number;
	public var vy:Number;
	public var vb:Number;
	public var inFlag:Boolean;
	public var catchFlag:Boolean;

	public function Goldfish( pn:uint ):void  {
		this.pn = pn;
		init();
		launchPoint();
	}
	private function init():void {
		var color:uint;
		if ( pn % 5 == 0) {
			color = 0x000000;
		} else {
			color = 0xDD0000;
		}
		graphics.beginFill( color );
		graphics.drawCircle( 50, 8, 3 );
		graphics.drawCircle( 50, -8, 3 );
		graphics.drawCircle( 14, 0, 30 );
		graphics.endFill();

		graphics.beginFill( color );
		graphics.moveTo( 40, 14 );
		graphics.lineTo( 40, -14 );
		graphics.lineTo( 60, -4 );
		graphics.lineTo( 60, 4 );
		graphics.lineTo( 40, 14 );
		graphics.endFill();

		graphics.beginFill( color );
		graphics.lineTo( -12, -8 );
		graphics.curveTo( -24, -24, -50, -28 );
		graphics.curveTo( -34, -24, -34, -12 );
		graphics.curveTo( -34, 0, -64, 0 );
		graphics.curveTo( -34, 0, -34, 12 );
		graphics.curveTo( -34, 24, -50, 28 );
		graphics.curveTo( -24, 24, -12, 8 );

		graphics.moveTo( 24, -24 );
		graphics.curveTo( 24, -38, 10, -38 );
		graphics.curveTo( 10, -24, 28, -24 );
		graphics.moveTo( 24, 24 );
		graphics.curveTo( 24, 38, 10, 38 );
		graphics.curveTo( 10, 24, 28, 24 );
		graphics.endFill();

		var tf:TextFormat = new TextFormat();
		var txt:TextField = new TextField();
		tf.bold = true;
		tf.size = 28;
		tf.align = TextFormatAlign.CENTER;
		txt.defaultTextFormat = tf;
		txt.selectable = false;
		txt.border = false;
		txt.background = false;
		txt.textColor = 0xFFFFFF;
		txt.text = String( pn );
		txt.type = TextFieldType.DYNAMIC;
		txt.width = 64;
		txt.height = 64;

		var bmd:BitmapData = new BitmapData( txt.width, txt.height, true, 0x00000000 );
		bmd.draw( txt );
		var bm:Bitmap = new Bitmap( bmd );
		bm.x = bmd.width / 2;
		bm.y = -bmd.height / 2;
		bm.rotation = 90;
		addChild( bm );

		addEventListener( MouseEvent.MOUSE_DOWN, catchFish );
	}
	private function catchFish( e:MouseEvent ):void {
		catchFlag = true;
		
	}
	private function launchPoint():void {
		px = Math.random() * 100 - 50;
		px = px > 0 ? (px + 240) : (px - 240);
		py = Math.random() * 100 - 50;
		py = py > 0 ? (py + 240) : (py - 180);
	}
	public function turn():void {
		vb = Math.random() * 1.5 + 0.8;
		var cntrAngle:Number = Math.atan2( py, px );
		var angle:Number = cntrAngle + ( Math.random() * ( Math.PI / 8 ) - Math.PI / 16 );
		rotation = ( Math.PI + angle ) * 180 / Math.PI;
		vx = -vb * Math.cos( angle );
		vy = -vb * Math.sin( angle );
	}
	public function remove():void {
		removeEventListener( MouseEvent.MOUSE_DOWN, catchFish );
		parent.removeChild( this );
	}
}