/**
 * Copyright fujiopera ( http://wonderfl.net/user/fujiopera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kOJx
 */

package 
{ 
    import flash.printing.PrintJob; 
    import flash.display.Sprite; 
    import flash.text.TextField; 
    import flash.display.Stage; 
    import flash.geom.Rectangle; 
     
    public class PrintScaleExample extends Sprite 
    { 
        private var bg:Sprite; 
        private var txt:TextField; 
 
        public function PrintScaleExample():void 
        { 
            init(); 
            draw(); 
            printPage(); 
        } 
         
        private function printPage():void 
        { 
            var pj:PrintJob = new PrintJob(); 
            txt.scaleX = 3; 
            txt.scaleY = 2; 
            if (pj.start()) 
            { 
                trace(">> pj.orientation: " + pj.orientation); 
                trace(">> pj.pageWidth: " + pj.pageWidth); 
                trace(">> pj.pageHeight: " + pj.pageHeight); 
                trace(">> pj.paperWidth: " + pj.paperWidth); 
                trace(">> pj.paperHeight: " + pj.paperHeight);     
 
                try 
                { 
                    pj.addPage(this, new Rectangle(0, 0, 300, 400)); 
                } 
                catch (error:Error) 
                { 
                    // Do nothing. 
                } 
                pj.send(); 
            } 
            else 
            { 
                txt.text = "Print job canceled"; 
            } 
            // Reset the txt scale properties. 
            txt.scaleX = 1; 
            txt.scaleY = 1; 
        } 
         
        private function init():void 
        { 
            bg = new Sprite(); 
            bg.graphics.beginFill(0x00FF00); 
            bg.graphics.drawRect(0, 0, 100, 200); 
            bg.graphics.endFill(); 
             
            txt = new TextField(); 
            txt.border = true; 
            txt.text = "Hello World"; 
        } 
         
        private function draw():void 
        { 
            addChild(bg); 
            addChild(txt); 
            txt.x = 50; 
            txt.y = 50; 
        } 
    } 
}