/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kNugn
 */

package {
    //クリップボードテスト
    import flash.display.*;
    import flash.desktop.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.text.*;
    public class FlashTest extends Sprite {
        private var t:TextField = new TextField();
        public function FlashTest() {
            // write as3 code here..
            var clipboard : Clipboard = Clipboard.generalClipboard;
            // コンテキストメニューオブジェクトを作成
            var context_menu:ContextMenu = new ContextMenu();
            
            // クリップボードメニューを有効
            context_menu.clipboardMenu = true;
            
            //「貼り付け」を有効
            context_menu.clipboardItems.paste = true;
            
            // スプライトを生成して配置
            var sprite:Sprite = new Sprite();
            stage.addChild(sprite);
            
            // ステージ全体に矩形を描画
            var g:Graphics = sprite.graphics;
            g.beginFill ( 0xFF0000 , 0.5 );
            g.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            g.endFill();
             /*
                // クリップボードからテキストデータを取得
                var str:String = clipboard.getData(ClipboardFormats.TEXT_FORMAT) as String;
                if(str){
                    t.text = str;
                }
                else t.text = "aa"; 
            */
            // スプライトにコンテキストメニューを登録
            sprite.contextMenu = context_menu;
             
            // 「貼り付け」が選択された時に実行されるイベント
            sprite.addEventListener(Event.PASTE , function (e:Event):void{
                //t.text +="「貼り付け」が選択された\n";
                // OS のクリップボードを取得
                var clipboard : Clipboard = Clipboard.generalClipboard;
                
                // クリップボードからテキストデータを取得
                var str:String = clipboard.getData(ClipboardFormats.TEXT_FORMAT) as String;
            
                if(str){
                    t.text += str;
                }
            })
            addChild(t);
            t.width =400;
            t.height = 300;
            
        }
        private function onPaste(e:Event=null):void{
            var clipboard : Clipboard = Clipboard.generalClipboard;
            // クリップボードからテキストデータを取得
            var str:String = clipboard.getData(ClipboardFormats.TEXT_FORMAT) as String;
            if(str){
                t.text += str;
            }
        }

        
        
    }
}