/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kN81
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=172
    public class Euler172 extends Sprite {
        private var _tf : TextField;
  
        public function Euler172() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            t(solve());
            var g : int = getTimer();
            t((g - s) + " ms");
        }
        
        private var _cache : Array;

        private function solve() : MPI
        {
            _cache = new Array(18);
            var i : int;
            for(i = 0;i < 18;i++)_cache[i] = {};
            
            return rec(0, [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
        }
        
        private function rec(pos : int, ct : Array) : MPI
        {
            if(pos == 18)return new MPI(1);
            
            var code : int = encode(ct);
            if(_cache[pos][code]){
                return _cache[pos][code];
            }
            
            var ret : MPI = new MPI(0);
            for(var i : int = pos == 0 ? 1 : 0;i <= 9;i++){
                if(ct[i] <= 2){
                    ct[i]++;
                    ret.add(rec(pos + 1, ct));
                    ct[i]--;
                }
            }
            _cache[pos][code] = ret;
            return ret;
        }
        
        private function encode(a : Array) : int
        {
            var ret : int = 0;
            for(var i : int = 0;i <= 9;i++){
                ret += a[i] << (2 * i);
            }
            return ret;
        }

	private function t(o : *) : void
	{
            _tf.appendText("" + o + "\n");
	}
    }
}

class MPI
{
    public var d : Vector.<uint>;
    
    public function MPI(v : Number = 0)
    {
        if(v == 0){
            d = Vector.<uint>([0]);
        }else{
            d = Vector.<uint>([]);
            for(var i : Number = v;i != 0;i = Math.floor(i / 10))d.push(i % 10);
        }
    }
    
    public function carry() : void
    {
        for(var i : int = 0;i < d.length;i++){
            var c : uint = d[i] / 10;
            if(c > 0){
                if(i == d.length - 1){
                    d.push(0);
                }
                d[i + 1] += c;
            }
            d[i] %= 10;
        }
    }
    
    public function add(n : MPI) : MPI
    {
        var i : int;
        for(i = 0;i < Math.min(d.length, n.d.length);i++){
            d[i] += n.d[i];
        }
        for(i = d.length;i < n.d.length;i++){
            d.push(n.d[i]);
        }
        carry();
        return this;
    }
    
    public function mul(n : MPI) : MPI
    {
        var ret : Vector.<uint> = new Vector.<uint>(d.length + n.d.length);
        var i : int, j : int;
        for(i = 0;i < ret.length;i++)ret[i] = 0;
        for(i = 0;i < d.length;i++){
            for(j = 0;j < n.d.length;j++){
                ret[i + j] += d[i] * n.d[j];
            }
        }
        d = ret;
        carry();
        shave();
        return this;
    }
    
    public function shave() : void
    {
        for(var i : int = d.length - 1;i >= 1;i--){
            if(d[i] > 0)break;
            d.pop();
        }
    }
    
    public function toString() : String
    {
        var ret : String = "";
        for(var i : int = d.length - 1;i >= 0;i--){
            ret += d[i].toString();
        }
        return ret;
    } 
}