/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kLcc
 */

package {

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.media.Camera;
    import flash.media.Video;
    
    /**
     * Just playing around with webcam...
     * @author Devon O.
     */
    [SWF(width='465', height='465', backgroundColor='#000000', frameRate='31')]
    public class Main extends Sprite {
        
        private var _original:BitmapData;
        private var _display:BitmapData;
        private var _video:Video;
        private var _mat:Matrix;
        private var _xstep:int;
        private var _ystep:int;
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _original = new BitmapData(465, 465, false, 0x000000);
            _display = _original.clone();
            addChild(new Bitmap(_display));
            _mat = new Matrix();
            _xstep = 465 / 31;
            _ystep = 465 / 31;
            
            if (initVideo())
                addEventListener(Event.ENTER_FRAME, drawImage);
                
        }
        
        private function initVideo():Boolean {
            _video = new Video(465, 465);
            
            var camIndex:int = 0;
            for ( var i : int = 0 ; i < Camera.names.length ; i++ ) {
                if ( Camera.names[ i ] == "USB Video Class Video" ) {
                    camIndex = i;
                    break;
                }
            }
            var cam:Camera = Camera.getCamera(String(camIndex));
            
            if (cam != null) {
                cam.setMode(465, 465, 15);
                _video.attachCamera(cam);
                return true;
            }
            
            return false;
        }
        
        private function drawImage(event:Event):void {
            _original.draw(_video);
            _display.lock();
            for (var xx:int = 0; xx < 465; xx += _xstep ) {
                for (var yy:int = 0; yy < 465; yy += _ystep) {
                    var s:Shape = new Shape();
                    s.graphics.beginFill(_original.getPixel(xx, yy));
                    s.graphics.drawRect(0, 0, _xstep, _ystep);
                    _mat.identity();
                    var ang:Number = Math.atan2((yy - stage.mouseY), (xx - stage.mouseX));
                    _mat.rotate(ang);
                    _mat.translate(xx, yy);
                    _display.draw(s, _mat);
                    s = null;
                }
            }
            _display.unlock();
        }
    }
}