/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kKQ5
 */

// forked from aobyrne's forked from: forked from: forked from: QuickBox2D でぽにょぽにょさせてみた
// forked from aobyrne's forked from: forked from: QuickBox2D でぽにょぽにょさせてみた
// forked from aobyrne's forked from: QuickBox2D でぽにょぽにょさせてみ
// forked from Akiyah's QuickBox2D でぽにょぽにょさせてみた
package {
    import flash.events.Event;
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import Box2D.Common.Math.b2Vec2;
    import com.bit101.components.PushButton;
    import com.bit101.components.TextArea;

    public class JointGridOriginalDifferentOrder extends MovieClip {
        private const frequencyHz:Number = 20;
        private const distance:Number = 1;
        private const linesAmount:int = 5;
        private const columnsAmount:int = 7;
        private var sim:QuickBox2D;
        private var bGravity:Boolean;
        private var t:TextArea;
        

        public function JointGridOriginalDifferentOrder() {
            sim = new QuickBox2D(this, { debug:false });
            sim.gravity = new b2Vec2;
            var center:Point = new Point(6, 6);
            var dots:Array = [];
            var i:int;
            var j:int;
            var dot:QuickObject;
            for (j = 0; j < linesAmount; j++) {
                var line:Array = [];
                dots.push(line);
                for (i = 0; i < columnsAmount; i++) {
                    dot = sim.addCircle({x:center.x + (j+1)*distance*Math.cos(i*Math.PI*2/columnsAmount),
                                         y:center.y + (j+1)*distance*Math.sin(i*Math.PI*2/columnsAmount),
                                         radius:0.2,
                                         groupIndex:-1,
                                         fixedRotation:true,
                                         friction:0.1,
                                         density:1,
                                         linearDamping:1,
                                         allowSleep:false,
                                         fillAlpha:0.5});
                                    
                    line.push(dot);
                }
            }
            for (j = 0; j < linesAmount; j++) {
                for (i = 0; i < columnsAmount-1; i++) {
                    sim.addJoint({a:dots[j][i].body, b:dots[j][i+1].body, frequencyHz:frequencyHz,lineColor:0xff0000,lineThickness:3});
                }
            }
            for (j = 0; j < linesAmount-1; j++) {
                for (i = 0; i < columnsAmount; i++) {
                    sim.addJoint({a:dots[j][i].body, b:dots[j+1][i].body, frequencyHz:frequencyHz,lineColor:0xff0000,lineThickness:3});
                }
            }
            
            for (j = 0; j < linesAmount-1; j++) {
                for (i = 0; i < columnsAmount-1; i++) {
                    sim.addJoint({a:dots[j][i].body, b:dots[j+1][i+1].body, frequencyHz:frequencyHz,lineColor:0x00ff00,lineThickness:3});
                }
            }
            for (j = 0; j < linesAmount-1; j++) {
                for (i = 0; i < columnsAmount-1; i++) {
                    sim.addJoint({a:dots[j][i+1].body, b:dots[j+1][i].body, frequencyHz:frequencyHz,lineColor:0,lineThickness:5});
                }
            }
            
            
            for (var k:int = 0; k < linesAmount; k++) 
            {
                sim.addJoint({a:dots[k][columnsAmount-1].body, b:dots[k][0].body, frequencyHz:frequencyHz,lineColor:0xff6600,lineThickness:3});
                
            }
            for (k = 0; k < linesAmount-1; k++) 
            {
                sim.addJoint({a:dots[k][columnsAmount-1].body, b:dots[k+1][0].body, frequencyHz:frequencyHz,lineColor:0xff00ff,lineThickness:3});
                sim.addJoint({a:dots[k+1][columnsAmount-1].body, b:dots[k][0].body, frequencyHz:frequencyHz,lineColor:0xffff00,lineThickness:3});
                
            }
            sim.createStageWalls(); 
            sim.start();                        
            sim.mouseDrag();        
            new PushButton(this,0,0,"g",gravityToggle);
            t = new TextArea(this, 200, 0, "");
            t.visible = false;
        }
        private function cTrace(msg:String):void
        {
            t.text +="\n"+msg;
        }

        private function gravityToggle(e:Event):void
        {
            bGravity=!bGravity;
            sim.stop();
            if(bGravity)
            {
               cTrace('true');
               //sim.w.SetGravity(new b2Vec2(0,10));
               sim.gravity = new b2Vec2(0,10);
            }
            else
            {
                cTrace('false');
                //sim.w.SetGravity(new b2Vec2(0,0));
                sim.gravity = new b2Vec2(0,0);
           }
            sim.start();
        }

    }
}
    
//public class JointGridOriginal 
