/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kKFV
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	import flash.display.BlendMode;
	
	/**
	 * ...
	 * @author 
	 */
	public class Main extends Sprite 
	{
		private var circleList:Array = new Array();
		
		
		private var _canvas:BitmapData;
		private var _canvas_p:BitmapData;
		private var _canvas_back:BitmapData;
		
		private var _step:uint = 0;
		
		public function Main():void 
		{
			Wonderfl.capture_delay( 10 );
			
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			
			_canvas_back = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0xFF000000 );
			addChild( new Bitmap( _canvas_back ) );
			
			_canvas = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00000000 );
			addChild( new Bitmap( _canvas ) );
			
			_canvas_p = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0x00000000 );
			addChild( new Bitmap( _canvas_p ) );
			
			
			
			addEventListener( Event.ENTER_FRAME, Update );
		}
		
		private	function	GenerationCircle() : void
		{
			var circle:Circle = new Circle();
			var x:Number = stage.stageWidth / 2 + Math.random() * 200 - 100;
			var y:Number = stage.stageHeight / 2 + Math.random() * 200 - 100;
			circle.Init( x, y );
			circleList.push( circle );
		}
		

		
		
		private	function	Update(e:Event) : void
		{
			var i:int;
			var j:int;
			var circle:Circle;
			
			for ( i = circleList.length - 1; i >= 0; i-- )
			{
				circle = circleList[i];
				circle.Update();
				if ( circle._alpha <= 0 )	circleList.splice( i, 1 );
			}
			if ( _step % 2 == 0 )	GenerationCircle();
			
			//	交点計算
			var crossPt:Array = new Array();
			for ( i = 0; i < circleList.length; i++ )
			{
				for ( j = 0; j < circleList.length; j++ )
				{
					if ( i == j ) continue;
					HitCheckCircle( circleList[i], circleList[j], crossPt );
				}
			}

			
			var sp:Sprite = new Sprite();
			sp.graphics.clear();
			for ( i = 0; i < circleList.length; i++ )
			{
				circle = circleList[i];
				sp.graphics.lineStyle( 2, 0xFFFFCC, circle._alpha );
				sp.graphics.drawCircle( circle._x, circle._y, circle._r );
			}
			
			
			
			
			_canvas.lock();
			_canvas.fillRect( _canvas.rect, 0x00000000 );
			_canvas.draw( sp );
			_canvas.unlock();
			
			
			_canvas_p.lock();
			_canvas_p.fillRect( _canvas.rect, 0x00000000 );			
			//	交点描画
			for ( i = 0; i < crossPt.length; i++ )
			{
				Spark( crossPt[i].x, crossPt[i].y, _canvas_p );
			}		
			_canvas_p.applyFilter( _canvas_p, _canvas_p.rect, new Point(), new GlowFilter(0xFFFF00, 0.8, 10, 10, 2) );
			_canvas_p.unlock();
			
			
			_canvas_back.lock();
			_canvas_back.draw( _canvas_p, null, new ColorTransform( 0.1, 0.1, 0.1, 0.5, 0, 0, 20, 0 ), BlendMode.ADD );
			_canvas_back.applyFilter( _canvas_back, _canvas_back.rect, new Point(), new BlurFilter(2,2,1) );
			_canvas_back.unlock();
			
			_step++;
		}
		
		private	function	HitCheckCircle( A:Circle, B:Circle, buf:Array ) : void
		{
			var dv:Point = new Point( B._x - A._x, B._y - A._y );	//	中心点同士のベクトル
			var dvLen:Number = dv.length;
			
			if ( A._x == B._x && A._y == B._y && A._r == B._r ) return;
			
			
			//	1点HIT
			if( dvLen == A._r + B._r )
			{
				dv.normalize( A._r );
				dv.offset( A._x, A._y );
				buf.push( dv );
			}else
			//	2点HIT
			if ( dvLen < A._r + B._r && dvLen > Math.abs( A._r - B._r ) )
			{
				var t:Number = ( A._r * A._r - B._r * B._r + dvLen * dvLen ) * 0.5 / dvLen;
				//	接点Aと中心点ベクトルの角度
				var a:Number = Math.acos( t / A._r );
				//	中心点ベクトル自体の角度
				var dva:Number = Math.atan2( dv.y, dv.x );
				
				//	交点
				buf.push( new Point( A._x + A._r * Math.cos( dva + a ), A._y + A._r * Math.sin( dva + a ) ) );
				buf.push( new Point( A._x + A._r * Math.cos( dva - a ), A._y + A._r * Math.sin( dva - a ) ) );		
			}
				
		}		
		
		private	function	Spark( x:Number, y:Number, canvas:BitmapData ) : void
		{
			var color:Array = [
				0xFFFFAAAA,
				0xFFAAFFAA,
				0xFFAAAAFF,
			];
			var count:int = Math.random() * 10 + 1;
			
			for ( var i:int = 0; i < count; i++ )
			{
				canvas.setPixel32( x + Math.random() * 10 - 5, y + Math.random() * 10 - 5, color[i%3] );
			}
		}
	}
	
}

class Circle {
	
	public var _x:Number;
	public var _y:Number;
	
	public var _r:Number;
	public var _alpha:Number;
	
	public var _power:Number;
	
	public	function	Circle() {	}
	
	public	function	Init( x:Number, y:Number ) : void
	{
		_x = x;
		_y = y;
		_alpha = 1;
		_r = 0;
		
		_power = Math.random() * 5 + 1;
	}
	
	public	function	Update() : void
	{
		_r += _power;
		_alpha -= 0.02;
	}
}

