/**
 * Copyright yukifuruyoru ( http://wonderfl.net/user/yukifuruyoru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kK2U
 */

/*dotgenom ver.0.2 by yukifuruyoru*/
/*
Start your drawing from "NEW DNA DRAWING".
    -Input width and heiht, then click the red button.
Add new colors to the palette using "32 bit color" button.
    -Input index number and 32 bit ARGB code, then click the gray button.
    -Select as index value maximum plus one to add new color.
    -Select exixting index number to modificate the color.
Export your drawing as a String-type data."COPY STRING TO CLIPBOARD"
    -Just click the hidden green button. Your code will be copied to your clipboard.
    -Use ctrl+V in any text editor to check your string code.
    -I named this string "Dna string code".
    -You can also inport your DOT drawing to your AS3 using this string.
    
    (For further information, read the comment at "TALK".)
    
Load a drawing from a Dna string code."LOAD DNA STRING CODE"
    -Use ctrl+V and input your code in the TextField. Then click the blue button.
You have other functions like:
    -Pan
    -Centerning
    -Zoom in, Zoom out, show original size
*/

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            inittrace(stage);//For debug
            var editor:Deditor=new Deditor(this);
            
              }//constructor
    }// Flash test
}
import flash.geom.Matrix;///pack
//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
import flash.events.MouseEvent;
import flash.system.System;
class Deditor extends Sprite{        
private var sample1:Dna=new Dna([[25,25],[0x0,0xff000000,0xffff0000,0xff00ff00,0xff0000ff],[[1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,1],[1,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,1],[1,0,3,3,3,0,1,0,0,1,0,1,0,1,1,0,0,0,1,0,2,2,2,0,1],[1,0,3,3,3,0,1,0,0,0,1,1,0,1,0,1,1,0,1,0,2,2,2,0,1],[1,0,3,3,3,0,1,0,0,0,1,1,1,0,0,0,1,0,1,0,2,2,2,0,1],[1,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,1,0,1,0,0,0,0,0,1],[1,1,1,1,1,1,1,0,1,0,0,0,1,0,1,0,1,0,1,1,1,1,1,1,1],[0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1],[1,1,0,1,1,0,1,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1],[0,1,1,1,0,1,0,1,1,0,1,0,0,1,1,1,1,0,0,1,1,1,1,1],[0,0,0,0,0,0,1,0,1,1,0,0,1,1,0,1,0,0,0,1,0,1,0,0,1],[0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,1,1,1],[1,0,0,0,1,1,1,0,1,1,1,0,0,1,1,0,1,0,1,1,0,0,0,0,1],[0,1,1,0,1,0,0,0,1,1,1,0,1,0,1,1,1,0,0,0,1,0,0,1],[0,0,1,0,1,0,1,1,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1],[0,1,1,1,1,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,0,1,0,1],[0,1,1,1,1,1,1,1,0,0,0,1,1,0,0,1,1,1,1,1,1,0,1,1],[0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,0,1],[1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,0,1,0,1,1,0,0,1],[1,0,0,0,0,0,1,0,0,1,0,1,0,1,0,1,1,0,0,0,1,0,0,0,1],[1,0,4,4,4,0,1,0,1,1,0,1,0,1,0,1,1,1,1,1,1,1,0,1,1],[1,0,4,4,4,0,1,0,1,0,0,0,1,1,0,0,0,1,1,1,0,1,0,1,1],[1,0,4,4,4,0,1,0,0,1,1,1,0,1,0,1,0,1,0,1,1,0,1,1,1],[1,0,0,0,0,0,1,0,1,1,0,1,1,1,0,1,0,0,1,1,1,0,1,1,1],[1,1,1,1,1,1,1,0,1,1,1,1,1,1,0,0,1,0,1,0,0,1,0,0,1]]]);
private var sW:uint;
private var sH:uint;
private var bmp:BitmapData=sample1.bmp;
private var plate:Sprite=new Sprite;
private var magni:Sprite=new Sprite;
private var pbox:Sprite=new Sprite;
private var prism:Sprite=new Sprite;
private var cur:Sprite=new Sprite;
private var amp:uint=1;
private var dcom:Dcommand=new Dcommand;
private var cindex:uint=0;
private var dcolor:uint=0;
private static var PAINT:uint=1;
private static var PAN:uint=2;
private var mmode:uint=PAINT;

    public function Deditor(tgt:Sprite){
        tgt.addChild(this);
        
        dcom.load(sample1);

        sW=stage.stageWidth;
        sH=stage.stageHeight;
        initPlate();
        initMagni();
        initDeco();
        initReader();
        initWhite();
        initExporter();
        initMagnifier();
        initPrism();
        initMana();
        k=5;
        //trace("ready"); for debug
    }
    private function initPrism():void{
        //prism is the palette at left.
        prism.x=16;
        prism.y=130;
        addChild(prism);
        prism.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{
            
            var d:int=prism.mouseX/25;
            var u:int=prism.mouseY/25;
            if(u<dcom.palette.length){
                c=u;
            }
            mmode=PAINT;
        });
        cur.graphics.lineStyle(0);
        cur.graphics.drawRect(-2,-2,24,24);
        cur.x=prism.x;
        cur.y=prism.y;
        addChild(cur);
        rePrism();
    };
    private function rePrism():void{
        //to reload palette information.
        prism.graphics.clear();
        prism.graphics.lineStyle(0,0xcccccc);
        dcom.palette.forEach(function(color:uint,index:uint,...args):void{
            var sq:BitmapData=new BitmapData(1,1,true,color);
            prism.graphics.beginBitmapFill(sq);
            prism.graphics.drawRect(0,index*25,20,20);
        })
        if(cindex>dcom.palette.length-1){c=dcom.palette.length-1;}
        dcolor=dcom.palette[cindex];
    }
    private function initMagnifier():void{
        //magnifier
        var magnifier:Sprite=new Sprite;
        with(magnifier){
            x=16;y=16;
            graphics.beginBitmapFill((new Dna([[20,60],[0xFFcccccc,0xFF000000],[[0],[0],[0],[0],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,1,1,1,1,1,1],[0,0,0,0,0,0,0,1,1,1,1,1,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,0,0,1,1],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0,0,0,0,0,0,1,1,1,1,0],[0,0,0,0,0,1,0,0,0,0,1],[0,0,0,0,0,1,0,0,0,0,1],[0,0,0,0,0,1,0,0,0,0,1],[0,0,0,0,0,1,0,0,0,0,1],[0,0,0,0,0,0,1,1,1,1,1],[0,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0,0,0,0,0,0,0,1,1,1,1,1,1],[0,0,0,0,0,0,0,1,1,1,1,1,1],[0],[0],[0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0]]])).bmp);
            graphics.drawRoundRect(0,0,20,60,10);
            graphics.endFill();
        }
        addChild(magnifier);
        magnifier.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{
            var h:int=magnifier.mouseY;
            if(h<25){k=magni.scaleY+1;}
            else{
                if(h<35){magni.scaleX=1;magni.scaleY=1;}
                else{if(magni.scaleY>1){k=magni.scaleY-1;}
            }}
        });
        //peter for panmode
        var peter:Sprite=new Sprite;
        with(peter){
            x=magnifier.x+46;
            y=magnifier.y;
            graphics.beginFill(0xcccccc);
            graphics.drawRoundRect(0,0,20,20,10);
            graphics.beginBitmapFill(new Dna([[20,20],[0x0,0xff000000],[[0],[0],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,0,1,1,1,1],[0,0,0,0,0,0,0,1,1,1,1,1,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1],[0,0,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1],[0,0,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1],[0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,1,1,1,1,1,1],[0,0,0,0,0,0,0,0,1,1,1,1],[0,0,0,0,0,0,0,0,0,1,1]]]).bmp);
            graphics.drawRect(0,0,20,20);
            graphics.endFill();
        }
        addChild(peter);
        peter.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{
            cur.x=peter.x;cur.y=peter.y;
            mmode=PAN;         
        });
        //wendy activates the func center
        var wendy:Sprite=new Sprite;
        with(wendy){
            x=peter.x+46;
            y=peter.y;
            graphics.beginFill(0xcccccc);
            graphics.drawRoundRect(0,0,20,20,10);
            
            graphics.beginBitmapFill(new Dna([[20,20],[0x0,0xff000000],[[0],[0],[0],[0],[0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,0,0,0,0,0,1,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1],[0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1]]]).bmp);
            graphics.drawRect(0,0,20,20);
            graphics.endFill();
        }
        addChild(wendy);
        wendy.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{
            center();       
        });
        
    }
    private function initMana():void{
        //mana for control colors in palette
        //(uses modink of dcommand)
        var mana:Sprite=new Sprite;
        var mmi:Sprite=new Sprite;
        var tindex:TextField=texmex();
        var tbits:TextField=texmex();
        var go:Sprite=new Sprite;
        var ready:Boolean=false;
        with(go){
            x=170;
            graphics.beginFill(0xcccccc);
            graphics.drawRoundRect(0,0,20,20,10);
            visible=false;
        }
        with (mana){
            x=16;
            y=96;
            graphics.beginFill(0xcccccc);
            graphics.drawRoundRect(0,0,20,20,10);
            graphics.beginBitmapFill(new Dna([[20,20],[0x0,0xff000000],[[0],[0],[0],[0,0,0,0,0,0,0,0,0,0,0],[0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0],[0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0],[0,0,0,1,1,0,1,1,1,0,1,1,0,0,0,0,1,1],[0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,1],[0,0,1,1,1,0,1,1,1,0,1,1,0,0,1,0,1,1],[0],[0],[0],[0,0,1,1,0,1,1,1,0,1,0,0,1,1,1,0,1,1],[0,0,1,0,0,1,0,1,0,1,0,0,1,0,1,0,1],[0,0,1,1,0,1,1,1,0,1,1,0,1,1,1,0,1]]]).bmp);
            graphics.drawRect(0,0,20,20);
            graphics.endFill();
        }
        tindex.restrict="0-9";
        tindex.width=60;
        tindex.maxChars=3;
        tindex.visible=false;
        
        tbits.restrict="0-9,a-f,A-F,x,X";
        tbits.width=100;
        tbits.maxChars=10;
        tbits.x=65;
        tbits.visible=false;
        
        mmi.addChild(tindex);
        mmi.addChild(tbits);
        mmi.addChild(go);
        
        mmi.x=mana.x+25;
        mmi.y=mana.y;
        addChild(mmi);
        addChild(mana);
        mana.addEventListener(MouseEvent.MOUSE_DOWN,function (...args):void{blink();});
        go.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{onGo();});
        function texmex():TextField{
            var format:TextFormat=new TextFormat();
            format.align="right";
            var tf:TextField=new TextField;
            tf.defaultTextFormat=format;
            tf.background=true;
            tf.border=true;
            tf.borderColor=0xcccccc;
            tf.wordWrap=true;
            tf.height=19;
            tf.type="input";
            tf.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{tf.text="";});
            return tf
        };
        function blink():void{
            if(ready){
                tindex.visible=false;
                tbits.visible=false;
                go.visible=false;
                ready=false;
            }
            else{
                tindex.visible=true;
                tindex.text="index #";
                tbits.visible=true;
                tbits.text="32-bit ARGB code";
                go.visible=true;
                ready=true;
            }
        }
        function onGo(...args):void{
            var a:Boolean=indexCK();
            var b:Boolean=bitsCK();
            
            if(a&&b){
                dcom.modink(uint(tindex.text),uint(tbits.text));
                rePrism();
                refresh();
                blink();
            }
            else {
                if(!a){tindex.text="[ 0 , "+String(dcom.palette.length)+" ]";}
                if(!b){tbits.text="0x00000000"}
            }
        };
        function indexCK():Boolean{
            var sol:Boolean=true;
            if(sol && (uint(tindex.text)==0) && (tindex.text!="0")) sol=false;
            if(sol && uint(tindex.text)>dcom.palette.length) sol=false;
            return sol
        }
        function bitsCK():Boolean{
            var sol:Boolean=true;
            if(sol && (uint(tbits.text)==0) && (tbits.text!="0x00000000")) sol=false;
            return sol
        }
    }
    
    private function initExporter():void{
        //with exporter you can generate the dna string code and copy to your clipboard.
        //you can also use this code as array to construct Dna class.
        var exporter:Sprite=new Sprite;
        var ready:Boolean=false;
        var button:Sprite=new Sprite;
        var im:BitmapData=new Dna([[66,14],[0x0,0xff000000],[[0],[0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,0,1,0,1,0,0,0,1,0,1,1,1,1,1],[0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,1,0,0,1,0,1],[0,0,0,0,1,0,0,0,0,0,1,0,1,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,1,0,1,0,1,0,1,0,1,0,1,0,1,1,1],[0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,0,0,1,1,0,1,0,0,0,1],[0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0],[0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1],[0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1],[0,0,0,1,0,0,0,1,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,1,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1],[0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0,1],[0,0,0,1,0,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,1,1,1]]]).bmp;
        function blink():void{
            if(ready){removeChild(button);ready=false;}
            else{addChild(button);ready=true;}
        }
        with(exporter){
            x=16;
            y=sH-36;
            graphics.beginFill(0xcccccc);
            graphics.drawRoundRect(0,0,80,20,10);
            graphics.beginBitmapFill(im,new Matrix(1,0,0,1,6,3));
            graphics.drawRect(6,3,66,14);
            graphics.endFill();
        }
        addChild(exporter);
        exporter.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{blink();});
        
        with(button){
            x=exporter.x+85;
            y=exporter.y;
            graphics.beginFill(0x66ff99);
            graphics.drawRoundRect(0,0,20,20,10);
            graphics.endFill();
        }
        button.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{blink();System.setClipboard(dcom.codestr);});
        
    }
    private function initWhite():void{
        //white for creating new drawing
        var white:Sprite=new Sprite;
        var wtf:TextField=texmex();
        var htf:TextField=texmex();
        var button:Sprite=new Sprite;
        var ready:Boolean=false;
        function blink():void{
            if(ready){removeChild(button);removeChild(wtf);removeChild(htf);ready=false;}
            else{addChild(button);wtf.text="width";htf.text="height";addChild(wtf);addChild(htf);ready=true;}
        }
        
        with(white){
            x=sW-76;
            y=sH-60;
            graphics.beginFill(0xcccccc);
            graphics.drawRoundRect(0,0,60,20,10);
            graphics.beginBitmapFill(new Dna([[60,20],[0x0,0xff000000],[[0],[0],[0],[0],[0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,0,0,0,1,0,0,0,1,1,1,1,0,0,1,0,0,0,1,0,0,1,1,1],[0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,1,0,0,1,0,1,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,1,1,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,1,1,1,1],[0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,0,1,1,0,1,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,1,1,1,1,0,0,1,0,0,0,1,0,1,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0],[0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,1,1,1,0,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1],[0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,1,1,0,0,1,0,1],[0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,1],[0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,0,1,1,0,1,0,0,0,1],[0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,1,1,1,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1]]]).bmp);
            graphics.drawRect(0,0,60,20);
            graphics.endFill();
        }
        white.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{blink();});
        htf.y=white.y;
        wtf.y=white.y;
        htf.x=white.x-55;
        wtf.x=htf.x-52;
        wtf.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{wtf.text="";});
        htf.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{htf.text="";});
        
        addChild(white);
        
        with(button){
            x=wtf.x-22;
            y=white.y;
            graphics.beginFill(0xff6699);
            graphics.drawRoundRect(0,0,20,20,10);
            graphics.endFill();
        }
        button.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{
            var w:uint=uint(wtf.text);
            var h:uint=uint(htf.text);
            var vw:Boolean=sizecheck(w);
            var vh:Boolean=sizecheck(h);
            if(vw&&vh){blink();summonDna([[w,h],[0x000000,0xFF000000],[[0]]]);}
            else{
                wtf.text=(vw)?String(w):"[1,2880]";
                htf.text=(vh)?String(h):"[1,2880]";
            }
            
            if(vw&&vh){k=1;}
        });
    
        function sizecheck(n:uint):Boolean{
            return (0<n&&n<2881);
        }
        function texmex():TextField{
            var format:TextFormat=new TextFormat();
            var dum:TextField=new TextField;
            format.align="right";
            with(dum){
                defaultTextFormat=format;
                width=50;
                height=19;
                background=true;
                border=true;
                borderColor=0xcccccc;
                type="input";
                restrict="0-9";
                maxChars=4;
                wordWrap=true;}
            return dum;
        }
    }
    private function summonDna(code:Array):void{
            dcom.load(new Dna(code));
            refresh();
            center();
            rePrism();
            c=0;
    }
    private function initReader():void{
        var reader:Sprite=new Sprite;
        var tf:TextField=new TextField;
        var button:Sprite=new Sprite;
        var ready:Boolean=false;
        function blink():void{
            if(ready){removeChild(button);removeChild(tf);ready=false;}
            else{tf.text="< INPUT CODE STRING >";addChild(button);addChild(tf);ready=true;}
        }
        with(reader){
            x=sW-76;
            y=sH-36;
            graphics.beginFill(0xcccccc);
            graphics.drawRoundRect(0,0,60,20,10);
            graphics.beginBitmapFill(new Dna([[60,20],[0x0,0xff000000],[[0],[0],[0],[0],[0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,1,0,0,1,1,1],[0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,1,0,0,1,0,1,0,0,0,1],[0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,1,0,1,1,1,1,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,1,1,1,1],[0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,0,1,1,0,1,0,0,0,1],[0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,1,0,1,0,0,0,1],[0],[0],[0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,0,1,0,1,0,0,0,1,0,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1],[0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1],[0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,1,0,1,0,1,0,1,0,1,0,1,0,1,1,1,0,0,1,0,0,0,0,0,1,0,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1],[0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,0,0,1,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1],[0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1]]]).bmp);
            graphics.drawRect(0,0,60,20);
            graphics.endFill();
        }
        addChild(reader);
        reader.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{blink();});
        with(tf){
            y=reader.y;
            x=reader.x-205;
            width=200;
            height=19;
            background=true;
            border=true;
            borderColor=0xcccccc;
            type="input";
            wordWrap=true;
        }
        tf.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{tf.text="";});
        
        with(button){
            x=tf.x-22;
            y=reader.y;
            graphics.beginFill(0x6699ff);
            graphics.drawRoundRect(0,0,20,20,10);
            graphics.endFill();
        }
        
        button.addEventListener(MouseEvent.MOUSE_DOWN,function(...args):void{
            
            var long:uint=tf.text.length;
            var codex:Array=stray(tf.text);
            var valid:Boolean=codecheck(codex);
            blink();blink();
            if(valid){
                tf.text=("< * LOADING ... * >");
            }
            if(valid){
                summonDna(codex);
            }
            if(valid){tf.text=(codex[0][0]+" x "+codex[0][1]+", "+codex[    1].length)+"colors, length:"+long;}
            else{tf.text=("! INVALID CODE !");}
            
        });
        function codecheck(code:Array):Boolean{
            var valid:Boolean=true;
            if(code.length!=3){valid=false;}
            if(valid&&code[0].length!=2){valid=false;}
            if(valid){
                var a:uint=code[0][0];
                var b:uint=code[0][1];
                if(a<1||2880<a||b<1||2880<b){valid=false;}
            }
            return valid
        }
    }
    private function center():void{
        plate.x=-Math.ceil(bmp.width/2);
        plate.y=-Math.ceil(bmp.height/2);
    }
    private function set c(n:uint):void{
        if(n<dcom.palette.length){
            cindex=n;
            dcolor=dcom.palette[n];
        }
        cur.x=prism.x;cur.y=prism.y+n*25;
    }
    private function set k(n:uint):void{
        amp=n;
        magni.scaleX=n;magni.scaleY=n;
    }
    private function initMagni():void{
        magni.x=Math.round(sW/2);
        magni.y=Math.round(sW/2);
        addChild(magni);
    }
    private function refresh():void{
        bmp=dcom.bmp;
        with(plate.graphics){
            clear();
            beginBitmapFill(bmp,null,false);
            drawRect(0,0,bmp.width,bmp.height);
            beginFill(0xcccccc);
            drawRect(-2,-2,bmp.width+4,bmp.height+4);
            drawRect(-1,-1,bmp.width+2,bmp.height+2);
            beginFill(0xeeeeee);
            drawRect(-1,-1,bmp.width+2,bmp.height+2);
            drawRect(0,0,bmp.width,bmp.height);
            
        }
    }
    private function initPlate():void{
        magni.addChild(plate);
        refresh();
        center();
        plate.addEventListener(MouseEvent.MOUSE_DOWN,onPlatePress);
    }
    private function winject(x:int,y:int):void{
        if(amp==1){x--;}
        if(-1<x && x<bmp.width && -1<y && y<bmp.height){
            dcom.inject(x,y,cindex);
            bmp.setPixel32(x,y,dcolor);
        }
    }
    private function onPlatePress(e:MouseEvent):void{
        switch(mmode){
            case PAINT:{
                winject(e.localX,e.localY);
                plate.addEventListener(MouseEvent.MOUSE_MOVE,onPaintMove);
                stage.addEventListener(MouseEvent.MOUSE_UP,onPaintUp);
            }break;
            case PAN:{
                plate.startDrag();      
                stage.addEventListener(MouseEvent.MOUSE_UP,onPanUp);
    
            }break;
        }

    }
    private function onPanUp(e:MouseEvent):void{
       plate.stopDrag();
       stage.removeEventListener(MouseEvent.MOUSE_UP,onPanUp);
    }
    private function onPaintMove(e:MouseEvent):void{
        winject(plate.mouseX,plate.mouseY);
    }
    private function onPaintUp(e:MouseEvent):void{
            plate.removeEventListener(MouseEvent.MOUSE_MOVE,onPaintMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP,onPaintUp);
    }
    private function initDeco():void{
        graphics.beginFill(0xcccccc);
        graphics.drawRect(0,0,sW,sH);
        graphics.drawRect(10,10,sW-20,sH-20);
    }
}
//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
//xxxxxxxxxxxxxxxxxxxxxxxxxxxxx
class Dcommand{
    private var dna:Dna;
    public function load(d:Dna):void{dna=d;}
    public function get palette():Vector.<uint>{return dna.palette}
    public function get codestr():String{
        var s:String="["+String(dna.size)+"]";
        var p:String="";
        {    dna.palette.forEach(function(color:uint,...args):void{
                p+=",0x"+color.toString(16);});
            p="["+p.slice(1)+"]";
        }
        var m:String="";
        {    dna.map.forEach(function(row:Vector.<uint>,...args):void{
                m+=",["+String(row)+"]"});
            m="["+m.slice(1)+"]";
        }
        return "["+s+","+p+","+m+"]"
    }
    
    public function get bmp():BitmapData{
        return dna.bmp
    }
    
    public function inject(x:uint,y:uint,index:uint):void{
        if(dna.map.length<y+1){
            var gap:uint=y+1-dna.map.length;
            for(var i:uint=0;i<gap;i++){dna.map.push(new Vector.<uint>(1))};
        }
        if(dna.map[y].length<x+1){dna.map[y].length=x+1;}
        dna.map[y][x]=index;
    }
    public function modink(index:uint,color:uint):void{
        if(index>=dna.palette.length){dna.palette.length++;}
        dna.palette[index]=color;
    }

}//Dcommand
//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
import flash.display.BitmapData;
class Dna{
    public var size:Vector.<uint>=Vector.<uint>([1,1]);
    public var palette:Vector.<uint>=Vector.<uint>([0,0xFFffffff]);
    public var map:Vector.<Vector.<uint>>=Vector.<Vector.<uint>>([new Vector.<uint>(1)]);
    public function Dna(code:Array){
        size=Vector.<uint>(code[0]);
        palette=Vector.<uint>(code[1]);
        code[2].forEach(
            function(row:Array,h:uint,...args):void{
                map[h]=Vector.<uint>(row);});
    }
    public function get bmp():BitmapData{
        var sheep:BitmapData=new BitmapData(size[0],size[1],true,palette[0]);
        var L:uint=palette.length;
        map.forEach(function(row:Vector.<uint>,h:uint,...args):void{
            row.forEach(function(c:uint,w:uint,...args):void{if(c&&(c<L)){sheep.setPixel32(w,h,palette[c]);}});
        });
        return sheep
    }
}//Deditor

//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
function stray(str:String):Array{
    //stray by yukifuruyoru
    //func. stray converts a String into an Array.
    str=str.slice(1,str.length-1);
    var sol:Array=[];
    var nex:uint=0;
    var c:String;
    reactor();//modificates sol array.
    sol.forEach(function (elem:*,index:uint,...args):void{
        c=elem.charAt(0)+elem.charAt(elem.length-1);
        if(c=="[]"){sol[index]=stray(elem);}
    });
    return sol;
//stray internal functions
    function reactor():void{
        nex=str.search(new RegExp(",|\"|\\["));
        //trace(str.charAt(nex),"at index",nex);
        switch(str.charAt(nex)){
            case ",":{commaf();reactor();}break;
            case "\"":{wordf();reactor();}break;
            case "[":{openf();reactor();}break;
            default:{if(str){sol.push(str);}}break;
        }
    }
    function commaf():void{
        var end:uint=str.search(new RegExp("(,\\[)|(,\")|$"));
        var element:String=str.slice(0,end);
        sol=sol.concat(element.split(","));
        str=str.slice(end+1);
        //trace("elements",element);
        //trace(str);
    }
    function wordf():void{
        var end:uint=str.search(new RegExp(".\""))+1;
        var element:String=str.slice(1,end);
        sol.push(element);
        str=str.slice(end+2);
        
        //trace("word",element);
        //trace(str);
    }
    function openf():void{
        var end:uint=elemend(str);
        var elementstr:String=str.slice(0,end+1);
        //var element:Array=stray(element);
        sol.push(elementstr);
        str=str.slice(end+2);
        
        
        function elemend(s:String):uint{
            var op:uint;//number of [
            var ed:uint;//number of ]
            var co:uint;//number if "
            var index:int=0;
            var sample:String;
            do{
                index=s.indexOf("]",index+1);
                if(index<0){break}
                sample=s.slice(0,index+1);
                co=sample.match(new RegExp("\"","g")).length;
                if(co&0x1){continue}
                else{sample=sample.replace(new RegExp("\".+?\"","g"),"@");}
                op=sample.match(new RegExp("\\[","g")).length;
                ed=sample.match(new RegExp("\\]","g")).length;
                //trace(sample,op,ed);
            }while(op!=ed)
            //trace("done",sample);
            return index
        }
    }//openf()
//stray internal functions 
}//function stray() END...
//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}



