/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kIrA
 */

package {
    /*
    title   : [blenderの練習]
    @author : 　itoz 
    
    ドラッグでrotationYが変わるよ
    colladaの読み込みイベント
    colladaテクスチャの読み込みイベントを取得しているけど特に何をしているわけでもないよ
    
    右腰のあたりに変なメッシュが残ってしまった
    次回はこれにアニメーションつけてみる
    
    */
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.objects.parsers.Collada;
    import caurina.transitions.Tweener;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.Stage;
    public class AmazonSan extends Sprite {
            private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _viewport:Viewport3D;
        private var _render:BasicRenderEngine;
        private var _collada:Collada;
        private var _wrap:DisplayObject3D;
        private var mouseDownX:Number;
        private var mouseDownY:Number;;
        private var isDragging:Boolean = false;
        public function AmazonSan() {
            setCamera();
            _render = new BasicRenderEngine();
            _scene = new Scene3D();
            _viewport = new Viewport3D(0,0,true,true);
            addChild(_viewport);
            _wrap = new DisplayObject3D();
            _wrap.y=-550;
            _scene.addChild(_wrap);
            init()
        }
        private function init():void {
            addEventListener(Event.ENTER_FRAME,render);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUpHandler);
            addCollada();
        }
        private function onMouseMoveHandler(e:MouseEvent):void {
            var xx:Number = (mouseX - mouseDownX);
            if (isDragging) {
                _wrap.rotationY -=xx;
                mouseDownX = mouseX;
                mouseDownY = mouseY;
            }
        }
        private function onMouseDownHandler(e:MouseEvent) :void {
            isDragging =true;
            mouseDownX = mouseX;
            mouseDownY = mouseY;

        }
        private function onMouseUpHandler(e:MouseEvent) :void {
            isDragging =false;
        }
        private function setCamera() :void {
            _camera = new Camera3D();
            _camera.x=550;
            _camera.y=0;
            _camera.z = -1500;
            _camera.target = DisplayObject3D.ZERO;
        }
        private function addCollada() :void {
            _collada = new Collada();
            //COLLADA読み込みイベント
            _collada.addEventListener( FileLoadEvent.LOAD_COMPLETE, onColladaLoadComplete );
            _collada.addEventListener( FileLoadEvent.LOAD_PROGRESS, onColladaLoadProgress);
            _collada.addEventListener( FileLoadEvent.LOAD_ERROR, onColladaLoadError );
            //テクスチャ読み込みイベント
            _collada.addEventListener( FileLoadEvent.COLLADA_MATERIALS_DONE,onTextureLoadComplete);
            //読み込み開始
            _collada.load("http://www.romatica.com/work/amazon-san/AmazonCollada.dae");
            //-----------------------------------------------------------------------------------------
            _wrap.addChild(_collada);
        }
        //------------------------------------------------------------------------------------------
        //COLLADAテクスチャ読み込みイベント完了
        private function onTextureLoadComplete(e):void  {
            //trace("★"+e);
        }
        //------------------------------------------------------------------------------------------
        //COLLADA読み込みイベント
        private function onColladaLoadProgress(e:Event) :void {
            //trace("onColladaLoadProgress >" + e.bytesLoaded +"/"+e.bytesTotal);
        }
        private function onColladaLoadComplete(e:FileLoadEvent) :void {
            //trace("onColladaLoadComplete >" + e);
        }
        private function onColladaLoadError(e:FileLoadEvent) :void {
            //trace("onColladaLoadError >" + e);
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////
        //
        //　レンダリング
        //
        private function render(e:Event) :void {
            if (!isDragging) {
                motionDO3D();
            }
            _camera.y= (mouseY/stage.stageHeight)*3000-1500
            _render.renderScene(_scene,_camera,_viewport);
        }
        private function motionDO3D():void {
            _wrap.rotationY -=1;
        }
    }
}