/**
 * Copyright no48 ( http://wonderfl.net/user/no48 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kIa8
 */

// forked from Pelisalinet's Plane - Alternativa3D
package
{
    import away3d.cameras.HoverCamera3D;
    import away3d.containers.View3D;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.*;
    import away3d.loaders.*;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(width="1200", height="700", frameRate="30", backgroundColor="#000000")]
    public class Triaxe extends Sprite
    {
        private var View:View3D;
        
        // HoverCam controls
        private var camera:HoverCamera3D;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var move:Boolean = false;
        
        public function Triaxe()
        {
            // prep for handling resizing events
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.align = StageAlign.TOP;
            
            // create a 3D-viewport
            camera = new HoverCamera3D({zoom:2, focus:100, distance:250});
            View = new View3D({camera:camera,x:600, y:350});
            
            // add viewport to the stage
            addChild(View);
            camera.panAngle = 45;
            camera.tiltAngle = 20;
            camera.minTiltAngle = -90;
            camera.hover(true);
            
            // Add some reference objects
            var mat:ColorMaterial = new ColorMaterial(0xffff00);
            
            
            mat = new ColorMaterial(0x00ffff);
            var plane:Plane = new Plane({heigth:100, widht:1000, material:mat});
            View.scene.addChild(plane);
            
            // Show the axis
            /*var axis:Trident = new Trident(180);
            View.scene.addChild(axis);*/
            
            // grab the BitmapData from the embedded images
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, MouseDown);
            this.stage.addEventListener(MouseEvent.MOUSE_UP, MouseUp);
        }
        
        private function MouseDown(event:MouseEvent):void
        {
            lastPanAngle = camera.panAngle;
            lastTiltAngle = camera.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            move = true;
        }
        
        private function MouseUp(event:MouseEvent):void
        {
            move = false;
        }
        
        private function onEnterFrame(e:Event):void
        {
            // re-render viewport
            var cameraSpeed:Number = 0.3; // Approximately same speed as mouse movement.
            if (move) {
                camera.panAngle = cameraSpeed*(stage.mouseX - lastMouseX) + lastPanAngle;
                camera.tiltAngle = cameraSpeed*(stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            camera.hover();
            View.render();
        }
    }
}