/**
 * Copyright jloa ( http://wonderfl.net/user/jloa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kHyA
 */

package {
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite
    {
        private var pool:Vector.<EllipseInfo> = new Vector.<EllipseInfo>();
        private var lastPos:Point = new Point();
        private var h:Bitmap;
        
        public function FlashTest()
        {
            h = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight));
            addChild(h);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mMove);
        }
        
        private function draw(x:int, y:int, dx:int, dy:int):void
        {
            dx = 100 - 20*(dx/3); dy = 100 - 20*(dy/3);
            var info:EllipseInfo = new EllipseInfo(x, y, dx, dy, int(Math.random()*0xffffff));
            var s:Shape = new Shape();
            var g:Graphics = s.graphics;
            g.lineStyle(1, info.color);    
            g.drawEllipse(info.x - info.dx/2, info.y - info.dy/2, info.dx, info.dy);
            g.endFill();
            var b:BitmapData = h.bitmapData.clone();
            b.draw(s);
            h.bitmapData = b;
            s = null;
        }
 
        private function mMove(event:MouseEvent):void
        {
            if(!lastPos) { lastPos = new Point(mouseX, mouseY); return; }
            var dx:int = mouseX - lastPos.x;
            var dy:int = mouseY - lastPos.y;
            draw(mouseX, mouseY, dx, dy);
            lastPos = new Point(mouseX, mouseY);
            event.updateAfterEvent();
        }
    }
}
internal class EllipseInfo
{
    public var x:int;
    public var y:int;
    public var dx:int;
    public var dy:int;
    public var color:uint;
    
    public function EllipseInfo(x:int, y:int, dx:int, dy:int, color:uint)
    {
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.color = color;
    }
} 