/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kGbU
 */

// forked from Kay's コレを煙にします
package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=465,height=465,backgroundColor=0x000000,frameRate=24)]
	public class Main extends Sprite {
		
		private const SW:Number = stage.stageWidth;
		private const SH:Number = stage.stageHeight;
		private var hNum:uint = 200;
		private var vNum:uint = 200;
		private var noise:Texture;
		
		public function Main():void {
			noise = new Texture(hNum, vNum);
			addEventListener(Event.ENTER_FRAME, xRun);
			
			// BitmapData検証用
			//var bm:Bitmap = new Bitmap(noise);
			//addChild(bm);
			
			// 煙を描画
			// Filterをかけると激重になるため、Lineだけで描画するもAlphaのせいで重い
			for (var i:uint = 0; i < 32; i++) {
				var nX:uint = 0;
				var nY:uint = i;
				var smoke:Smoke = new Smoke(noise, new Point(nX,nY));
				smoke.x = SW/2;
				smoke.y = SH;
				smoke.age = i*1;
				addChild(smoke);
			}
		}
		private function xRun(e:Event):void {
			noise.xDraw(-2,-2);
		}
	}
}

import flash.display.*;
import flash.geom.*;
import flash.events.*;
/*
 * 座標取得用のBitmapを生成
 */
class Texture extends BitmapData {
	public var point:Point = new Point(0,0);
	private var seed:uint = Math.floor(Math.random() * 10);
	private var channels:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN;
	public function Texture (w:uint=200, h:uint=200) {
		super(w, h, true, 0xffffffff);
	}
	public function xDraw(pX:Number, pY:Number):void {
		point.x += pX;
		point.y += pY;
		perlinNoise(50, 50, 4, seed, false, true, channels, false, [point]);
	}
}
/*
 * Bitmapから読み取った座標をもとにLineだけで煙を表現
 */
class Smoke extends Shape {
	public var noise:BitmapData;
	public var bmPoint:Point;
	public var age:uint = 0;
	public function Smoke(bmd:BitmapData, p1:Point):void {
		noise = bmd;
		bmPoint = p1;
		addEventListener(Event.ENTER_FRAME, xDraw);
	}
	private function xDraw(e:Event):void {
		var nX:Number = 0;
		var nY:Number = 0;
		graphics.clear();
		graphics.lineStyle(5, 0xddeeff, 0.02);
		graphics.moveTo(nX,nY);
		// 長さを変えることで立ち上りを表現する
		var limit:uint = age*2+12;
		for (var i:uint = 0; i < limit; i++) {
			var nColor:uint = noise.getPixel(bmPoint.x+i,bmPoint.y+i);
			var colors:Array = toRGB(nColor);
			nX += (colors[0]-128)/16;
			nY += (colors[1]-48)/-8;
			graphics.lineTo(nX,nY);
			if (nY < -465) break;
		}
		age++;
		if (age > 32) age -= 32;
	}
	private function toRGB(nColor:uint):Array {
		var nB:uint = nColor & 0xff;
		var nG:uint = (nColor >> 8) & 0xff;
		var nR:uint = (nColor >> 16) & 0xff;
		return ([nR, nG, nB]);
	}
}