/**
 * Copyright FlashBum ( http://wonderfl.net/user/FlashBum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kF4I
 */

package {

import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.text.TextField;
 
    /**
      * author Jesse Freeman aka @theFlashBum | http://jessefreeman.com
      * 
      * This is a simple demo of how to create a "3d Push Button" similar
      * to the new UI on wp7 phones. Noting fancy here but I do add the
      * notion of force so depending on where you press the button it will
      * rotate farther.
      * 
 	  * Since this is a decorator (see internal class) it can be applied
 	  * to any button (as long as you are compiling for FP 10.0).
      * 
      * It is important to note that the rotation will be "off" based on
      * the center position of the box.
      *
      */
      
public class ButtonTest extends Sprite {

    private var decorator:PushButtonDecorator;
    private var testButton:Sprite;

    public function ButtonTest() {

            configureStage();
            init();
        }

        protected function configureStage():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }

    protected function init():void
    {
        testButton = addChild(createButton()) as Sprite;
        testButton.x = stage.stageWidth * .5 - testButton.width *.5;
        testButton.y = stage.stageHeight * .5 - testButton.height *.5;
        
        testButton.addEventListener(MouseEvent.CLICK, onClick)
        decorator = new PushButtonDecorator(testButton);
        
    }

    private function onClick(event:MouseEvent):void {

        decorator.push(event.localX/testButton.width);
    }

    private function createButton():Sprite {

        var button:Sprite = new Sprite();
        button.graphics.beginFill( Math.random() * 0xFFFFFF);
        button.graphics.drawRect(0,0,100,100);
        button.graphics.endFill();

        button.buttonMode = true;
        button.useHandCursor = true;

        return button;
    }
}
}

	import caurina.transitions.*;

    import flash.display.DisplayObject;

    internal class PushButtonDecorator {

        private var _target:DisplayObject;

        public function PushButtonDecorator(target:DisplayObject = null) {
            if(target)_target = target;
        }

        public function get target():DisplayObject {
            return _target;
        }

        public function set target(value:DisplayObject):void {
            _target = value;
        }
        
        public function push(force:Number = 1):void {

            var rotY:Number = -30 * force;

            Tweener.addTween(_target, {time:.2, rotationY: rotY, overwrite: 0, onComplete:reset});

        }

        public function reset(delay:Number = 0):void
        {
            Tweener.addTween(_target, {time:.2, rotationY: 0, overwrite: 0, delay:delay});    
        }


    }