/**
 * Copyright Hasufel ( http://wonderfl.net/user/Hasufel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kERl
 */

// forked from Fumio's Getting distance with Point.distance() and Math.sqrt() methods
//@Hasufel: added casting and rearranged test code as getTimer() results were made false

package {
    import flash.display.Sprite;
    import flash.utils.getTimer;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.geom.Point;

    [SWF(width="465", height="465")]

    public class GettingDistance extends Sprite {
        private const _amount:uint = 1000000;
        private var _myVector:Vector.<Point> = new Vector.<Point>(_amount);
        private var _myTxt:TextField = new TextField();
        private var _labelTxt:TextField = new TextField();
        private var _myFmt:TextFormat = new TextFormat();

        public function GettingDistance() {
            createTextField();
            createPoints();
            comparisonTest();
        }

        private function comparisonTest():void {
            xTrace2("Flawed results");
            // Starting flawed Test
            test(warmingUp, "Empty loop");
            testCast(warmingUp, "Empty loop + casting");
            test(useMath, "Math.sqrt()");
            testCast(useMath, "Math.sqrt() + casting");
            test(usePoint, "Point.distance()");
            testCast(usePoint, "Point.distance() + casting");
            xTrace2("");
            xTrace2("Correct results");
            //starting correct test
            correctTest();
        }

        private function correctTest():void {
            var nAmount:uint = _myVector.length - 1;
            var i:uint,s:uint,e:uint,beginPoint:Point,endPoint:Point,distance:Number;
            s = getTimer();
            for (i = 0; i < nAmount; i++) {
                beginPoint = _myVector[i];
                endPoint = _myVector[i + 1];
                distance = warmingUp(beginPoint, endPoint);
            }
            e = getTimer();
            xTrace("Empty loop",(e - s));
            s = getTimer();
            for (i = 0; i < nAmount; ++i) {
                beginPoint = _myVector[i>>0];
                endPoint = _myVector[(i+1)>>0];
                distance = warmingUp(beginPoint, endPoint);
            }
            e = getTimer();
            xTrace("Empty loop + casting",(e - s));
            s = getTimer();
            for (i = 0; i < nAmount; i++) {
                beginPoint = _myVector[i];
                endPoint = _myVector[i + 1];
                distance = useMath(beginPoint, endPoint);
            }
            e = getTimer();
            xTrace("Math.sqrt()",(e - s));
            s = getTimer();
            for (i = 0; i < nAmount; ++i) {
                beginPoint = _myVector[i>>0];
                endPoint = _myVector[(i+1)>>0];
                distance = useMath(beginPoint, endPoint);
            }
            e = getTimer();
            xTrace("Math.sqrt() + casting",(e - s));
            s = getTimer();
            for (i = 0; i < nAmount; i++) {
                beginPoint = _myVector[i];
                endPoint = _myVector[i + 1];
                distance = usePoint(beginPoint, endPoint);
            }
            e = getTimer();
            xTrace("Point.distance()",(e - s));
            s = getTimer();
            for (i = 0; i < nAmount; ++i) {
                beginPoint = _myVector[i>>0];
                endPoint = _myVector[(i+1)>>0];
                distance = usePoint(beginPoint, endPoint);
            }
            e = getTimer();
            xTrace("Point.distance() + casting",(e - s));
        }

        private function test(myFunction:Function,l:String):void {
            var nAmount:uint = _myVector.length - 1;
            var started:uint = getTimer();
            for (var i:uint = 0; i < nAmount; i++) {
                var beginPoint:Point = _myVector[i];
                var endPoint:Point = _myVector[i + 1];
                var distance:Number = myFunction(beginPoint, endPoint);
            }
            xTrace(l,(getTimer() - started));
        }

        private function testCast(myFunction:Function,l:String):void {
            var nAmount:uint = _myVector.length - 1;
            var started:uint = getTimer();
            for (var i:uint = 0; i < nAmount; ++i) {
                var beginPoint:Point = _myVector[i>>0];
                var endPoint:Point = _myVector[(i + 1)>>0];
                var distance:Number = myFunction(beginPoint, endPoint);
            }
            xTrace(l,(getTimer() - started));
        }

        private function usePoint(beginPoint:Point, endPoint:Point):Number {
            var distance:Number = Point.distance(beginPoint, endPoint);
            return distance;
        }

        private function useMath(beginPoint:Point, endPoint:Point):Number {
            var nX:Number = endPoint.x - beginPoint.x;
            var nY:Number = endPoint.y - beginPoint.y;
            var distance:Number = Math.sqrt(nX * nX + nY * nY);
            return distance;
        }

        private function warmingUp(beginPoint:Point, endPoint:Point):Number {
            return 0;
        }

        private function createPoints():void {
            for (var i:uint = 0; i < _amount; ++i) {
                var nX:Number = Math.random() * 1000;
                var nY:Number = Math.random() * 1000;
                _myVector[i>>0] = new Point(nX, nY);
            }
        }

        private function createTextField():void {
            _myFmt.align = TextFormatAlign.RIGHT;
            _myTxt.x +=  50;
            _myTxt.defaultTextFormat = _myFmt;
            _myTxt.autoSize = TextFieldAutoSize.RIGHT;
            _labelTxt.autoSize = TextFieldAutoSize.LEFT;
            addChild(_myTxt);
            addChild(_labelTxt);
        }

        private function xTrace(s:String, n:uint):void {
            _myTxt.appendText(String(n) + "\n");
            _labelTxt.appendText(s + ":" + "\n");
        }

        private function xTrace2(s:String):void {
            _myTxt.appendText(s + "\n");
            _labelTxt.appendText("\n");
        }
    }
}