/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kEGl
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.core.proto.CameraObject3D;
    
   // import caurina.transitions.Tweener;
   
   [SWF(backgroundColor="#000000")]
   
    public class FlashTest extends Sprite {
        
        private var camera:Camera3D;
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var angleX:Number = 0;
        private var angleY:Number = 0;
        private var cubeArr:Array = new Array();
        private var plane:Plane;
        
        private var cubeX:Array = [];
        private var cubeY:Array = [];
        private var cubeZ:Array = [];
        
        private var enX:Array = [];
        private var enY:Array = [];
        private var enZ:Array = [];
        
        private var isCube:Boolean = true;
        
        public function FlashTest() {
            init();
        }//FlashTest
        
        private function init():void{
            
            
            camera = new Camera3D();
            camera.z = -500;
            //camera.zoom = 50;
            
            scene = new Scene3D();
            viewport = new Viewport3D(465, 465);
            renderer = new BasicRenderEngine();
           
            addChild(viewport);
            
            for(var i:int = 0; i < 2; i++){
                for(var j:int = 0; j < 2; j++){
                    for(var k:int = 0; k < 2; k++){
                    var mate:ColorMaterial = new ColorMaterial(0xffff00, 1);
                    var materials:MaterialsList = new MaterialsList({all : mate});   
                   
                    var cube:Cube = new Cube(materials, 50, 50, 50); 
                    scene.addChild(cube);
                     
                    cube.x = -50 + i * 50;
                    cubeX.push(cube.x);
                    cube.z = -50 + j * 50;
                    cubeZ.push(cube.z);
                    cube.y =   k * 50;
                    cubeY.push(cube.y);
                    
                    camera.y = 150;
                    camera.rotationX = 15;
                    
                    
                    cubeArr.push(cube);
                    }//for k
                }//for j
            }//for i
            for(var l:int = 0; l < cubeArr.length; l++){
                    /*var ang:int = 5;
                    var radian:Number = (360 / cubeArr.length * l +ang) * Math.PI / 180;
                    enX[l] = Math.cos(radian) * 300;
                    enZ[l] = Math.sin(radian) * 300;
                    enY[l] = 250; */
                    if(l < 3){
                        enX[l] = -50 + l * 50;
                        enY[l] = 100;
                        enZ[l] = 0;
                    } else {
                        enX[l] = 0;
                        enY[l] = -200 + l * 50;
                        enZ[l] = 0;
                    }
            }
            
            var materi:WireframeMaterial = new WireframeMaterial(0xff0000);
            materi.doubleSided = true;
            plane = new Plane(materi, 600, 600);
            scene.addChild(plane);
            
            plane.y = -150;
            plane.rotationX = 90;
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            addEventListener(Event.ENTER_FRAME, onEnter);
        }//init
        
        private function onClick(event:MouseEvent):void{
             if(isCube == true){
            removeEventListener(Event.ENTER_FRAME, onCube);
            addEventListener(Event.ENTER_FRAME, onEn);     

            isCube = false;
            } else if(isCube == false){
            removeEventListener(Event.ENTER_FRAME, onEn);    
            addEventListener(Event.ENTER_FRAME, onCube);
            
            isCube = true;
            }   
            
        }//onClick
        private function onEn(event:Event):void{
           
                for(var i:int = 0; i < cubeArr.length; i++){
                var vx:Number = (enX[i] - cubeArr[i].x) * 0.1;
                cubeArr[i].x += vx;
                var vz:Number = (enZ[i] - cubeArr[i].z) * 0.1;
                cubeArr[i].z += vz;
                var vy:Number = (enY[i] - cubeArr[i].y) * 0.1;
                cubeArr[i].y += vy;
                }//for i
        }//onEn
        
        private function onCube(event:Event):void{
                
                for(var j:int = 0; j < cubeArr.length; j++){
                var vxEn:Number = (cubeX[j] - cubeArr[j].x) * 0.1;
                cubeArr[j].x += vxEn;
                var vzEn:Number = (cubeZ[j] - cubeArr[j].z) * 0.1;
                cubeArr[j].z += vzEn;
                var vyEn:Number = (cubeY[j] - cubeArr[j].y) * 0.1;
                cubeArr[j].y += vyEn;
                }//for i                               
 
        }//onCube


        
        private function onEnter(event:Event):void{
         
           angleX += (232 - mouseX) / 100;              
           camera.z = 500 * (Math.sin(angleX * Math.PI / 180));
           camera.x = 500 * (Math.cos(angleX * Math.PI / 180));
         /*
           angleY += (232 - mouseY) / 100;
           camera.z = 500 * (Math.sin(angleY * Math.PI / 180));
           camera.y = 500 * (Math.cos(angleY * Math.PI / 180));
          */  
//atan2を使ってsceneの原点？とカメラとの角度を出す            
          /*  var z1:Number = (0 - camera.z);
            var y1:Number = (0 - camera.y);
            var radian:Number = Math.atan2(y1, z1);
            camera.rotationX =  -radian * 180 / Math.PI;
          */
            var z2:Number = (0 - camera.z);
            var x2:Number = (0 - camera.x);
            var radian2:Number = Math.atan2(x2, z2);
            camera.rotationY =  radian2 * 180 / Math.PI;
           
           
//           for(var i:int = 0; i < cubeArr.length; i++){
//           Tweener.addTween(cubeArr[i], {y:100, time:5});
//           };
            camera.y =(465 - mouseY) / 4;
            
            //cubeArr[0].rotationZ += 5;
            
            
            
           
             renderer.renderScene(scene, camera, viewport);
        }//onEnter


    }//class
}//package