/**
 * Copyright contest.start ( http://wonderfl.net/user/contest.start )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kDX0
 */

package
{    
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;

    /**
     * 原理是，將圖片轉換成BitMapData,如果是文字欄，
     * 會將背景以及字的每一點換算成pixel,然後再從bitMapData中取出每一點像素的色彩,
     * 建立一個圓形給予他的像素位置，即可。
     * 
     * */
    
    [SWF(width="600", height="300", frameRate="30", backgroundColor="#FFFFFF", pageTitle="")] 
    public class Bitmap_Text_Test extends Sprite
    {
        private var _textPixelMap:BitmapData;
        private var _displayObject:DisplayObject;
        private var _pixelMapTools:PixelMap;
        
        
        //這三個值,會決定顯示狀況
        private var pointGapH:Number = 9;
        private var pointGapV:Number = 9;        
        private var radius:Number = 3.5;
        
        public function Bitmap_Text_Test()
        {
            init();        
            onStart();
        }
        private function init():void
        {
            initVisual();    
            initPixelMap();
        }
        protected function initVisual():void
        {
            _displayObject = new Visual();
            _displayObject.x = this.stage.stageWidth  - _displayObject.width;
            _displayObject.y = this.stage.stageHeight - _displayObject.height;
            this.addChild( _displayObject);
        }
        private function initPixelMap():void
        {
            _pixelMapTools = new PixelMap();
        }
        
        private function onStart():void
        {
            var btn:DisplayObject = Visual(_displayObject).button;
            btn.addEventListener(MouseEvent.MOUSE_DOWN , onDown);
        }
    
        private function onDown(e:MouseEvent):void
        {            
            DisplayObject(e.currentTarget).removeEventListener(MouseEvent.MOUSE_DOWN , onDown);        
            var target:DisplayObject = Visual(_displayObject).textField;
            _textPixelMap =    _pixelMapTools.getPixelMap(target);
            
            var px:int = 0;        
            for(px ; px < _textPixelMap.width; px++)
            {
                var py:int = 0;
                for(py ; py < _textPixelMap.height; py++)
                {                    
                    var s:Sprite = new Circle(_textPixelMap.getPixel(px, py),radius);                    
                    /* fillter 
                    var f:BlurFilter = new BlurFilter(1.1,1.1,1);
                    var f2:GlowFilter = new GlowFilter(0xFFFB38,0.7,2,2,2,1,true);                    
                    s.filters = [f,f2];
                    */                    
                    s.x = px * pointGapH;
                    s.y = py * pointGapV;
                    addChild(s);                    
                }                
            }            
        }
        
        
     }
}


import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.filters.BlurFilter;
import flash.geom.Point;

class PixelMap
{    
    public function PixelMap()
    {
        super();        
    }    
    public function getPixelMap(target:DisplayObject):BitmapData
    {
        if(target != null)
        {
            //0x3399ff
            var bd:BitmapData = new BitmapData(target.width, target.height, false , 0x3399ff);            
                bd.draw(target);
                //bd.applyFilter(bd, bd.rect, new Point(), new BlurFilter());
                //bd.draw(target)
            return bd;
        }else{
            return null;
        }
    }
}

//inner class panel Visual
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;

class Visual extends Sprite
{    
    public function Visual()
    {
        init();
    }
    protected function init():void
    {        
        setTextField();
        setButton();
        setControlPanel();
        this.addChild(_controlPanel);        
    }
    private function setTextField():void
    {
        
        textField = new TextField();
        //default style
        textField.textColor = 0x000000;
        textField.text = "Hello JT台灣";
        textField.autoSize = "left";
        textField.selectable = false;
        textField.height = 20;
        textField.background = true;
        //背景色(如果設定成白色,只會看到字的效果沒有底圖)
        textField.backgroundColor = 0xB6FAAD;
        //border enable
        textField.border = false;    
    }
    
    private function setButton():void
    {
        _button = new Sprite();    
        
        var label:TextField = new TextField();
            label.selectable = false;
            label.text = "Click me Start";
            label.autoSize =  TextFieldAutoSize.NONE ;
            label.height = 20;
        _button.addChild(label);        
        drawBackground(_button , 0xFFC668 , 0 , 0 , _button.width , _button.height);
    }    
    
    private function setControlPanel():void
    {
        var gapH:int = 10;
        var yofset:Number = 3;
        var xofset:Number = 3;
        _controlPanel = new Sprite();
        textField.y = yofset;
        textField.x = xofset;
        _controlPanel.addChild(textField);
        
        button.x = textField.x + textField.width + gapH;
        button.y = textField.y;
        _controlPanel.addChild(button);        
        drawBackground(_controlPanel , 0xD7EEFF , 0 , 0 , _controlPanel.width + (xofset*2) , _controlPanel.height + (yofset*2));
    }
    //
    protected function drawBackground(target:Sprite , color:uint , px:Number , py:Number , w:Number ,h:Number ):void
    {
        target.graphics.beginFill(color);        
        target.graphics.drawRect(px ,py , w , h);
        target.graphics.endFill();
    }    
    
    private var _textField:TextField;
    public function get textField():TextField
    {
        return _textField;
    }
    public function set textField(value:TextField):void
    {
        if(_textField != value)
        {
            _textField = value;
        }
    }
    
    private var _button:Sprite;
    public function get button():Sprite
    {
        return _button;
    }
    public function set button(value:Sprite):void
    {
        if(_button != value)
        {
            _button = value;
        }
    }
    
    private var _controlPanel:Sprite;
    public function get controlPanel():Sprite
    {
        return _controlPanel;
    }
    public function set controlPanel(value:Sprite):void
    {        
        _controlPanel = value;
    }
}

//
import flash.display.Sprite;
class Circle extends Sprite
{
    public function Circle(color:uint ,radius:Number )
    {
        super();
        graphics.beginFill(color);
        graphics.drawCircle(0, 0 ,radius);
        graphics.endFill();        
    }
}