/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kCyD
 */

// forked from ProjectNya's 深夜の砂嵐
////////////////////////////////////////////////////////////////////////////////
// 深夜の砂嵐
//
// BitmapDataでノイズ生成 (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=477
// [AS3.0] Noiseクラスに挑戦！
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1113
// [AS3.0] 燃える火・きらめく星・流れる水
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1047
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.Shape;
    import flash.filters.DropShadowFilter;
    import flash.utils.Timer;
    import flash.events.TimerEvent;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var bloods:Bloods;
        private var noise:Noise;

        public function Main() {
            //Wonderfl.capture_delay(1);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            //ノイズ生成
            noise = new Noise(new Rectangle(0, 0, 200, 160));
            //
            draw();
            //
            bloods = new Bloods(new Rectangle(0, 0, 200, 233));
            addChild(bloods);
            bloods.x = 132;
            bloods.y = 232;
            bloods.setup(12, new Rectangle(4, 45, 192, 64));
            bloods.color = [0x660000, 0x990000, 0xCC0000];
            //
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
            //
            var timer:Timer = new Timer(5000, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, complete, false, 0, true);
            timer.start();
        }
        private function update(evt:Event):void {
            //ノイズ生成
            noise.create(uint(Math.random()*1000));
        }
        private function complete(evt:TimerEvent):void {
            evt.target.removeEventListener(TimerEvent.TIMER_COMPLETE, complete);
            //
            bloods.start();
        }
        private function draw():void {
            var base:Shape = new Shape();
            addChild(base);
            base.graphics.beginFill(0x333333);
            base.graphics.drawRoundRect(-110, -90, 220, 180, 30);
            base.graphics.endFill();
            base.x = 232;
            base.y = 232;
            //
            var overlay:Shape = new Shape();
            addChild(overlay);
            overlay.graphics.beginFill(0x000000);
            overlay.graphics.drawRoundRect(-100, -80, 200, 160, 20);
            overlay.graphics.endFill();
            overlay.x = 232;
            overlay.y = 232;
            //
            var bitmap:Bitmap = new Bitmap(noise);
            addChild(bitmap);
            bitmap.x = 132;
            bitmap.y = 152;
            bitmap.mask = overlay;
            //
            var shade:Shape = new Shape();
            addChild(shade);
            shade.graphics.beginFill(0x000000);
            shade.graphics.drawRoundRect(-100, -80, 200, 160, 20);
            shade.graphics.endFill();
            shade.x = 232;
            shade.y = 232;
            shade.filters = [new DropShadowFilter(0, 90, 0x000000, 0.3, 8, 8, 2, 3, true, true, true)];
        }
        
    }

}


//////////////////////////////////////////////////
// Noiseクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;

class Noise extends BitmapData {
    private var seed:uint;
    private static var low:uint = 0;
    private static var high:uint = 255;
    private var channel:uint = 0;
    private var grayScale:Boolean = true;

    public function Noise(rect:Rectangle, g:Boolean = true, c:uint = 0, s:uint = 1) {
        super(rect.width, rect.height, false, 0xFF000000);
        grayScale = g;
        channel = c;
        if (grayScale) channel = 0;
        create(s);
    }

    public function create(s:uint):void {
        seed = s;
        if (seed == 0) seed = Math.floor(Math.random()*1000);
        lock();
        noise(seed, low, high, channel, grayScale);
        draw(this);
        unlock();
    }

}


//////////////////////////////////////////////////
// Bloodsクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Bloods extends Sprite {
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private static var ids:Array = [0, 0, 0, 0, 0, 1, 1, 2, 3];
    private var colors:Array;
    private var unit:uint;
    private var particles:Array;
    private var area:Rectangle;
    private static var targetPos:int = 500;

    public function Bloods(r:Rectangle) {
        rect = r;
        mouseChildren = false;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        particles = new Array();
    }
    public function setup(n:uint, a:Rectangle):void {
        unit = n;
        area = a;
    }
    public function set color(list:Array):void {
        colors = list;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, update);
    }
    private function update(evt:Event):void {
        create();
        draw();
    }
    private function create():void {
        for (var n:uint = 0; n < unit; n++) {
            var id:uint = ids[Math.floor(Math.random()*(ids.length+1))];
            var bloods:Particle = new Particle(colors[id]);
            bloods.x = area.x + Math.random()*area.width;
            bloods.y = area.y + Math.random()*area.height;
            particles.push(bloods);
            var itween:ITween = BetweenAS3.serial(
                BetweenAS3.tween(bloods, {alpha: 1, scaleY: 0.75}, {alpha: 0, scaleY: 0.25}, 0.4, Quad.easeOut), 
                BetweenAS3.to(bloods, {y: targetPos, alpha: 0, scaleY: 1}, 0.8, Quad.easeIn)
            );
            itween.addEventListener(TweenEvent.COMPLETE, complete, false, 0, false);
            itween.play();
        }
    }
    private function complete(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, complete);
        var bloods:Particle = evt.target.getTweenAt(0).target;
        particles.shift();
    }
    private function draw():void {
        bitmapData.lock();
        bitmapData.fillRect(rect, 0x00000000);
        for (var n:uint = 0; n < particles.length; n++) {
            var bloods:Particle = particles[n];
            var matrix:Matrix = new Matrix();
            matrix.translate(bloods.x, bloods.y);
            var colorTrans:ColorTransform = new ColorTransform();
            colorTrans.color = bloods.color;
            colorTrans.alphaMultiplier = bloods.alpha;
            bitmapData.draw(bloods, matrix, colorTrans, BlendMode.ADD);
        }
        bitmapData.unlock();
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class Particle extends Shape {
    private static var _width:uint = 20;
    private static var _height:uint = 40;
    private static var yOffset:int = 20;
    private static var bColor:uint = 0xFFFFFF;
    public var color:uint;

    public function Particle(c:uint) {
        color = c;
        draw();
    }

    private function draw():void {
        var colors:Array = [bColor, bColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(_width, _height, 0, -_width*0.5, -_height*0.5+yOffset);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawEllipse(-_width*0.5, -_height*0.5+yOffset, _width, _height);
        graphics.endFill();
    }

}
