/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kCkd
 */

 /* ------------------------------- *
  *       RE: TMA_Untitled_01       *
  *     "Matching Game" (INTERN)    *
  *          Walker Dalton          *
  * ------------------------------- */

package
{
    import flash . net     . *;
    import flash . text    . *; 
    import flash . geom    . *;
    import flash . system  . *;
    import flash . events  . *;  
    import flash . display . *;
    import flash . filters . *;

    [SWF(width = 1024, height = 600, widthPercent = 100, heightPercent = 100, frameRate = 60)]
    public class APP_Main extends Sprite
    {
        //instances
        private var appDefine : APP_Define;
        private var appStyle : APP_Style;
        //global
        private var sw : int = stage.stageWidth;
        private var sh : int = stage.stageHeight;
        
        public var intStageC : int = 0;
        public var intImageC : int = 1;
        public var boolStage0 : Boolean = true;
        public var boolStage1 : Boolean = false;
        public var boolStage2 : Boolean = false;
        public var boolStage3 : Boolean = false;
        
        public var _dockArr  : Array = new Array();
        public var _boolDock : Boolean = false;
        public var _objDockI : int = -1;
        public var _objDockC : Object;
        
        public var _matchArr : Array = new Array();
        
        private var _gBool  : Boolean = false;
        private var _gAlpha : Number = 0.25;
        private var _glowBtnChoice1 : Sprite = new Sprite;
        private var _glowBtnChoice2 : Sprite = new Sprite;
        private var _glowBtnChoice3 : Sprite = new Sprite;
        
        private var _glowImgChoice1 : Sprite = new Sprite;
        private var _glowImgChoice2 : Sprite = new Sprite;
        
        private var _selectedImg : Loader = new Loader;

        public function APP_Main ():void
        {
            stage.scaleMode = StageScaleMode.SHOW_ALL;
            stage.align = StageAlign.TOP;

            appDefine = new APP_Define;
            appStyle = new APP_Style;

            sw = stage.stageWidth;
            sh = stage.stageHeight;

            _gAlpha = 0.25;

            for (var i:int = 0; i<8; i++)
            {
                _dockArr[i] = new Sprite ();
                appDefine._defineShape(_dockArr[i], ((sw*0.975)-(sw-(sw*0.175)*2)/5), (sh*(0.22+(i*0.085))), 40, 40, 0, 0x333333, false);
                _dockArr[i].name = "_dockArr[" + i + "]";
            }
            
            addEventListener(MouseEvent.MOUSE_OVER , _evntHandler);
            addEventListener(MouseEvent.MOUSE_OUT  , _evntHandler);
            addEventListener(MouseEvent.MOUSE_DOWN , _evntHandler);
            addEventListener(MouseEvent.MOUSE_UP   , _evntHandler);
            addEventListener(Event.ADDED_TO_STAGE  , _evntHandler);
            addEventListener(Event.ENTER_FRAME     , _evntHandler);            
            
            _loadStage();
        }
        
        public function _loadStage ():void
        //extremely verbose; trim near completion
        {
            _removeAllChild();
            _gAlpha = 0.25; //lol
            
            appDefine._defineShape(appDefine._sprStageBG    , 0, 0, (sw+5), sh, 0, 0xCCCCCC, false);
            addChild(appDefine._sprStageBG);
            
            appDefine._bmpStageLogo.load(appDefine.TMA_URL);
            addChild(appDefine._bmpStageLogo);
            appDefine._bmpStageLogo.scaleX = 0.35;
            appDefine._bmpStageLogo.scaleY = 0.35;
            appDefine._bmpStageLogo.x = (sw*0.025);
            appDefine._bmpStageLogo.y = 7;
            appDefine._bmpStageLogo.filters = [appStyle._addShadow(1)]
            
            if (intStageC == 0)
            {
                removeEventListener(Event.ENTER_FRAME, _objHandler);
                
                appDefine._definePanel(appDefine._sprStageInit  , (sw*0.175), (sh*0.1), (sw-((sw*0.175)*2)), (sh-((sh*0.1)*2)));
                appDefine._definePanel(appDefine._sprStageInst  , (sw*0.025), (sh*0.1), (appDefine._sprStageInit.width/5), (sh-((sh*0.1)*2)));
                
                appDefine._bmpChoiceWF.load(appDefine.WF0_URL);
                appDefine._bmpChoiceWF.x = (sw*0.025)+3;
                appDefine._bmpChoiceWF.y = (sh*0.1)+4;
                appDefine._bmpChoiceWF.scaleX = 0.166;
                appDefine._bmpChoiceWF.scaleY = 0.265;
                appDefine._bmpChoiceCF.load(appDefine.CF_URL);
                appDefine._bmpChoiceCF.x = (sw*0.025)+3;
                appDefine._bmpChoiceCF.y = (sh*0.1)+165;
                appDefine._bmpChoiceCF.scaleX = 0.122;
                appDefine._bmpChoiceCF.scaleY = 0.22;

                appDefine._defineBtn  (appDefine._sprBtnChoice1 , appDefine._txtBtnChoice1, "easy", (sw*0.175+(appDefine._sprStageInit.width*0.10))  , (sh*0.099+(appDefine._sprStageInit.height/4)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice2 , appDefine._txtBtnChoice2, "normal", (sw*0.175+(appDefine._sprStageInit.width*0.10)) , (sh*0.099+(appDefine._sprStageInit.height/4 + 50)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice3 , appDefine._txtBtnChoice3, "hard", (sw*0.175+(appDefine._sprStageInit.width*0.10))   , (sh*0.099+(appDefine._sprStageInit.height/4 + 100)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnRestart , appDefine._txtBtnRestart, "_sprBtnRestart", (sw*0.175+((appDefine._sprStageInit.width*0.95)-(80*1.35)))  , (sh*0.099+(appDefine._sprStageInit.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnLink    , appDefine._txtBtnLink   , "_sprBtnLink"    , ((sw*0.975)-appDefine._sprStageInst.width), (sh*0.1)  , appDefine._sprStageInst.width, (20*1.125));
                appDefine._defineLabel(appDefine._txtStageTitle , "intro",(sw/2-(appDefine._txtStageTitle.width*1.5)), (sw*0.005), 44, 0xC7E4FF, 2);
                appDefine._defineLabel(appDefine._txtStageInit  , "Match up the given colors with those in the works of art.\nThis game has three levels of difficulty listed below.", (sw*0.22), (sh*0.16), 22, 0x666666, 2);
                
                appDefine._defineShape(_glowBtnChoice1          ,(sw*0.175+(appDefine._sprStageInit.width*0.1)), (sh*0.099+(appDefine._sprStageInit.height/4)), (80*1.35)-1, (20*1.125), 0, 0xFFCD38, false, _gAlpha);
                appDefine._defineShape(_glowBtnChoice2          ,(sw*0.175+(appDefine._sprStageInit.width*0.1)), (sh*0.099+(appDefine._sprStageInit.height/4 + 50)), (80*1.35)-1, (20*1.125), 0, 0xFFCD38, false, _gAlpha);
                appDefine._defineShape(_glowBtnChoice3          ,(sw*0.175+(appDefine._sprStageInit.width*0.1)), (sh*0.099+(appDefine._sprStageInit.height/4 + 100)), (80*1.35)-1, (20*1.125), 0, 0xFFCD38, false, _gAlpha);
                
                _glowBtnChoice1.mouseEnabled = false;
                _glowBtnChoice2.mouseEnabled = false;
                _glowBtnChoice3.mouseEnabled = false;

                addChild(appDefine._sprStageInit);
                addChild(appDefine._sprStageInst);
                    appDefine._sprStageInst.addChild(appDefine._bmpChoiceWF);
                    appDefine._sprStageInst.addChild(appDefine._bmpChoiceCF);
                addChild(appDefine._txtStageInit);
                addChild(appDefine._sprBtnChoice1);
                addChild(appDefine._sprBtnChoice2);
                addChild(appDefine._sprBtnChoice3);
                addChild(appDefine._sprBtnRestart);
                addChild(appDefine._sprBtnLink);
                
                addChild(_glowBtnChoice1);
                addChild(_glowBtnChoice2);
                addChild(_glowBtnChoice3);
                
                addChild(_glowImgChoice1);
                
                addChild(appDefine._txtBtnChoice1);
                addChild(appDefine._txtBtnChoice2);
                addChild(appDefine._txtBtnChoice3);
                addChild(appDefine._txtBtnRestart);
                addChild(appDefine._txtStageTitle);
                addChild(appDefine._txtBtnLink);

                boolStage0 = false;
            }
            else if (intStageC == 1)
            {
                if (intImageC > 0)
                {
                addEventListener(Event.ENTER_FRAME, _objHandler);
    
                appDefine._definePanel(appDefine._sprStageMain  , (sw*0.175), (sh*0.1), (sw-((sw*0.175)*2)), (sh-((sh*0.1)*2)));
                appDefine._definePanel(appDefine._sprStageInst  , (sw*0.025), (sh*0.1), (appDefine._sprStageMain.width/5), (sh-((sh*0.1)*2)));
                appDefine._defineBtn  (appDefine._sprBtnChoice1 , appDefine._txtBtnChoice1, "_sprBtnChoice1", (sw*0.175+(appDefine._sprStageMain.width*0.05))  , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice2 , appDefine._txtBtnChoice2, "_sprBtnChoice2", (sw*0.175+(appDefine._sprStageMain.width*0.225)) , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice3 , appDefine._txtBtnChoice3, "_sprBtnChoice3", (sw*0.175+(appDefine._sprStageMain.width*0.4))   , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnRestart , appDefine._txtBtnRestart, "_sprBtnRestart", (sw*0.175+((appDefine._sprStageMain.width*0.95)-(80*1.35)))  , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnReset   , appDefine._txtBtnReset  , "_sprBtnReset"   , ((sw*0.975)-appDefine._sprStageInst.width), (sh*0.1), appDefine._sprStageInst.width, (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnLink    , appDefine._txtBtnLink   , "_sprBtnLink"    , ((sw*0.975)-appDefine._sprStageInst.width), (sh*0.16)  , appDefine._sprStageInst.width, (20*1.125));
                appDefine._defineLabel(appDefine._txtStageTitle , "difficulty 1",(sw/2-(appDefine._txtStageTitle.width*1.5)), (sw*0.005), 44, 0xC7E4FF, 2);
                appDefine._defineLabel(appDefine._txtStageInst  , "Look carefully\nat the image\n\nCan you find the\nmatching elemants?\n\nDrag the\nmatching elemant to it's\nlocation on the image"  , (sw*0.03), (sh*0.11), 12, 0x666666, 2);
                
                addChild(appDefine._sprStageMain);
                addChild(appDefine._sprStageInst);
                addChild(appDefine._sprBtnChoice1);
                addChild(appDefine._sprBtnChoice2);
                addChild(appDefine._sprBtnChoice3);
                addChild(appDefine._sprBtnReset);
                addChild(appDefine._sprBtnRestart);
                addChild(appDefine._sprBtnLink);
                
                addChild(appDefine._txtBtnChoice1);
                addChild(appDefine._txtBtnChoice2);
                addChild(appDefine._txtBtnChoice3);
                addChild(appDefine._txtBtnReset);
                addChild(appDefine._txtBtnRestart);
                addChild(appDefine._txtBtnLink);
                addChild(appDefine._txtStageTitle);
                addChild(appDefine._txtStageInst);
                
                for (var i:int = 0; i<8; i++)
                {
                    _dockArr[i].y = 0;
                    _dockArr[i].x = 0;
                    
                    addChild(_dockArr[i]);
                }
                
                boolStage1 = false;
                }
            }
            else if (intStageC == 2)
            {
                if (intImageC > 0)
                {
                addEventListener(Event.ENTER_FRAME, _objHandler);

                appDefine._definePanel(appDefine._sprStageMain  , (sw*0.175), (sh*0.1), (sw-((sw*0.175)*2)), (sh-((sh*0.1)*2)));
                appDefine._definePanel(appDefine._sprStageInst  , (sw*0.025), (sh*0.1), (appDefine._sprStageMain.width/5), (sh-((sh*0.1)*2)));
                appDefine._defineBtn  (appDefine._sprBtnChoice1 , appDefine._txtBtnChoice1, "_sprBtnChoice1", (sw*0.175+(appDefine._sprStageMain.width*0.05))  , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice2 , appDefine._txtBtnChoice2, "_sprBtnChoice2", (sw*0.175+(appDefine._sprStageMain.width*0.225)) , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice3 , appDefine._txtBtnChoice3, "_sprBtnChoice3", (sw*0.175+(appDefine._sprStageMain.width*0.4))   , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnRestart , appDefine._txtBtnRestart, "_sprBtnRestart", (sw*0.175+((appDefine._sprStageMain.width*0.95)-(80*1.35)))  , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnReset   , appDefine._txtBtnReset  , "_sprBtnReset"   , ((sw*0.975)-appDefine._sprStageInst.width), (sh*0.1), appDefine._sprStageInst.width, (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnLink    , appDefine._txtBtnLink   , "_sprBtnLink"    , ((sw*0.975)-appDefine._sprStageInst.width), (sh*0.16)  , appDefine._sprStageInst.width, (20*1.125));
                appDefine._defineLabel(appDefine._txtStageTitle , "difficulty 2",(sw/2-(appDefine._txtStageTitle.width*1.5)), (sw*0.005), 44, 0xC7E4FF, 3);
                appDefine._defineLabel(appDefine._txtStageInst  , "Look carefully\nat the image\n\nCan you find the\nmatching elemants?\n\nDrag the\nmatching elemant to it's\nlocation on the image"  , (sw*0.03), (sh*0.11), 12, 0x666666, 2);
                
                addChild(appDefine._sprStageMain);
                addChild(appDefine._sprStageInst);
                addChild(appDefine._sprBtnChoice1);
                addChild(appDefine._sprBtnChoice2);
                addChild(appDefine._sprBtnChoice3);
                addChild(appDefine._sprBtnReset);
                addChild(appDefine._sprBtnRestart);
                addChild(appDefine._sprBtnLink);
                
                addChild(appDefine._txtBtnChoice1);
                addChild(appDefine._txtBtnChoice2);
                addChild(appDefine._txtBtnChoice3);
                addChild(appDefine._txtBtnReset);
                addChild(appDefine._txtBtnRestart);
                addChild(appDefine._txtBtnLink);
                addChild(appDefine._txtStageTitle);       
                addChild(appDefine._txtStageInst); 

                for (var j:int = 0; j<8; j++)
                {
                    _dockArr[j].y = 0;
                    _dockArr[j].x = 0;
                    
                    addChild(_dockArr[j]);
                }

                boolStage2 = false;
                }
            }
            else if (intStageC == 3)
            {
                if (intImageC > 0)
                {
                addEventListener(Event.ENTER_FRAME, _objHandler);
                
                appDefine._definePanel(appDefine._sprStageMain  , (sw*0.175), (sh*0.1), (sw-((sw*0.175)*2)), (sh-((sh*0.1)*2)));
                appDefine._definePanel(appDefine._sprStageInst  , (sw*0.025), (sh*0.1), (appDefine._sprStageMain.width/5), (sh-((sh*0.1)*2)));
                appDefine._defineBtn  (appDefine._sprBtnChoice1 , appDefine._txtBtnChoice1, "_sprBtnChoice1", (sw*0.175+(appDefine._sprStageMain.width*0.05))  , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice2 , appDefine._txtBtnChoice2, "_sprBtnChoice2", (sw*0.175+(appDefine._sprStageMain.width*0.225)) , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnChoice3 , appDefine._txtBtnChoice3, "_sprBtnChoice3", (sw*0.175+(appDefine._sprStageMain.width*0.4))   , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnRestart , appDefine._txtBtnRestart, "_sprBtnRestart", (sw*0.175+((appDefine._sprStageMain.width*0.95)-(80*1.35)))  , (sh*0.099+(appDefine._sprStageMain.height)), (80*1.35), (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnReset   , appDefine._txtBtnReset  , "_sprBtnReset"   , ((sw*0.975)-appDefine._sprStageInst.width), (sh*0.1), appDefine._sprStageInst.width, (20*1.125));
                appDefine._defineBtn  (appDefine._sprBtnLink    , appDefine._txtBtnLink   , "_sprBtnLink"    , ((sw*0.975)-appDefine._sprStageInst.width), (sh*0.16)  , appDefine._sprStageInst.width, (20*1.125));
                appDefine._defineLabel(appDefine._txtStageTitle , "difficulty 3",(sw/2-(appDefine._txtStageTitle.width*1.5)), (sw*0.005), 44, 0xC7E4FF, 3);
                appDefine._defineLabel(appDefine._txtStageInst  , "Look carefully\nat the image\n\nCan you find the\nmatching elemants?\n\nDrag the\nmatching elemant to it's\nlocation on the image"  , (sw*0.03), (sh*0.11), 12, 0x666666, 2);

                addChild(appDefine._sprStageMain);
                addChild(appDefine._sprStageInst);
                addChild(appDefine._sprBtnChoice1);
                addChild(appDefine._sprBtnChoice2);
                addChild(appDefine._sprBtnChoice3);
                addChild(appDefine._sprBtnReset);
                addChild(appDefine._sprBtnRestart);
                addChild(appDefine._sprBtnLink);
                
                addChild(appDefine._txtBtnChoice1);
                addChild(appDefine._txtBtnChoice2);
                addChild(appDefine._txtBtnChoice3);
                addChild(appDefine._txtBtnReset);
                addChild(appDefine._txtBtnRestart);
                addChild(appDefine._txtBtnLink);
                addChild(appDefine._txtStageTitle);      
                addChild(appDefine._txtStageInst); 

                for (var k:int = 0; k<8; k++)
                {
                    _dockArr[k].y = 0;
                    _dockArr[k].x = 0;
                    
                    addChild(_dockArr[k]);
                }

                boolStage3 = false;
                }
            }          
            _bmpHandler();
            appDefine._setNames();
        }
        
        public function _bmpHandler ():void
        {
            if (intImageC == 0)
            {
                appDefine._bmpChoiceWF.load(appDefine.WF0_URL);
                appDefine._bmpChoiceWF.x = (sw*0.025)+3;
                appDefine._bmpChoiceWF.y = (sh*0.1)+4;
                appDefine._bmpChoiceWF.scaleX = 0.166;
                appDefine._bmpChoiceWF.scaleY = 0.265;
                appDefine._bmpChoiceCF.load(appDefine.CF_URL);
                appDefine._bmpChoiceCF.x = (sw*0.025)+3;
                appDefine._bmpChoiceCF.y = (sh*0.1)+165;
                appDefine._bmpChoiceCF.scaleX = 0.122;
                appDefine._bmpChoiceCF.scaleY = 0.22;
                
                appDefine._sprStageInst.addChild(appDefine._bmpChoiceWF);
                appDefine._sprStageInst.addChild(appDefine._bmpChoiceCF);

            }
            else if (intImageC == 1)
            {
                _selectedImg.load(appDefine.WF0_URL);
                _selectedImg.x = (sw*0.175)+3;
                _selectedImg.y = (sh*0.1)+3;
                _selectedImg.scaleX = 0.875;
                _selectedImg.scaleY = 0.7925;
                _selectedImg.mask = appDefine._sprStageMain;
   
                addChild(_selectedImg);
            }
            else if (intImageC == 2)
            {
                _selectedImg.load(appDefine.CF_URL);
                _selectedImg.x = (sw*0.175)+3;
                _selectedImg.y = (sh*0.1)+3;
                _selectedImg.scaleX = 0.643;
                _selectedImg.scaleY = 0.695;
                _selectedImg.mask = appDefine._sprStageMain;
                
                addChild(_selectedImg);
            }
            else if (intImageC == 3)
            {
                _selectedImg.load(appDefine.WF1_URL);
                _selectedImg.x = (sw*0.175)+3;
                _selectedImg.y = (sh*0.1)+3;
                _selectedImg.scaleX = 0.875;
                _selectedImg.scaleY = 0.7925;
                _selectedImg.mask = appDefine._sprStageMain;
                
                addChild(_selectedImg);
            }
            else if (intImageC == 4)                     
            {
                _selectedImg.load(appDefine.WF2_URL);
                _selectedImg.x = (sw*0.175)+3
                _selectedImg.y = (sh*0.1)+3;
                _selectedImg.scaleX = 0.875;
                _selectedImg.scaleY = 0.7925;
                _selectedImg.mask = appDefine._sprStageMain;

                addChild(_selectedImg);
            }
            else if (intImageC == 5)
            {
                _selectedImg.load(appDefine.WF3_URL);
                _selectedImg.x = (sw*0.175)+3;
                _selectedImg.y = (sh*0.1)+3;
                _selectedImg.scaleX = 0.875;
                _selectedImg.scaleY = 0.7925;
                _selectedImg.mask = appDefine._sprStageMain;
                
                addChild(_selectedImg); 
            }
            else if (intImageC == 6)
            {
              //_selectedImg.load(appDefine.WF4_URL);
                addChild(_selectedImg); 
            }
            else if (intImageC == 7)
            {
              //_selectedImg.load(appDefine.WF5_URL);
                addChild(_selectedImg);    
            }
            else if (intImageC == 8)
            {
               //selectedImg.load(appDefine.WF6_URL);
                addChild(_selectedImg);    
            }
            else if (intImageC == 9)
            {
              //_selectedImg.load(appDefine.WF7_URL);
                addChild(_selectedImg);
            }
            else if (intImageC == 10)
            {
              //_selectedImg.load(appDefine.WF8_URL);
                addChild(_selectedImg); 
            }
        }
        
        public function _objHandler (e:Event):void
        {
            var _dX :int;
            var _dY :int;
                
            if (_boolDock == false)
            {
                for (var i:int = 0; i<8; i++)
                {
                    if (mouseX > ((sw*0.175)+(sw-((sw*0.175)*2))))
                    {
                        _dX = (mouseX - ((sw*0.975)-(sw-(sw*0.175)*2)/5));
                        _dY = (mouseY - (sh*(0.22+(i*0.085))));

                        if (_dX > (-40 * Math.PI) && _dX < (40 * Math.PI) && _dY > (-40 * Math.PI) && (_dY < 40 * Math.PI)) //
                        {
                          //_dockArr[i].scaleX = 1+ 0.005*Math.cos(_dX/40);
                            _dockArr[i].scaleY = 1+ 0.0075*Math.cos(_dY/40);
                        }
                    }else{
                        _dockArr[i].scaleY = 1;
                    }
                }
            } 
        }

        public function _evntHandler (e:Event):void
        {
            appDefine = new APP_Define;
            appStyle = new APP_Style;
 
            appDefine._setNames();           
            
            switch (e.type)  
            {
                case MouseEvent.MOUSE_DOWN:

                e.target.filters = [appStyle._addShadow(-1)];
                
                switch (e.target.name)
                {
                    case "_sprBtnRestart":
                    
                    appDefine._sprBtnRestart.alpha = 0.6;
                    boolStage0 = true;
                    intStageC = 0;
                    intImageC = 1;              
                    _loadStage();

                    break;
                    case "_sprBtnChoice1":
                    
                    appDefine._sprBtnChoice1.alpha = 0.6;
                    intStageC = 1;
                    _loadStage();

                    break;
                    case "_sprBtnChoice2":
                    
                    appDefine._sprBtnChoice2.alpha = 0.6;
                    intStageC = 2;
                    _loadStage();

                    break;
                    case "_sprBtnChoice3":
                    
                    appDefine._sprBtnChoice3.alpha = 0.6;
                    intStageC = 3;
                    _loadStage();

                    break;
                    case "_sprBtnReset":
                    
                    appDefine._sprBtnReset.alpha = 0.6;

                    break;
                    case "_sprBtnLink":
                    
                    appDefine._sprBtnLink.alpha = 0.6;

                    break;
                    case "_bmpChoiceWF":
                    
                    e.target.alpha = 0.6;
                    intImageC = 1;
                    _bmpHandler();

                    break;
                    case "_bmpChoiceCF":

                    e.target.alpha = 0.6;
                    intImageC = 2;
                    _bmpHandler();
                    
                    break;
                    case "_bmpStageMain":
                    
                    e.target.alpha = 0.6;
                    
                    break;
                    case "_dockArr[0]":
                    
                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[0], numChildren-1);
                    _objDockC = e.target;
                    _objDockI = 0;
 
                    break;
                    case "_dockArr[1]":
                    
                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[1], numChildren-1);        
                    _objDockC = e.target;
                    _objDockI = 1;
                              
                    break;
                    case "_dockArr[2]":
               
                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[2], numChildren-1);        
                    _objDockC = e.target;
                    _objDockI = 2;     
                    
                    break;
                    case "_dockArr[3]":

                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[3], numChildren-1);        
                    _objDockC = e.target;
                    _objDockI = 3;                         
                    
                    break;
                    case "_dockArr[4]":
                    
                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[4], numChildren-1);        
                    _objDockC = e.target;
                    _objDockI = 4;     

                    break;
                    case "_dockArr[5]":
                    
                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[5], numChildren-1);        
                    _objDockC = e.target;
                    _objDockI = 5;     

                    break;
                    case "_dockArr[6]":
                    
                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[6], numChildren-1);        
                    _objDockC = e.target;
                    _objDockI = 6;     
                    
                    break;
                    case "_dockArr[7]":
                    
                    _boolDock = true;
                    e.target.alpha = 0.6;
                    setChildIndex(_dockArr[7], numChildren-1);        
                    _objDockC = e.target;
                    _objDockI = 7;     
                    
                    break;              
                }
          
              //appDefine._traceMsg(e.target.name);
              ///addChild(appDefine._txtTrace);
                
                break;
                case MouseEvent.MOUSE_UP:
                
                    e.target.alpha = 1;
                    e.target.filters = [appStyle._addShadow(1)];
                    
                    if (intStageC == 1)
                    {
                        if (mouseX > (sw*0.175) && mouseY > (sh*0.1) && mouseX < (sw*0.175) + (sw-((sw*0.175)*2)) && mouseY < (sh*0.1) + (sh-((sh*0.1)*2)))
                        {
                            switch (e.target.name)
                            {
                                case "_dockArr[0]":
                    
                                intImageC = 3;
                                _loadStage();
                                //fun fact
 
                                break;
                                case "_dockArr[1]":
                    
                                intImageC = 4;
                                _loadStage();
                                //fun fact
                              
                                break;
                                case "_dockArr[2]":
                                
                                intImageC = 5;
                                _loadStage();
                                //fun fact
                                
                                break;
                                case "_dockArr[3]":
                                
                                break;
                                case "_dockArr[4]":

                                break;
                                case "_dockArr[5]":

                                break;
                                case "_dockArr[6]":
                    
                                break;
                                case "_dockArr[7]":
                    
                                break;              
                            }
                        }
                    }
                    
                    if (_boolDock)
                    {
                        _objDockC = null;
                        _objDockI = -1;
                        
                        _boolDock = false;
                    }

                  //removeChild(getChildByName("_txtTrace"));
                
                break;
                case MouseEvent.MOUSE_OVER:
                    
                    e.target.filters = [appStyle._addShadow(2)];
                
                break;
                case MouseEvent.MOUSE_OUT:
                
                    e.target.filters = [appStyle._addShadow(1)];
                
                break;
                case MouseEvent.MOUSE_MOVE:
                break;
                case Event.RESIZE:
                break;
                case Event.ENTER_FRAME:                
                
                if (_boolDock)
                {

                _objDockC.x = (mouseX - ((sw*0.975)-(sw-(sw*0.175)*2)/5) - 20);
                _objDockC.y = (mouseY - (sh*(0.22+(_objDockI*0.085))) - 20);

                }
                
                if ( _gAlpha > 0.8 )
                {
                    _gBool = true;
                } 
                
                if ( _gAlpha < 0.25 )
                {
                    _gBool = false;
                }

                if ( _gBool == false )
                {
                    _gAlpha += 0.01;
                } else {
                    _gAlpha -= 0.01;
                }
                
                _glowBtnChoice1.alpha = _gAlpha;
                _glowBtnChoice2.alpha = _gAlpha;
                _glowBtnChoice3.alpha = _gAlpha;
                           
                break;
                case Event.ADDED_TO_STAGE:
                break;
            }
        }
        
        public function _swapImg (intImg:int):void
        {
            switch (intImg)
            {
                case 0:

                _removeAllChild(appDefine._sprStageMain);
                intImageC = 3;
                _bmpHandler();
                
                break;
                case 1:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 4;
                
                break;
                case 2:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 5;
                
                break;
                case 3:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 6;
                
                break;
                case 4:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 7;
                
                break;
                case 5:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 8;
                
                break;
                case 6:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 9;
                
                break;
                case 7:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 10;
                
                break;
                case 8:
                
                _removeAllChild(appDefine._sprStageMain);
                intImageC = 11;
                
                break;
            }

        }
        
        public function _removeAllChild (objRef:Object = null):void
        {
            if (objRef == null)
            {
                while (numChildren > 0)
                {
                        removeChildAt(0);
                }
            }else{
                while (objRef.numChildren > 0)
                {
                        removeChildAt(0);
                }
            }
        }

        //public function _collisionObj (...):void {...}
        
    }//2
}//1

class APP_Define
{ 
    import flash . net     . *;
    import flash . text    . *; 
    import flash . geom    . *;
    import flash . system  . *;
    import flash . events  . *;
    import flash . display . *;
    import flash . filters . *;

    public var resMultiplier :uint = 5;

    public const DROPSHADOW :uint = 0x000000;
    public const TXT_INPUT  :uint = 0x333333;
    public const BTN_FACE   :uint = 0xFFFFFF;
    public const LBL_TEXT   :uint = 0x666666;
    public const PANEL      :uint = 0xF3F3F3;
    public const PBAR       :uint = 0xFFFFFF;
    public const BG         :uint = 0xCCCCCC;
    
    private var appStyle  : APP_Style;
    private var appDefine : APP_Define;
     
    //stagePanel

    public var _sprStageBG   : Sprite = new Sprite ();
    public var _sprStageInit : Sprite = new Sprite ();
    public var _sprStageMain : Sprite = new Sprite ();
    public var _sprStageInst : Sprite = new Sprite ();
    public var _sprStageImg  : Sprite = new Sprite ();
    
    public var _txtStageTitle: TextField = new TextField ();
    public var _txtStageInit : TextField = new TextField ();
    public var _txtStageInst : TextField = new TextField ();
        
    public var _bmpStageLogo : Loader = new Loader ();
    public var _bmpStageMain : Loader = new Loader ();
    public var _bmpChoiceWF  : Loader = new Loader ();
    public var _bmpChoiceCF  : Loader = new Loader ();
    public var _bmpMainWF    : Loader = new Loader ();

    //stageBtn
 
    public var _sprBtnChoice1  : Sprite = new Sprite (); //instance17
    public var _sprBtnChoice2  : Sprite = new Sprite (); //instance18
    public var _sprBtnChoice3  : Sprite = new Sprite (); //instance19
    public var _sprBtnChoiceDD : Sprite = new Sprite ();
        public var __sprChildChoice0 : Sprite = new Sprite ();
        public var __sprChildChoice1 : Sprite = new Sprite ();
        public var __sprChildChoice2 : Sprite = new Sprite ();
    public var _sprBtnInstr    : Sprite = new Sprite ();
    public var _sprBtnRestart  : Sprite = new Sprite ();
    public var _sprBtnReset    : Sprite = new Sprite (); //instance25
    public var _sprBtnLink     : Sprite = new Sprite ();
    
    public var _txtBtnChoice1  : TextField = new TextField ();
    public var _txtBtnChoice2  : TextField = new TextField ();
    public var _txtBtnChoice3  : TextField = new TextField ();
    public var _txtBtnChoiceDD : TextField = new TextField ();
        public var __txtChildChoice0 : TextField = new TextField ();
        public var __txtChildChoice1 : TextField = new TextField ();
        public var __txtChildChoice2 : TextField = new TextField ();
    public var _txtBtnInstr    : TextField = new TextField ();
    public var _txtBtnRestart  : TextField = new TextField ();
    public var _txtBtnReset    : TextField = new TextField ();
    public var _txtBtnLink     : TextField = new TextField ();
    
    //variables
    
    public var _txtTrace : TextField = new TextField();
    
    /*
    public var objGravity : Number = 0.5;
    public var velX       : Number = 0.0;
    public var velY       : Number = 0.0;
    public var objFloor   : Boolean = false; //all objects initiated "above floor"
    */

    //URL
    public var TMA_URL : URLRequest = new URLRequest("http://s13.postimage.org/slokjpcur/tma_logo.png");
    
    public var WF0_URL : URLRequest = new URLRequest("http://www.mediafire.com/convkey/9b68/n87ruzj9epg0a185g.jpg");
    public var WF1_URL : URLRequest = new URLRequest("http://www.mediafire.com/convkey/faf1/f2x1irtd50816dh5g.jpg");
    public var WF2_URL : URLRequest = new URLRequest("http://www.mediafire.com/convkey/5e45/88q506amu60apbu5g.jpg");
    public var WF3_URL : URLRequest = new URLRequest("http://www.mediafire.com/convkey/86f4/uysdlm168v93r1r5g.jpg");
    public var WF4_URL : URLRequest = new URLRequest("");
    public var WF5_URL : URLRequest = new URLRequest("");
    public var WF6_URL : URLRequest = new URLRequest("");
    public var WF7_URL : URLRequest = new URLRequest("");
    public var WF8_URL : URLRequest = new URLRequest("");
    
    public var WFobj_1 : URLRequest = new URLRequest("http://www.mediafire.com/conv/b23e6970d18dbe80d24c03efeeb99b78681e7d8e127e217f0b356e1b4415d5ad6g.jpg");
    public var WFobj_2 : URLRequest = new URLRequest("http://www.mediafire.com/conv/0eb1f7ec18b98ad6a39d5ffedebcee23817a7f005d323ae32fea332454087ea76g.jpg");
    public var WFobj_3 : URLRequest = new URLRequest("http://www.mediafire.com/conv/2c3da0da53561e45a1f75b29c7f567688840d9c25722265ccd07376e15005e9e6g.jpg");
    public var WFobj_4 : URLRequest = new URLRequest("http://www.mediafire.com/conv/6687991e45fc2901e74b8413aa3b92bae258127bb00a0b503e2dbd9225745a466g.jpg");
    public var WFobj_5 : URLRequest = new URLRequest("http://www.mediafire.com/conv/97a650b70a5fcb7d734d9a76eb98ab8a8f9364576cd5974cc136052e8ef60db56g.jpg");
    public var WFobj_6 : URLRequest = new URLRequest("http://www.mediafire.com/conv/ef18fd299c992100d3a5c791dd9df6c275929e70e64b26bb38f06d039e57d3ac6g.jpg");
    public var WFobj_7 : URLRequest = new URLRequest("http://www.mediafire.com/conv/c743b2137e69c2c8be75408e69c165a09d6af9f6a67722cdc5c36de2eb47002d6g.jpg");
    public var WFobj_8 : URLRequest = new URLRequest("http://www.mediafire.com/conv/a5e3fc2dabf07dfe495c4a424d4d20d083f9ad50e97be053c804cc4252ce32ce6g.jpg");
    
    public var CF_URL  : URLRequest = new URLRequest("http://www.mediafire.com/conv/889c0bff47421943624a74a8c52f8922d5971b904ad86b615226069adf2a0d036g.jpg");
    
    public function _setNames():void
    {
        _sprBtnChoiceDD.name = "_sprBtnChoiceDD";
        _sprBtnChoice1.name  = "_sprBtnChoice1";
        _sprBtnChoice2.name  = "_sprBtnChoice2";
        _sprBtnChoice3.name  = "_sprBtnChoice3";
        _sprBtnRestart.name  = "_sprBtnRestart";

        _sprBtnReset.name    = "_sprBtnReset";
        _sprBtnInstr.name    = "_sprBtnInstr";
        _sprBtnLink.name     = "_sprBtnLink";
        _txtTrace.name       = "_txtTrace";
        
        _bmpStageMain.name   = "_bmpStageMain";
        _bmpChoiceWF.name    = "_bmpChoiceWF";
        _bmpChoiceCF.name    = "_bmpChoiceCF";
    }
    
    public function _defineShape (objRef :Object , objX :int , objY :int  , objW :int, objH :int,
                                  objType :int   , objColor :uint = 0xF3F3F3, dropShadow :Boolean = true, objAlpha :Number = 1):void
                                  //use width to determine radius if objType == 1
    {
        appStyle = new APP_Style;
        switch (objType)
        {
            case 0: //square
            objRef.graphics.beginFill(objColor, objAlpha);
            objRef.graphics.drawRect(objX, objY, objW, objH);
            objRef.graphics.endFill();
            
            if (dropShadow == true)
            {
                objRef.filters = [appStyle._addShadow(1)];
            }

            break;
            case 1: //circle
            objRef.graphics.beginFill(objColor, objAlpha);
            objRef.graphics.drawCircle(objX, objY, objW);
            objRef.graphics.endFill();
            
            if (dropShadow == true)
            { 
                objRef.filters = [appStyle._addShadow(1)];
            }
            break;
        }  
    }
    
    public function _definePanel (objRef :Object , objX :int  , objY :int , objW :int,
                                  objH :int      , objCol :uint = 0xF3F3F3, dropShadow :Boolean = true):void
    {
        appStyle = new APP_Style;
        
        objRef.graphics.lineStyle(2, 0x666666)
        objRef.graphics.beginFill(objCol);
        objRef.graphics.drawRect(objX, objY, objW, objH);
        objRef.graphics.endFill();

        if (dropShadow == true)
        {
            objRef.filters = [appStyle._addShadow(2)];
        }
    }
    
    public function _defineLabel (objRef :Object , txtVar :String , objX :int , objY :int, fontSize :int = 12,
                                  fontCol :uint = appDefine.LBL_TEXT , shadDepth :int = 1, dropShadow :Boolean = true):void
    {
        appStyle = new APP_Style;
        appDefine = new APP_Define;
        
        objRef.autoSize = TextFieldAutoSize.LEFT;
        objRef.mouseEnabled = false;
        objRef.selectable = false;
        objRef.text = txtVar;
        objRef.x = objX;
        objRef.y = objY;
        
        objRef.setTextFormat(new TextFormat("Arial", fontSize, fontCol));
        
        if (dropShadow == true)
        {
            objRef.filters = [appStyle._addShadow(shadDepth)];
        }
            
    }
    
    public function _defineBtn (btnRef :Object , txtRef :Object , txtVar :String , objX :int , objY :int,
                                objW :int = 80 , objH :int = 20 , dropShadow :Boolean = true , btnType :int = 0):void 
                                  //@btnType: 0 = normal, 1 = drop-down ...
    {
        appStyle = new APP_Style;
        appDefine = new APP_Define;
        
        switch (btnType)
        {
            case 0:
            btnRef.graphics.lineStyle(2, appDefine.LBL_TEXT);
            btnRef.graphics.beginFill(appDefine.BTN_FACE);
            btnRef.graphics.drawRect(objX, objY, objW, objH);
            btnRef.graphics.endFill();
            
            txtRef.x = objX;
            txtRef.y = objY;  
            txtRef.text = txtVar;
            txtRef.selectable = false;
            txtRef.mouseEnabled = false;
            txtRef.width = btnRef.width-4;
            txtRef.height = btnRef.height-4;
            txtRef.autoSize = TextFieldAutoSize.CENTER;
            txtRef.x+=2;
            txtRef.y+=1;

            txtRef.setTextFormat(new TextFormat("Arial", 10, appDefine.LBL_TEXT));
            
            if (dropShadow == true)
            {
                btnRef.filters = [appStyle._addShadow(1)];
                txtRef.filters = [appStyle._addShadow(1)]; 
            }

            break;
        }
    }
    
    public function _traceMsg(msg:String, x:int = 10, y:int = 10) :void
    {
        _defineLabel(_txtTrace, msg, x, y);
    }
}

class APP_Style {
    import flash . filters . *;
    
    private var appDefine : APP_Define;
    private var appStyle  : APP_Style;

    public function _addShadow(sDepth:Number, KO:Boolean = false):DropShadowFilter
    {
        appDefine = new APP_Define;
        
        return new DropShadowFilter(sDepth, 45, appDefine.DROPSHADOW, 1, sDepth, sDepth, .3, 1, KO);
    }

}