/**
 * Copyright NiFiZ ( http://wonderfl.net/user/NiFiZ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kCAo
 */

// eclipse

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.text.TextField;
    import flash.filters.*;

    import frocessing.color.ColorHSV;
    [SWF(width="465", height="465", backgroundColor="0x000000" ,frameRate=1 )]

    public class Main extends Sprite {
        public function Main() {
            var cor:Corona = new Corona( 465,465 );
            addChild(cor);
        }
    }
}

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.TextField;
import flash.filters.*;

function createCoronaPiece( radius:Number ):Sprite
{
    var sp:Sprite = new Sprite();

    sp.graphics.beginFill(0xeeeeff);
    var i:int;
    var angle:Number;
    var ht:Number = Math.random() * radius;
    sp.graphics.moveTo( Math.cos( 0 ) * ht, Math.sin( 0 ) * ht );
    for( i=0;i < 16; ++ i )
    {
        angle = Math.PI*2 * i/32 - Math.PI/2;
        sp.graphics.lineTo( Math.cos( angle ) * ht, Math.sin( angle ) * ht );
        ht = Math.random() * radius/2 + radius/2;
    }
    sp.graphics.endFill();
    sp.filters = [new BlurFilter(Math.random()*radius+radius/2,0,8)];
            
    return sp;
}

class Corona extends Bitmap
{
    private var vel:Number = 1;
    private var radius:Number = 50;
    private var fill:Sprite;
    public function Corona( sx:uint,sy:uint )
    {
        addEventListener(Event.ENTER_FRAME, update);
        bitmapData = new BitmapData( sx,sy,true,0 );

    }
    public function update(e:Event):void
    {
        bitmapData.fillRect( bitmapData.rect,0 );
        var buf1:BitmapData = new BitmapData(bitmapData.rect.width,bitmapData.rect.height,true,0);
        var i:int;
        // コロナ部分（重い）
        for( i=0;i<40;++i )
        {
            var rot:Number = Math.random() * 2.0 * Math.PI;
            buf1.fillRect( bitmapData.rect,0 );
            buf1.draw( createCoronaPiece(radius),new Matrix( 1,0,0,1,bitmapData.rect.width/2,bitmapData.rect.height/2 ),null,"add" );
            var mat:Matrix = new Matrix( 1,0,0,1,-bitmapData.rect.width/2,-bitmapData.rect.height/2 );
            mat.concat( new Matrix( Math.cos(rot),Math.sin(rot),-Math.sin(rot),Math.cos(rot),0,0 ) );
            mat.concat( new Matrix( 1,0,0,1, bitmapData.rect.width/2, bitmapData.rect.height/2 ) );
            bitmapData.draw( buf1,mat,null,"add" );
        }
        bitmapData.applyFilter( bitmapData,bitmapData.rect,new Point(0,0),new BlurFilter(8,8,4) );
        
        // 月の影
        var fill:Sprite = new Sprite();
        fill.graphics.clear();
        fill.graphics.beginFill(0x0f0f0f);
        fill.graphics.drawCircle( 0,0, radius );
        fill.graphics.endFill();
        bitmapData.draw( fill,new Matrix(1,0,0,1,bitmapData.rect.width/2,bitmapData.rect.height/2) );

        // 薄ーいglow
        fill.filters = [ new GlowFilter( 0xeeFFFF,1.0,radius*4,radius*4,1,2 )];
        bitmapData.draw( fill,new Matrix(1,0,0,1,bitmapData.rect.width/2,bitmapData.rect.height/2),null,"add" );
        //bitmapData.applyFilter( bitmapData,bitmapData.rect,new Point(0,0),new BlurFilter(2,2,1) );// ちょっとぼかす
    }
}
