/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kBSi
 */

// forked from 178ep3's RoundPolygon
//		drawRoundPolygon( Graphics , 丸みレベル(0～10) , 直径 , 角数);
//		7角形が何か変だ。。 >>>> getPoint()のiの型をuint→Number
//		丸みレベルは、　0で丸み無し、　10で完全に丸(10だと何か変)
//		普通の多角形なら drawPolygon( Graphics , 直径 , 角数);
package
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.geom.Point;
	
	public class ExRoundPolygon extends Sprite
	{
		public function ExRoundPolygon()
		{
			var i:uint=0;
			var q:uint=0;
			for(i=0; i<3; i++)
			{
				for(q=0; q<3; q++)
				{
					var roundPolygon:Shape = addChild(new Shape())as Shape;
					roundPolygon.x = 75 + q*150;
					roundPolygon.y = 75 + i*150;
//					塗りや線を設定して
					roundPolygon.graphics.beginFill(Math.random()*0xffffff);
//					PolygonクラスのdrawRoundPolygonに設定を渡す
					Polygon.drawRoundPolygon(roundPolygon.graphics,5,60,i*3+q+3);
				}
			}
		}

	}
}
	import flash.geom.Point;
	import flash.display.Graphics;

class Polygon
{
	public function Polygon(){}
	
	public static function drawPolygon(target:Graphics,width:Number,polygon:uint):void
	{
		var list:Array = getPoint(width,polygon);
		var i:uint=0;
		var len:uint = list.length;
		
		target.moveTo(list[0].x,list[0].y);
		for(i=1; i<len; i++)
		{
			target.lineTo(list[i].x,list[i].y);
		}
		target.lineTo(list[0].x,list[0].y);
		target.endFill();
	}
	
	public static function drawRoundPolygon(target:Graphics,round:uint,width:Number,polygon:uint):void
	{
		var con:Array = getPoint(width,polygon);
		var anc:Array = [];
		var i:uint=0;
		if(round>10)round=10;
		var n:Number = round/2.5;
		var cLen:uint = con.length;
		
		for(i=0; i<cLen; i++)
		{
			var p:Point = new Point(0,0);
			var q:Point = new Point(0,0);
			if(i==0)
			{
				p = Point.interpolate(con[cLen-1],con[0],n);
				q = Point.interpolate(con[1],con[0],n);
			}
			else if(i==cLen-1)
			{
				p = Point.interpolate(con[i-1],con[i],n);
				q = Point.interpolate(con[0],con[i],n);
			}
			else 
			{
				p = Point.interpolate(con[i-1],con[i],n);
				q = Point.interpolate(con[i+1],con[i],n);
			}
			anc.push(p);
			anc.push(q);
		}
		
		var len:uint = anc.length;
		target.moveTo(anc[0].x,anc[0].y);
		for(i=1; i<len-2; i+=2)
		{
			target.curveTo(con[(i-1)/2].x,con[(i-1)/2].y,anc[i].x,anc[i].y);
			target.lineTo(anc[i+1].x,anc[i+1].y);
		}
		target.curveTo(con[cLen-1].x,con[cLen-1].y,anc[len-1].x,anc[len-1].y);
		target.lineTo(anc[0].x,anc[0].y);
		target.endFill();
	}
	
	private static function getPoint(width:Number,polygon:uint):Array
	{
		var list:Array = [];
		var angle:Number = 360/polygon;
		var i:Number=0;
		for(i=0; i<360; i+=angle)
		{
			var p:Point = Point.polar(width,i*Math.PI/180);
			list.push(p);
		}
		return list
	}
}