/**
 * Copyright yaha ( http://wonderfl.net/user/yaha )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kB8x
 */

var pt:Point;
var center:Point = new Point(stage.stageWidth/2, stage.stageHeight/2);
var len:uint;
var radian:Number = 1*Math.PI/180;
var angle:Number = 0;
var lineSize:uint = 1;
var lineColor:uint;

var container:Shape = new Shape();


/*---
Circle
---------------------------------------*/
function createCircle():void{
    //一度描いたものを消してから
    container.graphics.clear();
    //ステージに表示
    addChild(container);
    //角度が360度になるまで
    while(angle<=2*Math.PI){
        //線の色：ランダム
        lineColor = Math.random()*0xFFFFFF;
        //線の色：白
        //lineColor = 0xFFFFFF;
        
        //線の長さ：ランダム
        len = Math.round(Math.random()*50);
        //一定
        //len = 50;
        
        //中心から伸びる方向（角度）
        angle += radian;
        //angleの角度からlenの長さに伸びた先のポイントを取得
        pt = Point.polar(len,angle);
        //中心から伸びるようにするため、基準点をセンターに
        pt.offset(center.x, center.y);
        //ラインスタイル
        container.graphics.lineStyle(lineSize,lineColor);
        //線の出発点
        container.graphics.moveTo(center.x,center.y);
        //終了地点
        container.graphics.lineTo(pt.x,pt.y);
    }
    //角度を0に戻す
    angle = 0;
}

circle_btn.addEventListener(MouseEvent.MOUSE_DOWN,MOUSE_DOWN_CIRCLE);
circle_btn.addEventListener(MouseEvent.MOUSE_UP,MOUSE_UP_CIRCLE);

//ステージ上でマウスを押すとスタート
function MOUSE_DOWN_CIRCLE(event:MouseEvent):void{
    stage.addEventListener(Event.ENTER_FRAME, ENTER_FRAME_CIRCLE);
}
//マウスを離すとストップ（消える）
function MOUSE_UP_CIRCLE(event:MouseEvent):void{
    stage.removeEventListener(Event.ENTER_FRAME, ENTER_FRAME_CIRCLE);
    container.graphics.clear();
}
//マウスが押されてる間
function ENTER_FRAME_CIRCLE(event:Event):void{
    createCircle();
}


/*---
Rectangle
---------------------------------------*/
//いちばん小さい（内側）長方形の大きさ(初期値)
var size:uint = 10;
//何個長方形作るか
var count:uint = 20;
//長方形の間隔
var margin:uint = 2;

function createRect(){
    container.graphics.clear();
    //長方形エリアを新たに（外で作るとinflateの影響を受け続けてしまう）
    //2回目以降のリセットの
    var rect:Rectangle = new Rectangle(stage.stageWidth/2-size/2, stage.stageHeight/2-size/2,size,size);
    addChild(container);
    for(var i:Number = 1;i<=count;i++){
        lineColor=Math.random()*0xFFFFFF;
        container.graphics.lineStyle(lineSize,lineColor);
        //長方形をRectangleを使ってかく
        container.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        
        //長方形エリアを縦横1ピクセル広げる
        rect.inflate(margin,margin);
    }
}

rect_btn.addEventListener(MouseEvent.MOUSE_DOWN,MOUSE_DOWN_RECT);
rect_btn.addEventListener(MouseEvent.MOUSE_UP,MOUSE_UP_RECT);

function MOUSE_DOWN_RECT(event:MouseEvent):void{
    stage.addEventListener(Event.ENTER_FRAME, ENTER_FRAME_RECT);
}
function MOUSE_UP_RECT(event:MouseEvent):void{
    stage.removeEventListener(Event.ENTER_FRAME, ENTER_FRAME_RECT);
    container.graphics.clear();
}
function ENTER_FRAME_RECT(event:Event):void{
    createRect();
}
