/**
 * Copyright ricserje ( http://wonderfl.net/user/ricserje )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k8X4
 */

// forked from bunta's forked from: [PV3D] Vector Font on 3D World
// forked from clockmaker's [PV3D] Vector Font on 3D World
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.filters.*;
    import flash.utils.getTimer;
    import org.papervision3d.core.clipping.FrustumClipping;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.MovieMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.core.effects.view.ReflectionView;
    import caurina.transitions.properties.CurveModifiers;
    import caurina.transitions.Tweener;
    
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.particles.Particle;
    import idv.cjcat.stardust.common.particles.ParticleIterator;
    import idv.cjcat.stardust.threeD.papervision3d.renderers.PV3DDisplayObject3DRenderer;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0x001122")]
    
        
    public class Main extends ReflectionView
    {
        static private const ROUND           :uint = 2000;
        static private const OBJ_AMOUNT      :uint = 30;
        static private const CAMERA_POSITION :uint = 2000;
        static private const PLANE_SIZE      :uint = 3000;
        static private const COLOR_LIST      :Array  = [0xffffff, 0x0066CC, 0x0099FF, 0x33CCFF];
        
        private var wraps:Array = [];
        private var words:Array = [];
        private var wrapRoot:DisplayObject3D;
        private var _emitter:PlaneEmitter; //stardust
        
        public function Main():void 
        {
            super(0, 0, true , false, CameraType.TARGET);
            
            camera.zoom = 1.5;
            camera.focus = 200;
            
            // refrection
            surfaceHeight = 0;
            viewportReflection.filters = [new BlurFilter(2, 2, 3)];
            viewportReflection.alpha = .25;
            
            // safe polygon
            //renderer.clipping = new FrustumClipping(FrustumClipping.NEAR)
            
            // add material
            var compMat:CompositeMaterial = new CompositeMaterial();
            compMat.addMaterial(new WireframeMaterial(0xEEEEEE));
            compMat.addMaterial(new ColorMaterial(0xEEEEEE, 0.1));
            
            var planeB:Plane = new Plane(compMat, PLANE_SIZE, PLANE_SIZE, 4, 4);
            planeB.pitch(90)
            scene.addChild(planeB);
            
            var mt:CompositeMaterial = new CompositeMaterial();
            mt.addMaterial( new ColorMaterial(0x0, 0.6) );
            mt.addMaterial( new WireframeMaterial(0xFF0000) );
            var cube:Cube = scene.addChild(new Cube(new MaterialsList( { all:mt } ), 200, 200, 200)) as Cube;
            cube.x= 0;
            cube.y = 130;
                
            
            wrapRoot = scene.addChild(new DisplayObject3D());
            
            // particle motion
            var cnt:int = 0;
            for (var i:int = 0; i < OBJ_AMOUNT; i++ )
            {
                var wrap:DisplayObject3D = wrapRoot.addChild(new DisplayObject3D());
                wrap.y = ROUND * Math.random();
                wraps.push(wrap);
                
                // A-Z
                var char:String = String.fromCharCode(65 + 25 * Math.random() | 0);
                
                // letter
                var lettermat:Letter3DMaterial = new Letter3DMaterial();
                lettermat.fillColor = COLOR_LIST[ COLOR_LIST.length * Math.random() | 0];
                var word:Text3D = new Text3D(char , new HelveticaBold() , lettermat);
                
                word.z = 500 * Math.random() + 500;
                word.rotationY = 360 * Math.random();
                word.scale = 5 * Math.random() + 0.5;
                wrap.addChild(word);
                
                words.push(word)
            }
            
           //stardust
            var _sdcontainer:DisplayObject3D = scene.addChild(new DisplayObject3D()); //stardust container
            _emitter = new PlaneEmitter(new SteadyClock(0.1));
            var renderer:PV3DDisplayObject3DRenderer = new PV3DDisplayObject3DRenderer(_sdcontainer);
            renderer.addEmitter(_emitter);

            stage.addEventListener(Event.ENTER_FRAME, loop)
        }
        
        private function loop(event:Event = null):void 
        {
            var i:int = wraps.length;
            while (i--) wraps[i].rotationY += i / 25;
            
            i = words.length;
            while (i--) words[i].rotationY += 4;
            
            camera.x += (CAMERA_POSITION * Math.sin(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.x) * .1;
            camera.z += (CAMERA_POSITION * Math.cos(mouseX / stage.stageWidth * 360 * Math.PI / 180) - camera.z) * .1;
            camera.y += (CAMERA_POSITION * mouseY / stage.stageHeight - camera.y) * .1;
            
            singleRender();
            
            // render particule sim
            _emitter.step();
        }
    }
}



//------------------------------------------------------------------------------------------------

import frocessing.color.ColorHSV;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.CompositeAction;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.threeD.actions.Deflect3D;
import idv.cjcat.stardust.threeD.actions.Gravity3D;
import idv.cjcat.stardust.threeD.actions.Move3D;
import idv.cjcat.stardust.threeD.actions.Spin3D;
import idv.cjcat.stardust.threeD.deflectors.PlaneDeflector;
import idv.cjcat.stardust.threeD.emitters.Emitter3D;
import idv.cjcat.stardust.threeD.fields.UniformField3D;
import idv.cjcat.stardust.threeD.initializers.DisplayObjectClass3D;
import idv.cjcat.stardust.threeD.initializers.Omega3D;
import idv.cjcat.stardust.threeD.initializers.Position3D;
import idv.cjcat.stardust.threeD.initializers.Rotation3D;
import idv.cjcat.stardust.threeD.initializers.Velocity3D;
import idv.cjcat.stardust.threeD.zones.SinglePoint3D;
import idv.cjcat.stardust.threeD.zones.SphereCap;
import org.papervision3d.core.proto.MaterialObject3D;
import org.papervision3d.materials.WireframeMaterial;
import org.papervision3d.objects.primitives.Plane;

//------------------------------------------------------------------------------------------------

/**
 * プレーンをひたすら出し続けるEmitter
 * 
 * @author    paq89
 */
class PlaneEmitter extends Emitter3D
{
    public function PlaneEmitter(clock:Clock)
    {
        super(clock);
        
        var doc3D:DisplayObjectClass3D = new DisplayObjectClass3D();
        doc3D.displayObjectClass = PlaneParticle;
        doc3D.constructorParams = [null, 100, 100, 1, 1];
        
        var cap:SphereCap = new SphereCap(0, 0, 0, 50, 50, 15);
        cap.rotationX = 180;
        
        var rotationRand:UniformRandom = new UniformRandom(0, 180);
        var omegaRand:UniformRandom = new UniformRandom(0, 4);
        
        // パーティクルの属性を定義
        addInitializer(doc3D);
        addInitializer(new Life(new UniformRandom(200, 0)));
        addInitializer(new Scale(new UniformRandom(1, 1.2)));
        addInitializer(new Position3D(new SinglePoint3D(0, 0, 0)));
        addInitializer(new Velocity3D(cap));
        addInitializer(new Rotation3D(rotationRand, rotationRand, rotationRand));
        addInitializer(new Omega3D(omegaRand, omegaRand, omegaRand));
        
        // 重力を定義
        var field:UniformField3D = new UniformField3D(0, -1, 0);
        var gravity:Gravity3D = new Gravity3D();
        gravity.addField(field);
        
        // デフレクトを定義
        var deflect:Deflect3D = new Deflect3D();
        deflect.addDeflector(new PlaneDeflector(0, 90, 0, 0, 1, 0));
        
        // パーティクルのアクションを定義
        addAction(gravity);
        addAction(deflect);
        addAction(new Age());
        addAction(new DeathLife());
        addAction(new Move3D());
        addAction(new Spin3D());
        addAction(new ScaleCurve(5, 20));
    }
}

class PlaneParticle extends Plane
{
    static private var col:int = 180;
    public function PlaneParticle(material:MaterialObject3D = null, width:Number = 0, height:Number = 0, segmentsW:Number = 0, segmentsH:Number = 0):void 
    {
        var color:ColorHSV = new ColorHSV(col += 2, 0.8);
        
        // マテリアルを作成
        var mat:WireframeMaterial = new WireframeMaterial(color.value);
        mat.doubleSided = true;
        
        super(mat, width, height, segmentsW, segmentsH);
        
        useOwnContainer = true;
        //if (particlesList){ particlesList.push(this); visible = false;}
    }
}